{$R+,N-,G+,W-}

unit wbibbmp;

interface

uses WinProcs,WinTypes,Strings,WinDos,ShellApi,
     bibfile,rc_id,bibstrg,wbibdisp,lfnunit;

const
  GrExt_None= 0;
  GrExt_BMP = 1;
  GrExt_PCX = 2;
  GrExt_TGA = 3;
  GrExt_GIF = 4;
  GrExt_JPG = 5;
  GrExt_Ico = 6;
  GrExt_WMF = 7;
  GrExt_All = 8;
  GrExt_Last= 8;

type
  LongType = record
    case Word of
      0: (Ptr: Pchar);
      1: (Long: Longint);
      2: (Lo: Word; Hi: Word);
  end;
  IntGraphRec = record
    Desc,Ext: PChar;
    DescID: integer;
    on,Compressed: boolean;
  end;

  { When you resourcelock an HICON or HCURSOR you'll get a pointer to a
    TCursorIconInfo structure. }
  TCursorIconInfo = record
    ptHotSpot: TPoint;
    wWidth, wHeight, wWidthBytes: Word;
    byPlanes, byBitsPix: Byte;
  end;
  PCursorIconInfo = ^TCursorIconInfo;

const
  IntGraphList: array[1..GrExt_Last] of IntGraphRec =(
    (Desc:Nil; Ext:'*.bmp;*.dib'; DescID:GrDesc_BMP; on: true; Compressed: false),
    (Desc:Nil; Ext:'*.pcx';       DescID:GrDesc_PCX; on: true; Compressed: false),
    (Desc:Nil; Ext:'*.tga';       DescID:GrDesc_TGA; on: true; Compressed: false),
    (Desc:Nil; Ext:'*.gif';       DescID:GrDesc_GIF; on: true; Compressed: true ),
    (Desc:Nil; Ext:'*.jpg';       DescID:GrDesc_JPG; on: true; Compressed: true ),
    (Desc:Nil; Ext:'*.ico;*.dll;*.exe';
                                  DescID:GrDesc_Ico; on: true; Compressed: false),
    (Desc:Nil; Ext:'*.wmf';       DescID:GrDesc_WMF; on: true; Compressed: false),
    (Desc:Nil; Ext:Nil;           DescID:GrDesc_All; on: true; Compressed: false)
  );


procedure GetBitLine(Buf: LongType; LineBuffer: PChar;
                     LineSize,LineBufSize: word; Y: integer);
procedure DrawBitLine(Buf: LongType; LineBuffer: PChar;
                      LineSize,LineBufSize: word; Y: integer);
function  LoadBMPDIB(Name: PChar; var Width, Height: LongInt): THandle;
function  IconToDIB (Icon: HIcon; var Width,Height: longint) : THandle;
function  LoadIcoDIB(Name: PChar; IconIndex: integer;
                     var Width, Height: LongInt): THandle;
function  ImageType(FName: PChar): integer;
function  FlipDIB(SrcDIB: THandle; Hor,Vert: boolean): THandle;
function  BitmapToDIB(Bitmap: HBitmap): THandle;

implementation

procedure AHIncr; far; external 'KERNEL' index 114;

procedure GetBitLine(Buf: LongType; LineBuffer: PChar;
                     LineSize,LineBufSize: word; Y: integer);
var
  Start,FromAddr: LongType;
  l: word;
begin
  Start.Long:=Buf.Lo+Y*LineSize;
  FromAddr.Hi := Buf.Hi + (Start.Hi * Ofs(AHIncr));
  FromAddr.Lo := Start.Lo;
  if FromAddr.Lo>$FFFF-LineBufSize then  { Crossing a segment boundary }
  begin
    l:=$FFFF-FromAddr.Lo+1;
    Move(FromAddr.Ptr^,LineBuffer^,l);
    FromAddr.Hi:=FromAddr.Hi+Ofs(AHIncr); FromAddr.Lo:=0;
    Move(FromAddr.Ptr^,LineBuffer[l],LineBufSize-l);
  end else Move(FromAddr.Ptr^,LineBuffer^,LineBufSize);
end;            { GetBitLine }

procedure DrawBitLine(Buf: LongType; LineBuffer: PChar;
                   LineSize,LineBufSize: word; Y: integer);
var
  Start,ToAddr: LongType;
  l: word;
begin
  Start.Long:=Buf.Lo+Y*LineSize;
  ToAddr.Hi := Buf.Hi + (Start.Hi * Ofs(AHIncr));
  ToAddr.Lo := Start.Lo;
  if ToAddr.Lo>$FFFF-LineBufSize then  { Crossing a segment boundary }
  begin
    l:=$FFFF-ToAddr.Lo+1;
    Move(LineBuffer^,ToAddr.Ptr^,l);
    ToAddr.Hi:=ToAddr.Hi+Ofs(AHIncr); ToAddr.Lo:=0;
    Move(LineBuffer[l],ToAddr.Ptr^,LineBufSize-l);
  end else Move(LineBuffer^,ToAddr.Ptr^,LineBufSize);
end;            { DrawBitLine }

function LoadBMPDIB(Name: PChar; var Width, Height: LongInt): THandle;
var
  DIBSize,TempReadSize: longint;
  Bits: PChar;
  F: file;
  Header: PBitMapInfoHeader;
  FileHeader: TBitmapFileHeader;
  DIB: THandle;
  l: word;
begin
  LoadBMPDIB:=0; DIB:=0;
  if not LFNFileExist(StrPas(Name)) then Exit;
  DIBSize:=FileSize(StrPas(Name))-sizeof(TBitmapFileHeader);
  LFNNew(f,false); LFNAssign(F,StrPas(Name));
  if LFNReset(F, 1)<>0 then
  begin
    LFNDispose(F); Exit;
  end;

  BlockRead(F,FileHeader,sizeof(TBitmapFileHeader),l);
  if (l<>sizeof(TBitmapFileHeader)) or
     (FileHeader.bfType<>$4D42) then    { BM }
  begin
    LFNDispose(F); Exit;
  end;

  DIB:=GlobalAlloc(GHND,DIBSize); if DIB=0 then
  begin
    LFNDispose(F); Exit;
  end;
  Bits:=GlobalLock(DIB);
  Header:=PBitmapInfoHeader(Bits);

  TempReadSize := DIBSize;
  while TempReadSize > 0 do
  begin
    if TempReadSize > $8000 then
    begin
      BlockRead(F, Bits^, $8000);
      if Ofs(Bits^) = $8000 then
         Bits := Ptr(Seg(Bits^) + Ofs(AHIncr), 0)
      else
         Bits := Ptr(Seg(Bits^), $8000);
    end else
      BlockRead(F, Bits^, TempReadSize);
    Dec(TempReadSize, $8000);
  end;
  LFNDispose(F);

  Height:= Header^.biHeight;
  Width := Header^.biWidth;
  GlobalUnlock(DIB);
  LoadBMPDIB:=DIB;
end;                     { LoadBMPDIB }

function IconToDIB(Icon: HIcon; var Width,Height: longint): THandle;
var
  ScreenDC,MemDC: HDC;
  IpIcon: PCursorIconInfo;
  i,PixSize : integer;
  TableSize,BitmapInfoSize,Sel,Offset,ToLoad,Loaded: word;
  BitmapInfo: PBitmapInfo;
  DIB: THandle;
  Bit: LongType;
  TotPixels,LineSize,LineBufSize,Y,X: longint;
  LineBuffer,P: PChar;
  Color: TColorRef;
  hbmpSource: HBitmap;
begin
  Width:=0; Height:=0; IconToDIB:=0; BitmapInfo:=Nil;
  IpIcon:=LockResource(THandle(Icon));
  ScreenDC:=GetDC(0);
  MemDC:=CreateCompatibleDC(ScreenDC);
  hbmpSource := CreateCompatibleBitmap(ScreenDC, IpIcon^.wWidth,
    IpIcon^.wHeight);
  ReleaseDC(0,ScreenDC);

  hbmpSource := SelectObject(MemDC, hbmpSource);
  PatBlt(MemDC, 0, 0, IpIcon^.wWidth, IpIcon^.wHeight, WHITENESS);
  DrawIcon(MemDC,0,0,Icon);
  Width:=IpIcon^.wWidth; Height:=IpIcon^.wHeight;
  TableSize:=0; PixSize:=3;    { TrueColor format }

  LineBufSize:=Width*PixSize;
  LineSize:=LineBufSize;
  if LineSize mod 4 <> 0 then LineSize:=4*(LineSize div 4)+4;

  BitmapInfoSize:=sizeof(TBitmapInfoHeader)+(TableSize)*sizeof(TRGBQuad);
  DIB:=GlobalAlloc(GHND,BitmapInfoSize+LineSize*Height+1024);
  BitmapInfo:=GlobalLock(DIB);
  FillChar(BitmapInfo^,BitmapInfoSize,0);
  with BitmapInfo^ do
  begin
    with bmiHeader do
    begin
      biSize         :=sizeof(TBitmapInfoHeader);
      biWidth        :=Width;
      biHeight       :=Height;
      biPlanes       :=1;
      biBitCount     :=24;
      biCompression  :=BI_RGB;
      biSizeImage    :=0;
      biXPelsPerMeter:=2000;
      biYPelsPerMeter:=2000;
      biClrUsed      :=0;
      biClrImportant :=0;
    end;
  end;
  Bit.ptr:=PChar(BitmapInfo)+BitmapInfoSize;
  GetMem(LineBuffer,LineBufSize);

  for Y:=0 to Height-1 do
  begin
    for X:=0 to Width-1 do
    begin
      Color:=GetPixel(MemDC,X,Y);
{      logstring('('+num2str(y)+','+num2str(x)+') = '+num2str(Color));}
      LineBuffer[3*X]  :=char(GetBValue(Color));
      LineBuffer[3*X+1]:=char(GetGValue(Color));
      LineBuffer[3*X+2]:=char(GetRValue(Color));
    end;
    DrawBitLine(Bit,LineBuffer,LineSize,LineBufSize,Height-Y-1);
  end;
  FreeMem(LineBuffer,LineBufSize);

  GlobalUnlock(DIB);
  IconToDIB:=DIB;
  hbmpSource := SelectObject(MemDC, hbmpSource);
  DeleteDC(MemDC);
  UnlockResource(THandle(Icon));
end;                       { IconToDIB }

function LoadIcoDIB(Name: PChar; IconIndex: integer;
                    var Width, Height: LongInt): THandle;
var
  Icon: HIcon;
  P: PChar;
  code: integer;
  S: string[10];
  ch: char; 
begin
  LoadIcoDIB:=0; Width:=0; Height:=0; ch:=#0;
  if (Name=Nil) or (Name[0]=#0) then Exit;
  P:=Name+StrLen(Name);
  while (P>Name) and (P^ in ['0'..'9']) do dec(P);
  Icon:=ExtractIcon(HInstance,Name,IconIndex);
  if ch<>#0 then P^:=ch;
  if (Icon=0) or (Icon=1) then Exit;
  LoadIcoDIB:=IconToDIB(Icon,Width,Height);
  DestroyIcon(Icon);
end;                 { LoadIcoDIB }

function ImageType(FName: PChar): integer;
var
  Dir,Name: PChar;
  Ext: array[0..31] of char;
  i: integer;

function FoundIn(Ext: PChar; Ind: integer): boolean;
var
  P0,P,P1: PChar;
  Found: boolean;
begin
  FoundIn:=false;
  if (IntGraphList[Ind].Ext^=#0) or not IntGraphList[Ind].on then Exit;
  P0:=StrNew(IntGraphList[Ind].Ext); P:=P0; Found:=false;
  while (not Found) and (P<>Nil) do
  begin
    if P^='*' then inc(P);
    P1:=StrScan(P,';'); if P1<>Nil then P1^:=#0;
    Found:=StrComp(Ext,P)=0;
    if P1<>Nil then P:=P1+1 else P:=Nil;
  end;
  StrDispose(P0);
  FoundIn:=Found;
end;               { FoundIn }

begin
  ImageType:=GrExt_None;
  if (FName=Nil) or (StrLen(FName)<5) then Exit;
  GetMem(Name,256); GetMem(Dir,256);
  FileSplit(FName,Dir,Name,Ext);
  FreeMem(Dir,256); FreeMem(Name,256);
  if StrLen(Ext)<2 then Exit;
  StrLower(Ext);

  for i:=GrExt_None+1 to GrExt_All-1 do
    if FoundIn(Ext,i) then ImageType:=i;
end;                       { ImageType }

function FlipDIB(SrcDIB: THandle; Hor,Vert: boolean): THandle;
type
  TBitLine = array[0..65520] of byte;
  PBitLine = ^TBitLine;
var
  BBits,NBits,line,tmpline: PChar;
  BitLine: PBitLine;
  BBase,NBase: LongType;
  Header: PBitMapInfoHeader;
  NewDIB: THandle;
  LineBufSize,LineSize,i,j,BitmapInfoSize,TableSize,NumBytes: word;
  FromInd,ToInd,PixPerByte: word;
  FromShft,ToShft,Mask,FromMask,ToMask: byte;
  buf: array[0..2] of byte;
  tmp: string;
begin
  FlipDIB:=0; if (SrcDIB=0) or not (Hor or Vert) then Exit;
  Header:=GlobalLock(SrcDIB);
  TableSize:=0; if Header^.biBitCount<16 then
                            TableSize:=1 SHL Header^.biBitCount;
  BitmapInfoSize:=Header^.biSize+TableSize*sizeof(TRGBQuad);
  NewDIB:=GlobalAlloc(GHND,GlobalSize(SrcDIB));
  NBits:=GlobalLock(NewDIB);
  Move(Header^,NBits^,BitmapInfoSize);
  BBits:=PChar(Header)+BitmapInfoSize;
  NBits:=NBits+BitmapInfoSize;
  BBase.Ptr:=BBits; NBase.Ptr:=NBits;

  NumBytes:=Header^.biBitCount div 8; if NumBytes=0 then NumBytes:=1;
  PixPerByte:=8 div Header^.biBitCount;
  LineBufSize:=Header^.biWidth*Header^.biBitCount;
  if LineBufSize mod 8<>0 then LineBufSize:=8*((lineSize div 8)+1);
  LineBufSize:=LineBufSize div 8;
  LineSize:=LineBufSize;
  if LineSize mod 4<>0 then LineSize:=4*((lineSize div 4)+1);
  GetMem(Line,LineSize); GetMem(tmpline,linesize);
  FillChar(Line^,LineSize,#1);
  BitLine:=PBitLine(Line);
  for i:=0 to Header^.biHeight-1 do
  begin
    GetBitLine(BBase,Line,LineSize,LineBufSize,i);
    {
    tmp:='';
    for j:=0 to LineBufSize-1 do tmp:=tmp+byte2hex(byte(Line[j]))+' ';
    logstring(word2hex(i)+': '+tmp);
    }
    if Hor then
    with Header^ do
    begin
      Mask:=1;
      for j:=2 to biBitCount do Mask:=Mask or (Mask shl 1);
      if biBitCount<8 then    { monochrome and 16 color }
      for j:=0 to (biWidth div 2)-1 do
      begin
        FromInd :=j div PixPerByte;
        FromShft:=j mod PixPerByte;
        FromMask:=Mask SHL FromShft;
        ToInd :=(biWidth-j-1) div PixPerByte;
        ToShft:=((biWidth-j-1) mod PixPerByte);
        ToMask:=Mask SHL ToShft;
        Buf[0]:=(BitLine^[FromInd] and FromMask) SHR FromShft;
        Buf[1]:=(BitLine^[ToInd] and ToMask) SHR ToShft;
        BitLine^[FromInd]:=BitLine^[FromInd] and not FromMask and (Buf[1] SHL FromShft);
        BitLine^[ToInd]  :=BitLine^[ToInd]   and not ToMask   and (Buf[0] SHL ToShft);
      end else if biBitCount>=8 then   { 256 color and TrueColor }
      for j:=0 to (biWidth div 2)-1 do
      begin
        FromInd:=j*NumBytes;
        ToInd:=(biWidth-j-1)*NumBytes;
        Move(line[FromInd],Buf[0],NumBytes);
        Move(line[ToInd],line[FromInd],NumBytes);
        Move(Buf[0],line[ToInd],NumBytes);     
      end;
    end;
    if Vert then
      DrawBitLine(NBase,Line,LineSize,LineBufSize,Header^.biHeight-i-1)
    else
      DrawBitLine(NBase,Line,LineSize,LineBufSize,i);
  end;
  FreeMem(TmpLine,LineSize); FreeMem(Line,LineSize);
  GlobalUnlock(SrcDIB); GlobalUnlock(NewDIB);
  FlipDIB:=NewDIB;
end;            { FlipDIB }

function BitmapToDIB(Bitmap: HBitmap): THandle;
var
  T2,NewDIB: THandle;
  BInfo: PBitmapInfo;
  BitInfo: TBitmap;
  HeadSize,BitsSize,BitLineSize,DIBLineSize,Copied,RealSize: longint;
  Table,x,i: word;
  BBits,DBits: LongType;
  line,P1: PChar;
  DC: HDC;
begin
  BitmapToDIB:=0; NewDIB:=0;
  GetObject(Bitmap,sizeof(TBitmap),@BitInfo);
  Table:=0; 
  case BitInfo.bmBitsPixel of
    1 : Exit;                 { Currently can't do it }
    4 : Exit;                 { Currently can't do it }
    8 : Table:=256;
    24: Table:=0;
  end;
  HeadSize:=sizeof(TBitmapInfoHeader)+Table*sizeof(TRGBQuad);
  BitLineSize:=BitInfo.bmWidth*BitInfo.bmBitsPixel;
  DIBLineSize:=BitLineSize;
  if BitLineSize mod 8 <> 0 then BitLineSize:=8*(BitLineSize div 8)+8;
  BitLineSize:=BitLineSize div 8;
  if DIBLineSize mod 32 <> 0 then DIBLineSize:=32*(DIBLineSize div 32)+32;
  DIBLineSize:=DIBLineSize div 8;
  BitsSize:=DIBLineSize*BitInfo.bmHeight;
  with BitInfo do
    message(num2str(bmWidth)+'x'+num2str(bmHeight)+','+num2str(BitLineSize)
    +','+num2str(DIBLineSize)+','+num2str(HeadSize));
  NewDIB:=GlobalAlloc(GHND,HeadSize+BitsSize); BInfo:=GlobalLock(NewDIB);
  with BInfo^ do
  begin
    with bmiHeader do
    begin
      biSize         :=sizeof(TBitmapInfoHeader);
      biWidth        :=BitInfo.bmWidth;
      biHeight       :=BitInfo.bmHeight;
      biPlanes       :=BitInfo.bmPlanes;
      biBitCount     :=BitInfo.bmBitsPixel;
      biCompression  :=BI_RGB;
      biSizeImage    :=0;
      biXPelsPerMeter:=2000;
      biYPelsPerMeter:=2000;
      biClrUsed      :=Table;
      biClrImportant :=0;
    end;
    if Table>0 then
    begin
      P1:=PChar(@bmiColors);
      DC:=GetDC(0);
      GetSystemPaletteEntries(DC,0,Table-1,P1^);
      ReleaseDC(0,DC);
      {$R-}
      for i:=0 to Table-1 do
      begin
        x:=bmiColors[i].rgbBlue;
        bmiColors[i].rgbBlue:=bmiColors[i].rgbRed;
        bmiColors[i].rgbRed:=X;
        bmiColors[i].rgbReserved:=0;
      end;
      {$R+}
    end;
  end;

  T2:=GlobalAlloc(GHND,BitsSize); BBits.Ptr:=GlobalLock(T2);
  GetBitmapBits(Bitmap,BitsSize,BBits.Ptr);
  DBits.Ptr:=PChar(BInfo)+HeadSize;
  GetMem(line,DIBLineSize); FillChar(Line^,DIBLineSize,0);
  for i:=0 to BitInfo.bmHeight-1 do
  begin
    logstring(num2str(i));
    GetBitLine (BBits,Line,BitLineSize,BitLineSize,i);
    DrawBitLine(DBits,Line,DIBLineSize,BitLineSize,BitInfo.bmHeight-1-i);
  end;
  GlobalUnlock(NewDIB); GlobalUnlock(T2); GlobalFree(T2);
  FreeMem(line,DIBLineSize);
  BitmapToDIB:=NewDIB;
end;                       { BitmapToDIB }

end.
