dnl
dnl Checks for the byte order of the target machine, allowing the user
dnl to specify it on the command line if cross compiling
dnl This macro defines the same symbols as AC_C_BIGENDIAN
dnl
AC_DEFUN(AC_CHECK_BYTE_ORDER, [
  dnl we need to know if we're cross compiling
  AC_REQUIRE([AC_PROG_CC])
  AC_ARG_WITH(target-byte-order,
    [  --with-target-byte-order=ORDER
                          set target byte order, if cross-compiling
                          (ORDER is one of lsb, msb, auto)],
  byteorder="$withval", byteorder=auto)
case "$byteorder" in
  lsb|msb)
    if test "$cross_compiling" = no; then
      AC_MSG_WARN([you should force the byte order only when cross-compiling])
    fi
    ;;
  auto)
    if test "$cross_compiling" = yes; then
      AC_MSG_ERROR([specify the target byte order --with-target-byte-order])
    fi
    ;;
  *)
    AC_MSG_WARN([unknown byte order \`$byteorder', set to \`auto'])
    byteorder=auto
    ;;
esac
AC_MSG_CHECKING([for target byte order])
if test "$byteorder" = auto; then
AC_CACHE_VAL(ac_cv_byteorder, [
  AC_TRY_RUN([#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
main(){
#if defined(BYTE_ORDER) && defined(LITTLE_ENDIAN) && defined(BIG_ENDIAN)
  FILE *f;
  f = fopen("conftestval", "w");
  if(!f) exit(1);
#if BYTE_ORDER == LITTLE_ENDIAN
  fprintf(f, "lsb\n");
  exit(0);
#endif
#if BYTE_ORDER == BIG_ENDIAN
  fprintf(f, "msb\n");
  exit(0);
#endif
#else
  exit(1);
#endif
}], ac_cv_byteorder=`cat conftestval`,
[AC_TRY_RUN([#include <stdio.h>
main() {
  union {
    long l;
    char c[sizeof(long)];
  } u;
  FILE *f;
  f = fopen("conftestval", "w");
  u.l = 1;
  if(u.c[0] == 1) fprintf(f, "lsb\n");
  else if(u.c[sizeof(long)-1] == 1) fprintf(f, "msb\n");
  else fprintf(f, "unknown\n");
  exit(0);
}], ac_cv_byteorder=`cat conftestval`, ac_cv_byteorder=unknown, 
  ac_cv_byteorder=unknown)], ac_cv_byteorder=unknown)
]) dnl end of AC_CACHE_VAL
byteorder="$ac_cv_byteorder"
fi

dnl Now examine what happened
case "$byteorder" in
  lsb) AC_MSG_RESULT([little endian]) ;;
  msb) 
    AC_MSG_RESULT([big endian])
    AC_DEFINE_UNQUOTED(WORDS_BIGENDIAN, 1,
    [Define if your processor stores words with the most significant byte
   first (like Motorola and SPARC, unlike Intel and VAX).])
    ;;
  *)
    AC_MSG_RESULT(unknown)
    AC_MSG_WARN([unable to guess the byte order of this machine])
    AC_MSG_ERROR([specify the target byte order with --with-target-byte-order])
    ;;
esac  
])
