/* EGA2MF.C is Copyright 1990 Humanities and Arts Computing Center */
/* usage: ega2mf [egafontname] [metafont_sourcecode_output_file] */
/* suggestions to ridgeway@blake.acs.washington.edu */

/* history: */
/* v. 1.0 released 4/16/1990 */

#include <stdio.h>
#include <string.h>



/* the charblock structure is used for processing each character */
typedef struct {
               unsigned char column[8];
               } videorow;
typedef struct {
                videorow row[14];
               } charblock;

/* the ega font is a naked 8x14 bitmap 256 chars deep */
typedef struct {
                unsigned char bitmap[14];
                } egachar;

typedef struct {
	       egachar charset[256];
               } egafont;

/* globally accessible area */
charblock editchar;
/* global vars  and strings */
char infilename[128];
char outfilename[128];

jumpout() { exit(1); }

void copyright()
{
  puts("Ega2Mf  Screen font --> METAFONT code generator\n");
  puts("HUMANITIES AND ARTS COMPUTING CENTER, DR-10");
  puts("UNIVERSITY OF WASHINGTON, SEATTLE WA 98195 USA\n");
  puts("Copyright 1990 Humanities and Arts Computing Center\n");
  puts("This software may be used, modified, and redistributed free of any");
  puts("fee or royalty, provided that this copyright and 'free software' notice");
  puts("remains intact in any copies redistributed, and that you may charge no fee");
  puts("of any sort whatsoever without the written permission of the Humanities");
  puts("and Arts Computing Center.");
  return;
}


void exists (char *filename) 
  { 
    unsigned char response;
    FILE *handle;
    handle = fopen ( filename , "rb" ) ; 
    if (handle != (FILE *) NULL) 
       {  fclose(handle);
          printf("File %s already exists: O.K. to replace? (Y/N): ", filename);
          response = getchar();
          if ( ! ( (response=='y') || (response=='Y') ) ) 
            {
            printf("\nPlease rename files as necessary and try again.\n");
            jumpout();
            }
       }
    return;
    } 

FILE *getopen(char *filename, char *access)
{
	int	temp;
	FILE	*handle;
	gets(filename);
	if (access[0]=='w' || access[0]=='W') exists(filename);  
	handle=fopen(filename,access);
	if (handle == NULL) {
	  puts("\nCan't open file ");
	  puts(filename);
	  puts("\n");
	  }
	return handle;
}

FILE *get_file(char *access,char *prompt,char *filename)
{
	printf("\n %s",prompt);
	return getopen(filename,access);
}

void makedisplay(unsigned char thischar, egafont *thisfont)
{
  int temp,mask,i,k,hold;
  for (i=0; i<14; i++) {
    temp=thisfont->charset[thischar].bitmap[i];
    mask=0x80;
    for (k=0; k<8; k++) {
      hold=temp & mask;
      if (hold==0) editchar.row[i].column[k]=0;
      else editchar.row[i].column[k]=1;
      mask=mask / 2;
    } /* endfor k */
  } /* endfor i */
  return;
}


main(int argc, char *argv[])
{
  FILE *f1=(FILE *) NULL;
  FILE *f2=(FILE *) NULL;
  int done,ch,i,k,codeout;
  char quote,percent;
  egafont *thisega;
  quote=34;
  percent=37;
  /* yes, yes! we are assuming the ASCII character set */
  copyright();
  thisega = (egafont *) malloc(sizeof(egafont));
  if (argc > 1) {
    f1 = fopen(argv[1],"rb");
    (void) strcpy(infilename,argv[1]);
    }
  if (f1 == (FILE *) NULL) {
	/* prompt for and open input file */
	for ( ; f1 == (FILE *) NULL; f1=get_file("rb","Enter name of input ega font file: ",infilename)) ;
	}
  fread(thisega,sizeof(egafont),1,f1);
  fclose(f1);
  if (argc > 2) {
    (void) strcpy(outfilename,argv[2]);
    exists(outfilename);
    f2 = fopen(argv[2],"w");
    }
  if (f2 == (FILE *) NULL) {
	/* prompt for and open output file */
	for ( ; f2 == (FILE *) NULL; f2=get_file("w","Enter name of output Metafont source file: ",outfilename)) ;
	}
   fprintf(f2,"%c This is %s generated by EGA2MF from %s.\n",percent,outfilename,infilename);
   fprintf(f2,"if unknown cmbase: input cmbase fi\n");
   fprintf(f2,"mode_setup;\n");
   fprintf(f2,"def generate suffix t= enddef;\n");
   fprintf(f2,"input cmtt10; font_setup;\n");
   fprintf(f2,"if ligs>1: font_coding_scheme:=%cTeX text%c;\n",quote,quote);
   fprintf(f2,"else: font_coding_scheme:=if ligs=0: %cTeX typewriter text%c\n",quote,quote);
   fprintf(f2,"  else: %cTeX text without f-ligatures%c fi; fi \n",quote,quote);
   fprintf(f2,"numeric cheight; cheight=body_height+desc_depth;\n");
   fprintf(f2,"numeric hhalf; numeric vhalf; hhalf=.4u; vhalf=(cheight)/36;\n");
   fprintf(f2,"numeric vcent; vcent=cheight/28; numeric hcent; hcent=9/16u;\n");
   fprintf(f2,"def crt(expr row,col) =\n");
   fprintf(f2,"y.c:=body_height-(row * cheight / 14)-vcent; x.c:=hcent+(col * 9/8u);\n");
   fprintf(f2,"y.a:=y.c+vhalf; y.b:=y.c-vhalf;\n");
   fprintf(f2,"x.a:=x.c-hhalf; x.b:=x.c+hhalf;\n");
   fprintf(f2,"filldraw (x.a,y.b)..(x.a,y.a)..(x.b,y.a)..(x.b,y.b)..cycle;\n");
   fprintf(f2,"enddef;\n");
   printf("Now processing character ");
   for (ch=0; ch<256; ch++) {
     /* generate code for character ch */
     if ( (ch < 32) || (ch > 126) ) printf("[%d] ",ch);
     else printf("[%c] ",ch);
     fprintf(f2,"\nbeginchar(%d,9u#,body_height#,desc_depth#);",ch);
     fprintf(f2,"adjust_fit(0,0);\npickup pencircle scaled 0.2pt;\n");
     makedisplay(ch,thisega);
     for(i=0; i < 14; i++) {
        codeout=0;
        for(k=0; k<8; k++) {
	    if (editchar.row[i].column[k] != 0) {
                fprintf(f2,"crt(%d,%d); ",i,k);
                codeout=1;
                } /* endif set dot on */
        } /* end k */
        if (codeout > 0) fprintf(f2,"\n");
     } /* endfor i */
     fprintf(f2,"endchar;\n");
     if ( ( ch % 16 ) == 0 ) printf("\n");
   } /* endfor ch */
   fprintf(f2,"\n");
   fprintf(f2,"font_slant slant; font_x_height x_height#;\n");
   fprintf(f2," font_normal_space 9u#;\n");
   fprintf(f2," font_quad 18u#;\n");
   fprintf(f2," font_extra_space 9u#;\n");
   fprintf(f2,"bye.\n");
   printf("\nEGA2MF is done.  Good luck with your new font.\n");
   fclose(f2);
}

