.TH MAKEVPL 1 "VPLUtils Release @RELEASE@"
.SH NAME
makevpl \- mix and match TeX's PL and VPL fonts
.SH SYNOPSIS
.B makevpl
[
.B \-quiet
] [
.B \-enc
.I encoding
] [
.B \-defenc
.I encoding
] [
.B \-family
.I famname
] [
.B \-face
.I facenum
] [
.B \-coding
.I scheme
] [
.B \-size
.I designsize
] [
.B \-units
.I designunits
] [
.B \-at
.I pointsize
] [
.B \-normal
] [
.B \-replace\fR{\fBfd|ch|wd|ht|dp|ic|map\fR}\fB
.I range
] [
.B \-add\fR{\fBfd|ch|wd|ht|dp|ic|map\fR}\fB
.I range
]
.I font[:encoding]...
.SH DESCRIPTION
.I Makevpl
constructs a Virtual Property List (VPL) file containing characters from the
fonts specified. A property list (\fB.pl\fR) or virtual property list
(\fB.vpl\fR) file must exist for each font specified; these files are read,
and a new VPL file containing the merged font is written to standard output.
.PP
The action options
.B \-replace\fIx\fB, \-add\fIx\fB, \-at
and
.B \-normal
determine how the files are merged. These options may be specified several
times; if they appear before the first font, they set the default action for
all fonts. If these options appear between fonts, they set the action for the
next font only.
.PP
The actions
.B \-replace\fIx\fB
and
.B \-add\fIx\fB
determine whether character information from a font is to replace or be added
to information in the output font. A character range must be specified with
of these options; only characters in the range are considered for replacement
or addition. The character range is a comma separated list of numbers or
subranges of the form
.I low\-high.
If
.I low
and/or
.I high
are omitted, the subrange is unbounded at the appropriate end(s).
.PP
There are seven variants of the
.B \-replace\fIx\fB
and
.B \-add\fIx\fB
options. These are
.B \-addfd
and
.B \-replacefd,
which add or replace font dimensions in the specified range, 
.B \-addwd, \-replacewd, \-addht, \-replaceht, \-adddp, \-replacedp, \-addic,
.B \-replaceic, \-addmap,
and
.B \-replacemap,
which add or replace the width, height, depth, italic correction or character
map of characters in the specified range.
The options
.B \-addch,
and
.B \-replacech
will add or replace all of the information for the characters in the specified
range. Only characters which have a character map will be written to the
output font; a default character map is supplied for characters in property
list (\fB.pl\fR) files.
.PP
Delimiter and variable size character list information is mapped to the
corresponding glyphs in the output font encoding, and cannot be controlled
from the command line. Ligature and kerning information mapped across with
characters from a font; if you want to add new ligatures or kerns to a font,
you can merge it with a property list with the same name as the font, but with
a different extension.
.PP
The actions
.B \-at
and
.B \-normal
determine how the fonts are scaled. The
.B \-at
option scales fonts to the point size specified, and the
.B \-normal
option leaves fonts at their natural size.
.PP
The default actions are to replace all characters, add all font dimensions,
and leave fonts at their natural size.
.PP
Each font file has an associated
.I encoding
vector. The encoding vector is used to determine where replacement or
additional characters are positioned in fonts. The name associated with a
character's input encoding is used to place the character in the output font.
Encoding vector files are PostScript fragments, containing an array of 256
names.
.PP
The
.B \-enc
option gives the desired output encoding; the default is to use the encoding
of the first font specified.
.PP
The environment variable
.B ENCPATH
can be used to set an encoding path which will be searched for the
encoding files. If a null path component is specified, the default path will
be searched at that point. The encoding files will be looked for under the
name given, and also with
.B .enc
appended.
.PP
The
.B \-defenc
option can be used to specify an encoding which will be used for
each font which does not have an encoding specified. The default encoding is
.I standard.
.PP
The family, face and encoding scheme fields of the output font can be set with
the
.B \-family, \-face,
and
.B \-coding
options. The design size and number of design units per design size can be
specified with the
.B \-size
and
.B \-units
options.
.PP
Normally
.I makevpl
informs you about what it is doing; the
.B \-quiet
option prevents this behaviour.
.SH EXAMPLES
To create a version of Times which can be used for maths in TeX, start
with the Computer Modern maths font, and replace characters from an obliqued
version of the symbol font, and Times-Italic:
.sp
.ce
makevpl cmmi:CMsymbol rpsyro:symbol rptmri >ptmmi.vpl
.sp
To add ligatures to the standard encoding form of CharterBT-Roman:
.sp
.ce
makevpl rbchr rbchr.ligs >rbchl.vpl
.sp
.SH FILES
@ENCODINGDIR@/*.enc \- encoding vector files
.SH AUTHOR
Angus Duggan
.SH "SEE ALSO"
@MAN@, vftovp(1), vptovf(1), tftopl(1), afm2tfm(1)
.SH BUGS
.I Makevpl
expands joined kerning and ligature tables; word boundary characters in the
kerning and ligature tables may also be treated unusually.
.I Makevpl
is slow.
