/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.event.AbstractUninstallerListener;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.event.BSFAction;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;

public class BSFUninstallerListener
extends AbstractUninstallerListener {
    private final Resources resources;
    private List<BSFAction> actions;

    public BSFUninstallerListener(Resources resources) {
        this.resources = resources;
    }

    @Override
    public void initialise() {
        try {
            InputStream in = this.resources.getInputStream("bsfActions");
            ObjectInputStream objIn = new ObjectInputStream(in);
            this.actions = (List)objIn.readObject();
            if (this.actions == null) {
                this.actions = Collections.emptyList();
            } else {
                for (BSFAction action : this.actions) {
                    action.init();
                }
            }
            objIn.close();
            in.close();
        }
        catch (ResourceNotFoundException ignore) {
        }
        catch (IzPackException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IzPackException(exception);
        }
    }

    @Override
    public void beforeDelete(List<File> files) {
        for (BSFAction action : this.actions) {
            action.executeUninstall("beforedeletion", files);
        }
    }

    @Override
    public void afterDelete(List<File> files, ProgressListener listener) {
        for (BSFAction action : this.actions) {
            action.executeUninstall("afterdeletion", files, listener);
            action.destroy();
        }
    }

    @Override
    public void beforeDelete(File file) {
        for (BSFAction action : this.actions) {
            action.executeUninstall("beforedelete", file);
        }
    }

    @Override
    public void afterDelete(File file) {
        for (BSFAction action : this.actions) {
            action.executeUninstall("afterdelete", file);
        }
    }

    @Override
    public boolean isFileListener() {
        return true;
    }
}

