/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.xmlmerge.action;

import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.Action;
import com.izforge.izpack.util.xmlmerge.DocumentException;
import com.izforge.izpack.util.xmlmerge.Mapper;
import com.izforge.izpack.util.xmlmerge.Matcher;
import com.izforge.izpack.util.xmlmerge.action.AbstractMergeAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Text;

public class FullMergeAction
extends AbstractMergeAction {
    private static final Logger logger = Logger.getLogger(FullMergeAction.class.getName());

    @Override
    public void perform(Element originalElement, Element patchElement, Element outputParentElement) throws AbstractXmlMergeException {
        logger.fine("Merging: " + originalElement + " (original) and " + patchElement + " (patch)");
        Mapper mapper = (Mapper)this.m_mapperFactory.getOperation(originalElement, patchElement);
        if (originalElement == null) {
            outputParentElement.addContent((Content)mapper.map(patchElement));
        } else if (patchElement == null) {
            outputParentElement.addContent((Content)originalElement.clone());
        } else {
            Element workingElement = new Element(originalElement.getName(), originalElement.getNamespacePrefix(), originalElement.getNamespaceURI());
            this.addAttributes(workingElement, originalElement);
            logger.fine("Adding " + workingElement);
            outputParentElement.addContent((Content)workingElement);
            this.doIt(workingElement, originalElement, patchElement);
        }
    }

    private void doIt(Element parentOut, Element origElement, Element patchElement) throws AbstractXmlMergeException {
        this.addAttributes(parentOut, patchElement);
        List origContentList = origElement.getContent();
        List patchContentList = patchElement.getContent();
        ArrayList<Content> unmatchedPatchContentList = new ArrayList<Content>();
        ArrayList<Content> matchedPatchContentList = new ArrayList<Content>();
        for (Content origContent : origContentList) {
            logger.fine("Checking original content: " + origContent + " for matching patch contents");
            if (origContent instanceof Element) {
                boolean patchMatched = false;
                for (Content patchContent : patchContentList) {
                    logger.fine("Checking patch content: " + patchContent);
                    if (patchContent instanceof Comment || patchContent instanceof Text) {
                        logger.fine("Skipped patch content: " + patchContent);
                        continue;
                    }
                    if (!(patchContent instanceof Element)) {
                        throw new DocumentException(patchContent.getDocument(), "Contents of type " + patchContent.getClass().getName() + " in patch document not supported");
                    }
                    if (((Matcher)this.m_matcherFactory.getOperation((Element)patchContent, (Element)origContent)).matches((Element)patchContent, (Element)origContent)) {
                        logger.fine("Apply matching patch: " + patchContent + " -> " + origContent);
                        this.applyAction(parentOut, (Element)origContent, (Element)patchContent);
                        patchMatched = true;
                        if (matchedPatchContentList.contains(patchContent)) continue;
                        matchedPatchContentList.add(patchContent);
                        continue;
                    }
                    if (unmatchedPatchContentList.contains(patchContent)) continue;
                    unmatchedPatchContentList.add(patchContent);
                }
                if (patchMatched) continue;
                logger.fine("Apply original: " + origContent);
                this.applyAction(parentOut, (Element)origContent, null);
                continue;
            }
            if (origContent instanceof Comment || origContent instanceof Text) {
                parentOut.addContent(origContent.clone());
                continue;
            }
            throw new DocumentException(origContent.getDocument(), "Contents of type " + origContent.getClass().getName() + " in original document not supported");
        }
        for (Content unmatchedPatchContent : unmatchedPatchContentList) {
            if (matchedPatchContentList.contains(unmatchedPatchContent)) continue;
            logger.fine("Apply unmatching patch: " + unmatchedPatchContent);
            this.applyAction(parentOut, null, (Element)unmatchedPatchContent);
        }
    }

    private void applyAction(Element workingParent, Element originalElement, Element patchElement) throws AbstractXmlMergeException {
        Action action = (Action)this.m_actionFactory.getOperation(originalElement, patchElement);
        Mapper mapper = (Mapper)this.m_mapperFactory.getOperation(originalElement, patchElement);
        action.perform(originalElement, mapper.map(patchElement), workingParent);
    }

    private void addAttributes(Element out, Element in) {
        LinkedHashMap<String, Attribute> allAttributes = new LinkedHashMap<String, Attribute>();
        ArrayList outAttributes = new ArrayList(out.getAttributes());
        ArrayList inAttributes = new ArrayList(in.getAttributes());
        for (Attribute attr : outAttributes) {
            attr.detach();
            allAttributes.put(attr.getQualifiedName(), attr);
            logger.fine("adding attr from out:" + attr);
        }
        for (Attribute attr : inAttributes) {
            attr.detach();
            allAttributes.put(attr.getQualifiedName(), attr);
            logger.fine("adding attr from in:" + attr);
        }
        out.setAttributes(new ArrayList(allAttributes.values()));
    }
}

