/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;

public class WaylandScreenshooter {
    private static void openWebPage(String url) throws IOException {
        System.out.println("Opening web page: " + url);
        Desktop.getDesktop().browse(URI.create(url));
    }

    private static void captureScreenshot(String fileName, String path, String s) throws IOException {
        System.out.println("Capturing screenshot...");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String command = "gnome-screenshot -w -f " + path + fileName + ".png";
        try {
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Screenshot saved at location: " + path + fileName + ".png");
    }

    private static void closeWebPage() {
        System.out.println("Closing web page...");
        try {
            Runtime.getRuntime().exec("ydotool key ctrl+w");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Web page closed.");
    }

    public static void captureScreenshot(String url, int width, int height, String fileName, String path) {
        try {
            WaylandScreenshooter.openWebPage(url);
            Thread.sleep(4000L);
            WaylandScreenshooter.captureScreenshot(fileName, path, path);
            WaylandScreenshooter.closeWebPage();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void resizeImage(int scaledWidth, int scaledHeight, String fileName) throws IOException {
        File inputFile = new File(System.getProperty("user.dir") + "/" + fileName + ".png");
        BufferedImage inputImage = ImageIO.read(inputFile);
        BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());
        Graphics2D graphics2D = outputImage.createGraphics();
        graphics2D.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
        graphics2D.dispose();
        ImageIO.write((RenderedImage)outputImage, "png", new File(fileName + ".png"));
    }
}

