#ifndef __LANGVER_H
#define __LANGVER_H

#include "error.h"

#define MAX_PST_VERSION_STRING_SIZE 10

typedef struct pst_version_t 
{
  char str[MAX_PST_VERSION_STRING_SIZE];
  char key[MAX_PST_VERSION_STRING_SIZE * 2];
}
PST_VERSION;

int parse_pst_version (PST_VERSION *v, char *str, SRC_LINE line);
int pst_version_cmp(PST_VERSION *a, PST_VERSION *b);

/* Version 1.20 added linejoin option, where pstverb was 
   needed previously. */
#define PST_LINEJOIN_VERSION 1.20

/* This should be set to the latest version that 
   makes a difference for Sketch output. */
#define ASSUMED_PST_VERSION PST_LINEJOIN_VERSION 

#endif
