% This file is part of the TeluguTeX Software Package.
%Copyright (c) 1991 Lakshmankumar Mukkavilli
%
%The TeluguTeX Software Package is distributed in the hope that
%it will be useful,but WITHOUT ANY WARRANTY.  No author or distributor
%accepts responsibility to anyone for the consequences of using it
%or for whether it serves any particular purpose or works at all,
%unless he says so in writing.  Refer to the TeluguTeX Software Package
%General Public License for full details.
%
%Everyone is granted permission to copy, modify and redistribute
%the TeluguTeX Software Package, but only under the conditions described in the
%TeluguTeX Software Package General Public License.   A copy of this license is
%supposed to have been given to you along with TeluguTeX Software Package so you
%can know your rights and responsibilities.  It should be in a
%file named CopyrightLong.  Among other things, the copyright notice
%and this notice must be preserved on all copies.  
%%%%%%%%
% This file specifies the slant, pen_width, font_size and pen shapes
% for generating various font sizes/styles. Typically this file
% would be broken up into several files. 
% It is very easy to extract any parameter file. Each specification      
% is delimited by  the name of the font(enclosed in percent signs)
% and a pair of percent signs occuring in first two columns.
% 
%teloffset%    generates TeX macros to define codes & offsets
input telmode;
font_size 10pt#;
slant:=0;
pen_width#:=0.3pt#;
vardef offsets_only=
  proofing:=-1;
  fontmaking:=0;
  tracingtitles:=0;
enddef;
input telparam;  
%%
%tel10%
input telmode;
font_size 10pt#;
slant:=0;
pen_width#:=0.35pt#;
input telparam;  
%%
%tel10nx%  non-uniform pen(x-axis)
input telmode;
font_size 10pt#;
slant:=0;
pen_width#:=0.5pt#;
vardef special_telpen =
    pickup pencircle xscaled (pen_width/2) yscaled (pen_width);
enddef;
input telparam;  
%%
%tel10ny%  non-uniform pen(y-axis)
input telmode;
font_size 10pt#;
slant:=0;
pen_width#:=0.48pt#;
vardef special_telpen =
    pickup pencircle xscaled pen_width yscaled (pen_width/2);
enddef;
input telparam;  
%%
%tel10b%
input telmode;
font_size 10pt#;
slant:=0;
pen_width#:=0.5pt#;
input telparam;  
%%
%tel10s%
input telmode;
font_size 10pt#;
slant:=1/4;
pen_width#:=0.4pt#;
input telparam;  
%%
%tel11%
input telmode;
font_size 11pt#;
slant:=0;
pen_width#:=0.41pt#;
input telparam;  
%%
%tel11nx% non-uniform pen(x_axis)
input telmode;
font_size 11pt#;
slant:=0;
pen_width#:=0.62pt#;
vardef special_telpen =
    pickup pencircle xscaled (pen_width/2) yscaled (pen_width);
enddef;
input telparam;  
%%
%tel11ny% non-uniform pen(y-axis)
input telmode;
font_size 11pt#;
slant:=0;
pen_width#:=0.60pt#;
vardef special_telpen =
    pickup pencircle xscaled pen_width yscaled (pen_width/2);
enddef;
input telparam;  
%%
%tel11b%
input telmode;
font_size 11pt#;
slant:=0;
pen_width#:=0.57pt#;
input telparam;  
%%
%tel11s%
input telmode;
font_size 11pt#;
slant:=1/4;
pen_width#:=0.56pt#;
input telparam;  
%%
%tel12%
input telmode;
font_size 12pt#;
slant:=0;
pen_width#:=0.5pt#;
input telparam;  
%%
%tel12nx%  non-uniform pen(x-axis)
input telmode;
font_size 12pt#;
slant:=0;
pen_width#:=0.74pt#;
vardef special_telpen =
    pickup pencircle xscaled (pen_width/2) yscaled (pen_width);
enddef;
input telparam;  
%%
%tel12ny%  non-uniform pen(y-axis)
input telmode;
font_size 12pt#;
slant:=0;
pen_width#:=0.65pt#;
vardef special_telpen =
    pickup pencircle xscaled pen_width yscaled (pen_width/2);
enddef;
input telparam;  
%%
%tel12b%
input telmode;
font_size 12pt#;
slant:=0;
pen_width#:=0.68pt#;
input telparam;  
%%
%tel12s%
input telmode;
font_size 12pt#;
slant:=1/4;
pen_width#:=0.61pt#;
input telparam;  
%%
%tel15%
input telmode;
font_size 15pt#;
slant:=0;
pen_width#:=0.68pt#;
input telparam;  
%%
%tel15b%
input telmode;
font_size 15pt#;
slant:=0;
pen_width#:=0.8pt#;
input telparam;  
%%
%tel15s%
input telmode;
font_size 15pt#;
slant:=1/4;
pen_width#:=0.74pt#;
input telparam;  
%%
%tel18%
input telmode;
font_size 18pt#;
slant:=0;
pen_width#:=0.86pt#;
input telparam;  
%%
%tel18b%
input telmode;
font_size 18pt#;
slant:=0;
pen_width#:=1.05pt#;
input telparam;  
%%
%tel18s%
input telmode;
font_size 18pt#;
slant:=1/4;
pen_width#:=1.00pt#;
input telparam;  
%%
%tel20%
input telmode;
font_size 20pt#;
slant:=0;
pen_width#:=1.05pt#;
input telparam;  
%%
%tel20b%
input telmode;
font_size 20pt#;
slant:=0;
pen_width#:=1.25pt#;
input telparam;  
%%
%tel20s%
input telmode;
font_size 20pt#;
slant:=1/4;
pen_width#:=1.10pt#;
input telparam;  
%%
%tel25%
input telmode;
font_size 25pt#;
slant:=0;
pen_width#:=1.25pt#;
input telparam;  
%%
%tel25b%
input telmode;
font_size 25pt#;
slant:=0;
pen_width#:=1.70pt#;
input telparam;  
%%
%tel25s%
input telmode;
font_size 25pt#;
slant:=1/4;
pen_width#:=1.35pt#;
input telparam;  
%%
%tel30%
input telmode;
font_size 30pt#;
slant:=0;
pen_width#:=1.75pt#;
input telparam;  
%%
%tel30s%
input telmode;
font_size 30pt#;
slant:=1/4;
pen_width#:=1.8pt#;
input telparam;  
%%
%tel35%
input telmode;
font_size 35pt#;
slant:=0;
pen_width#:=2.30pt#;
input telparam;  
%%
%tel35s%
input telmode;
font_size 35pt#;
slant:=1/4;
pen_width#:=2.40pt#;
input telparam;  
%%
%tel40%
input telmode;
font_size 40pt#;
slant:=0;
pen_width#:=2.75pt#;
input telparam;  
%%
%tel40s%
input telmode;
font_size 40pt#;
slant:=1/4;
pen_width#:=2.85pt#;
input telparam;  
%%
%tel55%
input telmode;
font_size 55pt#;
slant:=0;
pen_width#:=3.15pt#;
input telparam;  
%%
%tel55s%
input telmode;
font_size 55pt#;
slant:=1/4;
pen_width#:=3.25pt#;
input telparam;  
%%
%tel72%
% generate big characters,  sc_height to des_depth is 1 inch
input telmode;
font_size 72pt#;
slant:=0;
pen_width#:=3.8pt#;
input telparam;  
%%
%tel100%
% generate big characters
input telmode;
font_size 100pt#;
slant:=0;
pen_width#:=5.0pt#;
input telparam;  
%%
%tel172%
% generate very very big characters, x_height is 1 inch
input telmode;
font_size 172pt#;
slant:=0;
pen_width#:=6.0pt#;
%pen_width#:=1.3pt#;
input telparam;  
%%
%telspa%
% genarates characters with stripes
input telmode;
font_size 72pt#;
slant:=0;
pen_width#:=3.2pt#;
% Following code(with minor modifications) is taken from the article,  
% The ABC's of Special Effects by Georgia K. M. Tobin,
% that appeared in TUGboat, Volume 9(1988), No. 1
vardef special_effects=
% creates characters filled with stripes.
    cullit;
    picture Normalchar;
         Normalchar:=currentpicture;
    clearit;
% Depending on the output device, pen size(0.28pt) may need to be
% changed.
    pickup pencircle scaled 0.28pt; 
    filldraw (0,-d)--(w,-d)--
         (w,h)--(0,h)--cycle;
    picture Blackbox;
         Blackbox:=currentpicture;
    picture Reversevideo;
         Reversevideo:=Blackbox-Normalchar;
    clearit;
% Depending on the output device,stepsize(uh/3) may need to be
% changed.
    for f=-d step uh/3 until h:
      draw(0,f)--(w,f);
    endfor;
    picture Stripeoverlay;
         Stripeoverlay:=currentpicture;
    currentpicture:=Stripeoverlay-Reversevideo;
enddef;
input telparam;  
%%
%telspb%
% generate characters filled with tiny dots
input telmode;
%mode:=proof;
%boolean testing; testing := true;
font_size 72pt#;
slant:=0;
pen_width#:=2.5pt#;
% Following code(with minor modifications) is taken from the article,  
% The ABC's of Special Effects by Georgia K. M. Tobin,
% that appeared in TUGboat, Volume 9(1988), No. 1
vardef special_effects=
% creates characters filled with tiny dots.
    cullit;
    picture Normalchar;
         Normalchar:=currentpicture;
    clearit;
% Depending on the output device, pen size  (0.5pt) may need to be
% changed.
    pickup pencircle scaled 0.5pt; 
    filldraw (0,-d)--(w,-d)--
         (w,h)--(0,h)--cycle;
    picture Blackbox;
         Blackbox:=currentpicture;
    picture Reversevideo;
         Reversevideo:=Blackbox-Normalchar;
    clearit;
% Depending on the output device,stepsizes(u/4 and uh/4) may need to be
% changed.
    for g=0 step u/4 until w:
      for f=-d step uh/4 until h:
         draw(g,f);
      endfor;
    endfor;
    picture Dottedoverlay;
         Dottedoverlay:=currentpicture;
    currentpicture:=Dottedoverlay-Reversevideo;
enddef;
input telparam;  
%%
%telspc%
% generates striped characters with shading
input telmode;
font_size 72pt#;
slant:=0;
pen_width#:=2.5pt#;
% Following code(with minor modifications) is taken from the article,  
% The ABC's of Special Effects by Georgia K. M. Tobin,
% that appeared in TUGboat, Volume 9(1988), No. 1
vardef special_effects=
% creates characters filled with stripes and followed by a shadow.
    cullit;
    picture Normalchar;
         Normalchar:=currentpicture;
    clearit;
% Depending on the output device, pen size(0.1pt) may need to be
% changed.
    pickup pencircle scaled 0.1pt; 
    filldraw (0,-d)--(w,-d)--
         (w,h)--(0,h)--cycle;
    picture Blackbox;
         Blackbox:=currentpicture;
    picture Reversevideo;
         Reversevideo:=Blackbox-Normalchar;
    clearit;
% Depending on the output device,stepsize(uh/3) may need to be
% changed.
    for f=-d step uh/3 until h:
      draw(0,f)--(w,f);
    endfor;
    currentpicture:=
                   currentpicture-Reversevideo;
    cullit;
    picture Stripedchar;
         Stripedchar:=currentpicture;
    clearit;
% Depending on the output device,offset(1.5pt) may need to be
% changed.
    currentpicture:=Normalchar shifted(1.5pt,-1.5pt);
    picture Shadow;
           Shadow:=currentpicture;
    clearit;
    currentpicture:=Shadow-Normalchar;
    cullit;
    picture Shadowonly;
           Shadowonly:=currentpicture;
    clearit;

    currentpicture:=Shadowonly+Stripedchar;
enddef;
input telparam;  
%%
%tel2602%
% generate all the symbols in proof mode
mode=proof;
font_size 10pt#;
slant:=0;
pen_width#:=0.3pt#;
input telparam;
%%
%tel2602t%
% test individual symbols in the font
mode=proof;
font_size 10pt#;
boolean testing; testing:=true;
slant:=0;
pen_width#:=0.3pt#;
input telparam;
%%
