(put 'f 'latexinfo-format 'latexinfo-format-noop)
(put 'fb 'latexinfo-format 'latexinfo-format-findex-plus)
(defun latexinfo-format-findex-plus ()
  (latexinfo-index-plus 'latexinfo-findex))

(put 'v 'latexinfo-format 'latexinfo-format-noop)
(put 'vb 'latexinfo-format 'latexinfo-format-vindex-plus)
(defun latexinfo-format-vindex-plus ()
  (latexinfo-index-plus 'latexinfo-vindex))

(put 'p 'latexinfo-format 'latexinfo-format-noop)
(put 'pb 'latexinfo-format 'latexinfo-format-pindex-plus)
(defun latexinfo-format-pindex-plus ()
  (latexinfo-index-plus 'latexinfo-pindex))

(defun latexinfo-index-plus (indexvar)
  (let ((arg (latexinfo-parse-expanded-arg)))
    (latexinfo-discard-command)
    (set indexvar
	 (cons (list arg
                     latexinfo-last-node
                     ;; Region formatting may not provide last node position.
		     (if latexinfo-last-node-pos
                         (1+ (count-lines latexinfo-last-node-pos (point)))
                       1))
	       (symbol-value indexvar)))
    (insert arg)
    (goto-char latexinfo-command-start)
    ))

;; Allow access to internal LaTeX index macros as noops.
(put 'vrindex 'latexinfo-format 'latexinfo-format-noop)
(put 'cpindex 'latexinfo-format 'latexinfo-format-noop)
(put 'fnindex 'latexinfo-format 'latexinfo-format-noop)
(put 'pgindex 'latexinfo-format 'latexinfo-format-noop)
(put 'tpindex 'latexinfo-format 'latexinfo-format-noop)
(put 'kyindex 'latexinfo-format 'latexinfo-format-noop)

