## makedist.pl --- make a MiKTeX distribution
## Time-stamp: "97/08/11 21:02:55 mik"
## Copyright (C) 1997 Christian Schenk <cs@ronin.in-berlin.de>

use File::Basename;

&main;
exit 0;

sub make_zip

{
  my ($mftfile) = @_;
  my ($mnemonic, $digest);

  $mnemonic = basename ($mftfile, ".mft");
  $mnemonic =~ s/[0-9]+//;
  $zipfile = basename ($mftfile, ".mft") . ".zip";

  system "cd ..\\..\\.. && zip -9or@ $zipfile < source\\miktex-$ARGV[0].$ARGV[1]\\dist\\$mftfile\n";

  print INSTALL_DAT "\"$zipfile\",\n";
  print INSTALL_DAT "$options{$mnemonic},\n";
  print INSTALL_DAT "\"$description{$mnemonic}\",\n";
##  $digest = `md5 ..\\..\\..\\$zipfile`;
##  chop ($digest);
##  $digest =~ s/MD5 (.*) = //;
##  for ($i = 0; $i < 32; $i += 2)
##    {
##      print INSTALL_DAT "0x" . substr ($digest, $i, 2) . ",";
##    }
  print INSTALL_DAT "\n\n";
}

sub parse_install_dat_in

{
  my ($mnemonic, $fieldnum);

  open INSTALL_DAT_IN, "install.dat.in";
  
  $fieldnum = 0;
  while (<INSTALL_DAT_IN>)
    {
      chop ();
      if (length ($_) > 0)
	{
	  if ($fieldnum % 3 == 0)
	    {
	      $mnemonic = $_;
	    }
	  elsif ($fieldnum % 3 == 1)
	    {
	      $options{$mnemonic} = $_;
	    }
	  elsif ($fieldnum % 3 == 2)
	    {
	      $description{$mnemonic} = $_;
	    }
	  $fieldnum++;
	}
    }

  close INSTALL_DAT_IN;
}

sub main

{
  &parse_install_dat_in;
  fileparse_set_fstype ("MSDOS");
  open INSTALL_DAT, ">install.dat";
  foreach $file (<*.mft>)
    {
      &make_zip ($file);
    }
  close INSTALL_DAT;
}
