/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.flowfram;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFramSty;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameData;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameType;
import java.io.IOException;

public class GetFlowLabel
extends Command {
    FlowFramSty sty;
    FlowFrameType type;

    public GetFlowLabel(FlowFramSty flowFramSty) {
        this("getflowlabel", FlowFrameType.FLOW, flowFramSty);
    }

    public GetFlowLabel(String string, FlowFrameType flowFrameType, FlowFramSty flowFramSty) {
        super(string);
        this.type = flowFrameType;
        this.sty = flowFramSty;
    }

    @Override
    public Object clone() {
        return new GetFlowLabel(this.getName(), this.type, this.sty);
    }

    @Override
    public boolean canExpand() {
        return true;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        FlowFrameData flowFrameData;
        int n = this.popInt(teXParser, teXObjectList);
        switch (this.type) {
            case STATIC: {
                flowFrameData = this.sty.getStaticFrame(n);
                break;
            }
            case DYNAMIC: {
                flowFrameData = this.sty.getDynamicFrame(n);
                break;
            }
            default: {
                flowFrameData = this.sty.getFlowFrame(n);
            }
        }
        if (flowFrameData == null) {
            return teXParser.getListener().createStack();
        }
        return teXParser.getListener().createString(flowFrameData.getLabel());
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser, teXParser);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList);
    }
}

