/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class Bib2GlsDualSymbol
extends Bib2GlsDualEntry {
    public Bib2GlsDualSymbol(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualsymbol");
    }

    public Bib2GlsDualSymbol(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualSymbolMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualSymbolMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualSymbolMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualSymbol(this.bib2gls, this.getEntryType());
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("name") == null) {
            this.missingFieldWarning("name");
        }
        if (this.getField("symbol") == null) {
            this.missingFieldWarning("symbol");
        }
    }

    @Override
    public String getSortFallbackField() {
        String string = this.resource.getCustomEntryDefaultSortField(this.getOriginalEntryType());
        if (string != null) {
            return string;
        }
        return this.resource.getSymbolDefaultSortField();
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackValue();
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackContents();
        }
        if (string.equals("name")) {
            return this.getIdField();
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        String string = this.getEntryType();
        if (string.startsWith("dual")) {
            string = string.substring(4);
        }
        printWriter.print(" \\longnewglossaryentry*{#1}");
        printWriter.format("{name={#3},sort={#1},category={%s},#2}{#4}", string);
        printWriter.println("}");
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = "";
        String string3 = "";
        Set<String> set = this.getFieldSet();
        Vector<String> vector = this.resource.getOmitFieldList(this);
        for (String string4 : set) {
            if (vector != null && vector.contains(string4)) {
                this.bib2gls.verboseMessage("message.omitting.field", new Object[]{string4, this.getId()});
                continue;
            }
            if (string4.equals("name")) {
                string2 = this.getFieldValue(string4);
                continue;
            }
            if (string4.equals("description")) {
                string3 = this.getFieldValue(string4);
                continue;
            }
            if (this.bib2gls.isKnownField(string4)) {
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string4, this.getFieldValue(string4));
                continue;
            }
            if (!this.bib2gls.isDebuggingOn() || this.bib2gls.isInternalField(string4) || this.bib2gls.isKnownSpecialField(string4)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", new Object[]{string4});
        }
        printWriter.println(String.format("}%%%n{%s}%%%n{%s}", string2, string3));
        this.writeInternalFields(printWriter);
    }
}

