/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.FieldValueElement;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldValueTrim
implements FieldValueElement {
    private FieldValueElement fieldValueElem;

    public FieldValueTrim(FieldValueElement fieldValueElement) {
        this.fieldValueElem = fieldValueElement;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        TeXObject teXObject;
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        BibValue bibValue = this.fieldValueElem.getValue(bib2GlsEntry);
        if (bibValue == null) {
            return null;
        }
        TeXParser teXParser = bib2GlsEntry.getResource().getParser();
        TeXObjectList teXObjectList = (TeXObjectList)bibValue.expand(teXParser).clone();
        teXObjectList.popLeadingWhiteSpace();
        for (int i = teXObjectList.size() - 1; i >= 0 && (teXObject = (TeXObject)teXObjectList.get(i)) instanceof WhiteSpace; --i) {
            teXObjectList.remove(i);
        }
        return new BibUserString((TeXObject)teXObjectList);
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string = this.fieldValueElem.getStringValue(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public String toString() {
        return String.format("\\TRIM{%s}", this.fieldValueElem);
    }
}

