{$IFDEF WINDOWS}
{$N-,V-,W-,G+,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibfilch;

Interface

Uses
{$IFDEF WINDOWS}
  Wobjects, WinDos, wbibdisp, wbibshow, wbibeden, wbibgui, wbiblist, wbibadd,
  strings,  wbibabv1, wintypes, bibcol64,
{$ELSE}
  bibwindo, Dos, Objects, BibMouse, bibsedit, BibCrt, bibdisp, bibedent,
  bibshow, biblist, bibadd,
{$ENDIF}
  bibstrg, streams, bibstrm, bib8bit, bibvars, bibfile, bibutil, bibsrtpt,
  BibReadB, BibReadT, BibReadD, BibWritB, BibReach, BibText, bibPchec,
  rc_strng, bibflch2, bibcache, bibputbk, bibsort, lfnunit;


function BibFileChange(Pattern: PatRecPtr; Entry: EntryRecPtr;
                       OldName: string; Action: integer; equiv: boolean;
                       ImpFile: string; ExpMode: byte;
                       WSortMode,selected: byte; InpPtr: Pointer): boolean;
function DeleteEntries(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       DelAll,Warn: boolean): boolean;


Implementation

var
  GlobalPointer: Pointer;


procedure IndexFileHeader(F: PStream; var M: ConfigSortType;
                          SortPattern: PatRecPtr);
var
  line: string[50];
  EOPos,EndOFHeader: longint;
  i: integer;
begin
  if (F=Nil) or (F^.status<>stOK) then Exit;
  F^.seek(0); F^.truncate;
  line:=IndexFileString; StreamWriteln(F,line,false);

  line:=num2str(UnFinishedTime)+' -1 0 -1';          { Bib data,  EndOfData }
  for i:=length(line)+1 to 50 do line:=line+' ';
  StreamWriteln(F,line,false);

  EOPos:=F^.getpos;
  line:='-1            '; line[0]:=#12;                       { EndOfHeader }
  StreamWriteln(F,line,false);
  M.UsePatternFile:=false;
  WriteSortMode(F,M,SortPattern,false,false);
  EndOfHeader:=F^.getpos;
  F^.seek(EOPos);
  line:=num2str(EndOfHeader)+'              '; line[0]:=#12;   { EndOfHeader }
  StreamWriteln(F,line,false);
  F^.seek(F^.getsize);
end;                                { IndexFileHeader }

procedure CloseIndexFile(F: Pstream; var bib: text; bibname: string;
                         nentries: word);
var
  Time,Size,EndOfData: longint;
  line: string[50];
  i: integer;
begin
  if Nentries<=0 then Exit;
  LFNClose(bib);
  if F^.Status<>stOK then Exit;
  Size:=FileSize(bibname);
  if LFNreset(bib,0)=0 then
  begin
    GetFTime(bib,Time); LFNclose(bib);
    EndOfData:=F^.getpos;
    
    StreamWriteln(F,'',false);
    StreamWriteln(F,EndIndexStr,false);
    
    F^.seek(length(IndexFileString)+LengthOfEOL);
    line:=num2str(Time)+' '+num2str(Size)+' '+num2str(nentries)
          +' '+num2str(EndOfData);
    for i:=length(line)+1 to 50 do line:=line+' ';
    StreamWriteln(F,line,false);
  end else message('Error '+num2str(DosError)+' writing index file');
  LFNClose(bib);
end;                                { CloseIndexFile }

procedure CopyFileHeader(var impF: text; F: PStream; ToPos: longint;
                         UnixIn, UnixOut: boolean; var ok: boolean);
var
  sortenv,Wblank: boolean;
  line: string;
  pl,nbr: longint;
  ii: byte;
begin
  ok:=false;
  if F=Nil then Exit;
  ok:=true;
{  if Linked then Exit; }
  F^.reset; ResetFile(impF); pl:=0;
  sortenv:=false;
  nbr:=0;
  repeat
    wblank:=true;
    ReadString(ImpF,line,UnixIn); pl:=pl+length(line);
    if (ToPos>=0) and (pl>=ToPos) then
    begin
      line[0]:=Chr(length(line)-(pl-ToPos));
      wblank:=false;
    end;
    if not SortEnv then
    begin
      ii:=StrPosLI(line,'\sort'+lbrace);
      if ii>0 then
      begin
        if ii>1 then
        begin
          if ReachedEol then StreamWriteln(F,Copy(line,1,ii-1),UnixOut)
          else StreamWrite(F,Copy(line,1,ii-1));
        end;
        Delete(line,1,ii+5);
        nbr:=1;
        SortEnv:=true;
      end;
    end;
    if SortEnv then
    begin
      ii:=0;
      while (ii<length(line)) and (nbr>0) do
      begin
        inc(ii);
        if line[ii]=lbrace then inc(nbr)
        else if line[ii]=rbrace then dec(nbr);
      end;
      if nbr=0 then 
      begin
        Delete(line,1,ii);
        SortEnv:=false;
      end else line:='';
      wblank:=false;
    end;
    if (line<>'') or wblank then
    begin
      if ReachedEol then StreamWriteln(F,line,UnixOut)
      else StreamWrite(F,line);
    end;
    if ReachedEol and ((ToPos<0) or (pl<ToPos)) then
    begin
      SkipOneLine(ImpF,UnixIn);
      inc(pl); if not UnixIn then inc(pl);
    end;
  until eof(Impf) or ((ToPos>=0) and (pl>=ToPos));
  if F^.status<>stOK then ok:=false;
  TextSeek(ImpF,ToPos);
end;                        { CopyFileHeader }

procedure WriteFromTo(FromFile,ToFile: PStream; var CurPos: longint;
                      Size,ToPos,IgStartPos,IgEndPos: longint;
                      Unix: boolean);
begin
  if (FromFile=Nil) or (ToFile=Nil) then Exit;
  if ToPos<0 then ToPos:=size;
  if IgStartPos<0 then IgStartPos:=size;
  if IgEndPos<0 then IgEndPos:=size;
{
  message('From '+num2str(CurPos)+' to '+num2str(ToPos)+', ig '+
          num2str(IgStartPos)+' to '+num2str(IgEndPos));
}
  if CurPos>=ToPos then Exit;
  if (ToPos<=IgStartPos) or (CurPos>IgEndPos) then
  begin
    ToFile^.CopyFrom(FromFile^,ToPos-CurPos);
  end else
  begin
    if CurPos<IgStartPos then
    begin
      ToFile^.CopyFrom(FromFile^,IgStartPos-CurPos); CurPos:=IgStartPos;
    end;
    if ToPos>IgEndPos then
    begin
      FromFile^.seek(IgEndPos+1); CurPos:=IgEndPos+1;
      if ToPos>CurPos then ToFile^.CopyFrom(FromFile^,ToPos-CurPos);
    end else
    begin
      FromFile^.seek(ToPos);
    end;
  end;
  CurPos:=ToPos;
end;                            { WriteFromTo }

Const
  PresortElist = true;
  CFirst: string[1] = #0;
  CLast:  string[1] = #255;

function CompareEntries(M: ConfigSortPtr; Srec1,Srec2: SortRecType): Integer;
var
  i,c,Nkey: integer;

function CompEntryName(Name1,Name2: string; MixedCollation: boolean): integer;
var
  ctmp: integer;
  i,L1,L2,Lmax: Byte;
  Finish: Boolean;
  ch1,ch2: Byte;
  x1,x2: real;
  icode1,icode2: integer;
begin                                  { CompEntryName }
  if Name1=Name2 then
  begin
    CompEntryName:=0;
    Exit;
  end;
  icode1:=1; icode2:=1;
  Val(Name1,x1,icode1);
  if icode1=0 then
  begin
    Val(Name2,x2,icode2);
    if icode2=0 then
    begin
      if x1<x2 then CompEntryName:=-1
      else if x1>x2 then CompEntryName:=1
      else CompEntryName:=0;
      exit;
    end;
  end;
  L1:=length(Name1); L2:=length(Name2); Lmax:=L1;
  if L1>L2 then
    begin
    for i:=L2+1 to L1 do Name2[i]:=#0; Name2[0]:=Chr(L1);
  end else if L1<L2 then
  begin
    for i:=L1+1 to L2 do Name1[i]:=#0; Name1[0]:=Chr(L2); Lmax:=L2;
  end;
  ctmp:=StrCmpI(Name1,Name2,1,1,Lmax);
  if MixedCollation and (ctmp=0) then
  begin
    i:=0; finish:=false;
    while (i<Lmax) and (not Finish) do
    begin
      Inc(i);
      if MixedCollation then
      begin
        ch1:=MixedSortOrder^[Ord(Name1[i])];
        ch2:=MixedSortOrder^[Ord(Name2[i])];
      end;
      if ch1 < ch2 then
      begin
        ctmp:=-1;
        Finish:=true;
      end
      else if ch1 > ch2 then
      begin
        ctmp:=1;
        Finish:=true;
      end;      
    end;
  end;
  CompEntryName:=ctmp;  
end;                       { CompEntryName }

begin                      { CompareEntries }
  c:=0;
  if EditOnlyStrings then
  begin
    if M^.StringNameSort=StrSortOff then c:=0
    else if Srec1.name=Srec2.name   then c:=0
    else if Srec1.name=CFirst       then c:=-1
    else if Srec1.name=CLast        then c:=1
    else if Srec2.name=CFirst       then c:=1
    else if Srec2.name=CLast        then c:=-1
    else if StrCmpI(Srec1.name,PreambleEntryName,1,1,255)=0 then c:=1
    else if StrCmpI(Srec2.name,PreambleEntryName,1,1,255)=0 then c:=-1
    else if M^.StringNameSort=StrSortAscend then
      c:=CompEntryName(Srec1.Name,Srec2.Name,M^.MixedCollation)
    else c:=-CompEntryName(Srec1.Name,Srec2.Name,M^.MixedCollation);
    CompareEntries:=c;
    Exit;
  end;
  for i:=1 to NSortKeys do
  begin
    if Srec1.Keys[i]='' then
    begin
      if M^.NullKeyFirst[i,Srec1.Patt] then Srec1.Keys[i]:=Cfirst
      else Srec1.Keys[i]:=CLast;
    end;
    if Srec2.Keys[i]='' then
    begin
      if M^.NullKeyFirst[i,Srec2.Patt] then Srec2.Keys[i]:=Cfirst
      else Srec2.Keys[i]:=CLast;
    end;
  end;
  for i:=1 to length(M^.SortTypeOrder) do
  if c=0 then
  begin
    Nkey:=Ord(M^.SortTypeOrder[i]);
    case M^.SortTypeOrder[i] of
      'P': begin
        if (Srec1.Patt) and (not Srec2.Patt) then
        begin
          if M^.PattFirst then c:=-1
          else c:=1;
        end else if (Srec2.Patt) and (not Srec1.Patt) then
        begin
          if M^.PattFirst then c:=1
          else c:=-1;
        end;
      end;
      #1..Chr(NSortKeys):
        if (M^.SortKey[Nkey,true]<>'') or (M^.SortKey[Nkey,false]<>'') then
      begin
        if Srec1.keys[Nkey]=Srec2.keys[Nkey] then c:= 0
        else if Srec1.keys[Nkey]=CFirst      then c:=-1
        else if Srec1.keys[Nkey]=CLast       then c:= 1
        else if Srec2.keys[Nkey]=CFirst      then c:= 1
        else if Srec2.keys[Nkey]=CLast       then c:=-1
        else if M^.KeyAsc[Nkey,Srec1.patt]   then
          c:=CompEntryName(Srec1.Keys[Nkey],Srec2.Keys[Nkey],M^.MixedCollation)
        else c:=-CompEntryName(Srec1.Keys[Nkey],Srec2.Keys[Nkey],M^.MixedCollation);
      end;
      'N': begin
        if Srec1.name=Srec2.name  then c:= 0
        else if Srec1.name=CFirst then c:=-1
        else if Srec1.name=CLast  then c:= 1
        else if Srec2.name=CFirst then c:= 1
        else if Srec2.name=CLast  then c:=-1
        else if M^.NameAsc[Srec1.patt] then
          c:=CompEntryName(Srec1.Name,Srec2.Name,M^.MixedCollation)
        else c:=-CompEntryName(Srec1.Name,Srec2.Name,M^.MixedCollation);
      end;
      #0:;
    end;
  end;
  CompareEntries:=c;
end;                              { CompareEntries }

{$F+}
procedure RRec(P: PAuxStream; Rec: pointer); 
begin
  ReadSortRec(P,SortRecPtr(Rec)^);
end;

procedure WRec(P: PAuxStream; Rec: pointer); 
begin
  WriteSortRec(P,SortRecPtr(Rec)^);
end;

function CRecs(R1,R2: pointer): integer;
begin
  CRecs:=CompareEntries(GlobalPointer,SortRecPtr(R1)^,SortRecPtr(R2)^);
end;
{$F-}

function BibFileChange(Pattern: PatRecPtr; Entry: EntryRecPtr;
                       OldName: string;
                       Action: integer; equiv: boolean;
                       ImpFile: string; ExpMode: byte;
                       WSortMode,selected: byte; InpPtr: Pointer): boolean;
Label
  EndOfProcess, AllocationError;
var
  changed,ok,frst,moved,written,found,WriteIndexFile,SavedSortOK: boolean;
  leave,fail,sorted,MakeList,TheFileExists,MakeInputIndex: boolean;
  PFirst,PLast,UnixImp,HasSortEnv,PreSorted,OldUnixBib: Boolean;
  AddSortEnv,BeforeEntries,Ttag,Cbool,CurrentIndex,WasLinked: Boolean;
  WriteSuccess,UseClipboard: boolean;
  fields: FieldArr;
  LastSrec,LastSrec2,LastESrec,TSrec,WriteRec: SortRecPtr;
{$IFNDEF WINDOWS}
  RLastSrec,RLastSrec2,RLastESrec,RTSrec,RWriteRec: SortRecType;
{$ENDIF}
  FirstEntry,InsPlace,IgStart,IgEnd,CELast,NumWritten,FirstEntPos: longint;
  ii,DiskSpace,BibSize,Opos,size,elistpos,gt,ntime,Scroll,LastY: longint;
  BibFileTime,IndexFileTime,CurBibPos,EndOfHeader,AddShift,AuxPlace: longint;
  OldFirst,OldLast: longint;
  ercode,OldVerbosity: Byte;
  i,iii,n,ns,icode: integer;
  nadded,nabs,nentries,INentries,InsNumber,IgNumber,NewIgNumber: Word;
  OldRealNum,OldEntryNum: word;
  line,tmp,IgName,LastEntryName: string;
  SortPattern,SavedPatt: PatRecPtr;
  M,SavedMode: ConfigSortPtr;
  SPPos: LongInt;
  SPMode: KeepModeType;
  elist,Telist,TempEntries,Paux: PAuxStream;
  IndexFile,BibStream: PSafeBufStream;
  Dir,FileName,Ext,IndName,OldBibName: PString;
  DelFile: file;
  Preamble: text;
  logfile: text;
  NameIndex: PBigCol;

procedure IndexBibFile(elist: PStream; Entry: EntryRecPtr; var Last: longint;
                       var nentries: Word; var Cok: boolean);
var
  ch: char;
  ok,leave: boolean;
  ercode: byte;
  ReadAll: boolean;
  i: integer;
begin
  ReadAll:=false; Cok:=true;
  WaitingMessage('Indexing...');
  BeforeEntries:=false;
  for i:=1 to NSortKeys do
    if (M^.SortKey[i,true]<>'') or
       (M^.SortKey[i,false]<>'') then ReadAll:=true;
  if M^.SortPatternExists then ReadAll:=true;
  nentries:=0; Last:=-1;
  ResetBib(Entry);
  repeat
    leave:=true;
    entry^.name:='';
    GetEntry(Entry,Nil,nentries+1,true,Nil,ok);
    ChrDel(entry^.name,' ');
    if (entry^.name<>'') and (nentries<entry^.realnum) and (ok) then
    begin
      if FirstEntry<0 then FirstEntry:=Entry^.beginning;
      Last:=entry^.ending;   { End of entries }
      leave:=false;
      WriteEList(elist,M^,SortPattern,Entry);
      if NameIndex<>Nil then NameIndex^.AddString(Entry^.Name);
      inc(nentries);
    end;
    TrapAbort;
  until leave or AbortFlag;
  elist^.flush;
  if EditOnlyStrings and ((nentries=0) or WriteIndexFile) and (not AbortFlag) then
  begin
    ResetBib(Entry);
    EditOnlyStrings:=false;
    GetEntry(Entry,Nil,entry^.entrynum+1,false,Nil,ok);
    if ok then
    begin
      if nentries=0 then
      begin
        Last:=entry^.beginning-1; BeforeEntries:=true;
      end else FirstEntPos:=entry^.beginning;
    end;
    EditOnlyStrings:=true;
  end;
  CloseFile(bib);
end;                              { IndexBibFile }

procedure SortElist(TElist: PAuxStream; N: longint; var ok: boolean);
var
  Rec1,rec2: SortRecType;
begin
  GlobalPointer:=M;
  WaitingMessage('Sorting...');
  ok:=SortAList(TEList,N,@Rec1,@Rec2,RRec,WRec,CRecs);
end;

function SortModeAsk(P: PStream; nentries: longint): boolean;
var
  ThisSrec,PrevSrec: SortRecType;
  i: longint;
  Sorted: boolean;
begin                       { SortModeAsk }
  if (P=Nil) or (nentries<2) then 
  begin
    SortModeAsk:=false;
    exit;
  end;
  Sorted:=true;
  P^.Flush; P^.seek(0); 
  ReadSortRec(p, PrevSrec); {message('First name is "'+PrevSrec.name+'"');}
  i:=2;
  while Sorted and (i<=nentries) do
  begin
    ReadSortRec(p, ThisSrec); {message('next name is "'+ThisSrec.name+'"');}
    if (ThisSrec.name<>'') and (CompareEntries(M,ThisSrec,PrevSrec)=-1) then
    begin
      Sorted:=false;
      ErrorMessageRC(Str_EntriesInWrongOrder, ThisSrec.name+'" and "'
                     +PrevSrec.name);
    end;
    PrevSrec:=ThisSrec;
    inc(i);
  end;
  P^.Flush;
  SortModeAsk:=Sorted;
end;                        { SortModeAsk }

procedure GetLastPlace(var Place: longint; var Entry: EntryRecPtr);
var
  entmax: word;
  ok: boolean;
  StartPlace,EndPlace,i: longint;
  Srec: SortRecType;
begin                                    { GetLastPlace }
  EndPlace:=-1;
  StartPlace:=EndPlace;
  BeforeEntries:=false;
  entmax:=0;
  ok:=true;
  if elist=Nil then
  begin
    ResetBib(Entry);
    GetEntry(Entry,Nil,entry^.entrynum+1,false,Nil,ok);
    while ok and (entry^.entrynum>entmax) do
    begin
      entmax:=entry^.entrynum;
      StartPlace:=entry^.beginning;
      GetEntry(Entry,Nil,entry^.entrynum+1,false,Nil,ok);
    end;
  end else          { Use the index file }
  begin
    elist^.reset; elist^.seek(0); Srec.place:=-1;
    for i:=1 to nentries do ReadSortRec(Elist,Srec);
    StartPlace:=Srec.place;
    entmax:=nentries;
    elist^.reset; elist^.seek(0);
  end;
  if (entmax=0) and EditOnlyStrings then
  begin
    ResetBib(Entry);
    EditOnlyStrings:=false;
    GetEntry(Entry,Nil,1,false,Nil,ok);
    if ok then
    begin
      EndPlace:=entry^.beginning-1; BeforeEntries:=true;
    end;
    EditOnlyStrings:=true;
  end else if entmax>0 then
  begin
    ResetBib(Entry);
    ReachEntry(Entry,entmax,entmax,StartPlace,false);
    EndPlace:=entry^.ending;
  end;
  Place:=EndPlace;
end;                                    { GetLastPlace }

procedure AskAddWhere(action: integer; var InsPlace: longint; 
                      var moved, aok: boolean; selected: byte);
var
  ok,accept,chosen: boolean;
  line: string;
  icode, toentry, Menupos: integer;
  inpfile: text;
  xstart: byte;
  entmax: Word;

procedure AtFirst;
begin
  ResetBib(Entry);
  GetEntry(Entry,Nil,1,false,Nil,ok);
  moved:=true;
  if ok then
  begin
    insplace:=Entry^.beginning;
    InsNumber:=Entry^.realnum;
  end else if EditOnlyStrings then
  begin
    EditOnlyStrings:=false;
    ResetBib(Entry);
    GetEntry(Entry,Nil,1,false,Nil,ok);
    EditOnlyStrings:=true;
    if ok then
    begin
      insplace:=Entry^.beginning;
      InsNumber:=Entry^.realnum;
    end;
  end;
  if not ok then
  begin
    InsPlace:=CEnd; InsNumber:=0;
  end;
end;                                       { AtFirst }

begin                                      { AskAddWhere}
  aok:=false;
  if (Action<>Ac_Add) and (Action<>Ac_Import) and (action<>Ac_Export)
     and (action<>Ac_Strings) then Exit;
  aok:=true;
  moved:=false;
  ok:=true;
  InsPlace:=-1;
  if selected=CIns_EOF then                        { After last }
  begin
    GetLastPlace(CELast,Entry);
    if CELast=-1 then InsPlace:=CEnd
    else InsPlace:=CELast+1;
    InsNumber:=0;
    ResetBib(Entry);
  end else if selected=CIns_BeforeCurr then         { Before Current}
  begin
    if OldRealNum=0 then AtFirst
    else begin
      insplace:=OldFirst; InsNumber:=OldRealNum;
    end;
  end else if selected=CIns_AfterCurr then           { After  Current}
  begin
    if OldRealNum=0 then AtFirst
    else begin
      insplace:=OldLast+1; InsNumber:=OldRealNum+1;
    end;
  end else if selected=CIns_Num then                    { Number }
  begin
    line:='';
{$IFDEF WINDOWS}
    if InpPtr<>Nil then
    begin
      line:=num2str(PLongint(InpPtr)^); accept:=true;
    end else
{$ENDIF}
    if MacroCommand then
    begin
      line:=InputStr^; accept:=true;
    end else
      GetAString(' Insert before number ',line,4,6,34,[#0..#255]-['0'..'9'],
               accept,false);
    if accept and (line<>'') then
    begin
      Val(line,toentry,icode);
      if (icode=0) and (ToEntry<1) then icode:=1;
      if icode=0 then
      begin
        ResetBib(Entry);
        GetEntry(Entry,Nil,toentry,false,Pattern,ok);
        moved:=true;
      end else ok:=false;
      if (not ok) or (toentry<>Entry^.entrynum) then
      begin
        if not MacroCommand then
        begin
          if EditOnlyStrings then ErrorMessageRC(Str_StringNumNotExist,line)
          else ErrorMessageRC(Str_EntryNumNotExist,line);
        end;
        failure:=true;
{$IFNDEF WINDOWS}
        if Usemouse then WaitForRelease(255);
{$ENDIF}
        aok:=false;
      end else
      begin
        insplace:=Entry^.Beginning; InsNumber:=Entry^.realnum;
      end;
    end else aok:=false;
  end else if selected=CIns_EntryList then  { list }
  begin
    ShowEntryList(Entry,Pattern,chosen,found); Moved:=true;
    if found then
    begin
      if chosen then
      begin
        insplace:=Entry^.Beginning;
        InsNumber:=Entry^.realnum;
      end else
      begin
        insplace:=-1;
        aok:=false;
      end;
    end else
    begin
      if EditOnlyStrings then ErrorMessageRC(Str_NoStringFound,'')
      else ErrorMessageRC(Str_NoEntryFound,'');
      ok:=false; aok:=false;
    end;
  end else if selected=CIns_FirstEntry then AtFirst;     { first }
end;                                     { AskAddWhere }

procedure ExportEnt(Entry: EntryRecPtr; Pattern: PatRecPtr;
                 var ImpFile: string; var written,changed,UnixImp: boolean;
                 Elist,TEList,TempEntries: PStream;
                 var nadded: word; var LastEntryName,OldBibname: string;
                 var FirstEntry: longint;
                 SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                 MakeList,WasLinked: boolean; ExpMode: byte);
var
  op,nomore,ok,skip,skipall,OldUnixBib,btmp,accept,FirstCurrent: boolean;
  OldBibFileExists,AbortIt,EditIt,SkipDupsNow: boolean;
  opos,NextNumber,FromNumber,ToNumber: longint;
  ename: string;
  choice,icode: integer;
  ercode: byte;
  ToRealNum,i,j: Word;
  OldBibInRing: byte;
  ExpFile: string;
  forder: text;

procedure GetNextOne(Entry: EntryRecPtr; var ok: boolean);
var
  ename: string;
  i: integer;
  Ttag: boolean;
begin
  if ExpMode=CExp_Current then
  begin
    if not FirstCurrent then ok:=false
    else begin
      TempEntries^.flush; TempEntries^.seek(0);
      GetEntryTemp(TempEntries,Entry,Ttag);
      TempEntries^.seek(0);
      FirstCurrent:=false;
    end;
  end else if ExpMode=Cexp_Tagged then
  begin
    NextNumber:=Entry^.realnum+1;
    while (NextNumber<$ffff) and (not IsTagged(NextNumber,Tags)) do inc(NextNumber);
    if IsTagged(NextNumber,Tags) then
      GetEntry(Entry,Nil,NextNumber,true,Nil,ok)
    else ok:=false;
  end else if ExpMode=Cexp_Range then
  begin
    if (ToNumber>0) and (NextNumber>ToNumber) then ok:=false
    else begin
      GetEntry(Entry,Nil,NextNumber,true,Pattern,ok);
      inc(NextNumber);
    end;
  end else if ExpMode=CExp_All then
  begin
    GetEntry(Entry,Nil,NextNumber,true,Pattern,ok);
    if ok and (Entry^.entrynum<>NextNumber) then ok:=false
    else inc(NextNumber);
  end else if ExpMode=CExp_Ofile then
  begin
    if Eof(forder) then ok:=false
    else begin
      ReadLine(forder,Ename,true);
      i:=Pos(CommaSeparator,Ename);
      if i>0 then Ename[0]:=Chr(i-1);
      if (ename<>'') and (Ename[1]='"') then Delete(Ename,1,1);
      if (Ename<>'') and (Ename[length(ename)]='"') then
        Delete(Ename,length(ename),1);
      ok:=false;
{      message('Searching for "'+ename+'"');}
      DisableIndexFile:=true;
      ReachLabel(Entry,Pattern,ename,true,false,true,ok);
      DisableIndexFile:=false;
{      if ok then message('ok') else message('not ok');}
    end;
  end;
end;                                 { GetNextOne }

procedure TidyUp;
begin
  TempEntries^.flush;
  if MakeList then TElist^.flush;
  LFNClose(bib);
  BibInRing:=OldBibInRing;
  if UseClipboard then BibName^:=File_Clipboard
  else begin
    BibName^:=DumpName^;
    LFNAssign(bib,bibname^); UnixBib:=OldUnixBib;
    BibFileExists:=OldBibFileExists;
    SetTextBuf(bib,bibbuf^,FileBufSize);
  end;
  Linked:=false;
  if ExpMode=CExp_Ofile then LFNClose(forder);
  LFNDispose(forder);
end;

begin                                    { Export }
  OldBibInRing:=BibInRing;
  if not UseClipboard then
  begin
    OldUnixBib:=UnixBib; 
    OldBibFileExists:=BibFileExists;
    MaxMemAvail;
  end;
  if WasLinked then
  begin
    ExpFile:=BibFiles^[BibRing[1]].name;
    Linked:=true;
    BibInRing:=1;
  end else ExpFile:=OldBibName;
  BibFileExists:=true; bibname^:=ExpFile;
  LFNClose(bib);
  LFNAssign(bib,ExpFile); UnixBib:=IsUnixFile(bib,ExpFile); UnixImp:=UnixBib;
  SetTextBuf(bib,bibbuf^,FileBufSize);
  nadded:=0;
  SkipAll:=MacroCommand;
  FirstCurrent:=true;
  LFNNew(forder,true);
  if ExpMode=CExp_Range then
  begin
    i:=Pos(' ',ImpFile);
    Val(Copy(ImpFile,1,i-1),FromNumber,Icode);
    Val(Copy(ImpFile,i+1,255),ToNumber,Icode);
  end else if ExpMode=CExp_Ofile then
  begin
    LFNAssign(forder,ImpFile);
    if LFNReset(forder,0)<>0 then
    begin
      ErrorMessageRC(Str_CantOpenOrderFile,'');
      TidyUp; Exit;
    end;
  end;
  WaitingMessage('Exporting...');
  ResetBib(Entry);
  GetEntry(Entry,Nil,1,true,Nil,ok);
  if (not linked) or (BibInRing=1) then FirstEntry:=Entry^.Beginning
  else FirstEntry:=-1;
  ToRealNum:=0;
  ResetBib(Entry);
  NextNumber:=1;
  if ExpMode=CExp_Range then NextNumber:=FromNumber;

  GetNextOne(Entry,ok);
  if not ok then
  begin
    TidyUp; Exit;
  end;
  
  ChrDel(Entry^.name,' ');
  nomore:=false;
  TempEntries^.seek(0); TempEntries^.truncate;

  repeat
    { message('Processing entry "'+entry^.name+'"'); }
    if Entry^.name<>'' then
    begin
      ename:=entry^.name;
{$IFDEF WINDOWS}
      if nadded=0 then
        CheckEntryName(Nil,elist,Nil,NameIndex,entry^.name,'',not SkipAll,false,true,
                 SkipAll,Skip,AbortIt,EditIt,SkipDupsNow)
      else
        CheckEntryName(Nil,elist,TElist,NameIndex,entry^.name,'',not SkipAll,false,true,
                 SkipAll,Skip,AbortIt,EditIt,SkipDupsNow);
      if AbortIt then
      begin
        nadded:=0;
        written:=false;
        nomore:=true;
      end;
{$ELSE}
      CheckEntryName(elist,Entry^.name,'',false);
      if Entry^.name<>'' then CheckEntryName(Telist,Entry^.name,'',false);
      repeat
        Skip:=false;
        if (Entry^.name='') and (not SkipAll) then
        begin
          if EditOnlyStrings then
            choice:=AskIf4(' String "'+ename+'" is duplicated! ',
              'Rename', 'Skip dup.', 'Ignore', 'Abort')
          else
            choice:=AskIf4(' Entry "'+ename+'" is duplicated! ',
              'Rename', 'Skip dup.', 'Ignore', 'Abort');
          if choice=4 then
          begin        
            nadded:=0;
            written:=false;
            nomore:=true;
          end else if choice=1 then
          begin
            if EditOnlyStrings then
              GetAString(' Enter new string name: ',Ename,4,50,48,
                         NameForbid,accept,true)
            else
              GetAString(' Enter new entry name: ',Ename,4,50,48,
                         NameForbid,accept,true);
            if not accept then Ename:='';
            Entry^.name:=Ename;
          end else if choice=2 then
          begin
            SkipAll:=true;
          end else if Choice=3 then
          begin
            Skip:=true; Entry^.name:='';
          end;
        end;
        if entry^.name<>'' then
        begin
          ename:=entry^.name;
          CheckEntryName(elist,Entry^.name,'',false);
          if Entry^.name<>'' then CheckEntryName(Telist,Entry^.name,'',false);
        end;
      until (Entry^.name<>'') or (Skip) or (nomore) or (SkipAll);
{$ENDIF}
      if (Entry^.name<>'') and (not nomore) then
      begin
        Entry^.beginning :=TempEntries^.getsize;
        WriteSuccess:=WriteSuccess and PutEntryTemp(TempEntries,Entry,false);
        if (not WriteSuccess) or (TempEntries^.status<>stOK) then
        begin
          TidyUp; Exit;
        end;
        if MakeList then
        begin
          TElist^.seek(TElist^.getsize);
          WriteElist(Telist,SMode^,SortPattern,Entry);
          if NameIndex<>Nil then NameIndex^.AddString(Entry^.Name);
          if Telist^.status<>stOK then
          begin
            TidyUp; Exit;
          end;
        end;
        written:=true;
        Inc(nadded);
        WaitingMessage('Exported '+num2str(nadded)+'...');
      end;
      if not nomore then
      begin
        GetNextOne(Entry,ok); if not ok then nomore:=true;
        ChrDel(Entry^.name,' ');
      end;
    end;
    TrapAbort;
  until nomore or AbortFlag;

  if AbortFlag then
  begin
    written:=false; nadded:=0;
  end;
  TidyUp;
end;                                  { Export }

procedure ReformatFile;
var
  ok: boolean;
begin                                    { Reformat }
  WaitingMessage('Reading...');
  ResetBib(Entry);
  nadded:=0;
  GetEntry(Entry,Nil,1,true,Nil,ok);
  FirstEntry:=Entry^.Beginning;
  IgStart:=Entry^.beginning;
  InsPlace:=Entry^.beginning;
  TempEntries^.seek(0); TempEntries^.truncate;

  while ok and (Entry^.realnum>nadded) and (not AbortFlag) do
  begin
    IgEnd:=Entry^.ending;
    written:=true;
    Entry^.beginning:=TempEntries^.getsize;
    WriteSuccess:=WriteSuccess and PutEntryTemp(TempEntries,Entry,IsTagged(entry^.realnum,Tags));
    if (not WriteSuccess) or (TempEntries^.status<>stOK) then Exit;
    if MakeList then
    begin
      TElist^.seek(TElist^.getsize);
      WriteElist(Telist,M^,SortPattern,Entry);
      if NameIndex<>Nil then NameIndex^.AddString(Entry^.Name);
      if Telist^.status<>stOK then Exit;
    end;
    written:=true;
    Inc(nadded);
    GetEntry(Entry,Nil,entry^.entrynum+1,true,Nil,ok);
    TrapAbort;
  end;
  TempEntries^.flush; if MakeList then TElist^.flush;
  if AbortFlag then
  begin
    written:=false; nadded:=0;
  end;
end;                                  { ReformatFile }

procedure InsertEntry;
{$IFDEF WINDOWS}
var
  SkipDups,QuitIt,AbortIt,EditIt,SkipDupsNow: boolean;
{$ENDIF}
begin                           { InsertEntry }
  TempEntries^.flush; TempEntries^.seek(0);
  GetEntryTemp(TempEntries,Entry,Ttag);
{$IFDEF WINDOWS}
  SkipDups:=false; QuitIt:=false; AbortIt:=false; EditIt:=false;
  CheckEntryName(Nil,elist,Nil,NameIndex,Entry^.name,IgName,true,false,false,SkipDups,QuitIt,
                 AbortIt,EditIt,SkipDupsNow);
{$ELSE}
  CheckEntryName(elist,Entry^.name,IgName,true);
{$ENDIF}
  if Entry^.name='' then Exit;
  Entry^.beginning:=0;
  TempEntries^.seek(0); TempEntries^.truncate;
  WriteSuccess:=WriteSuccess and PutEntryTemp(TempEntries,Entry,false);
  if not WriteSuccess then Exit;
  TempEntries^.flush;
  LastEntryName:=Entry^.name;
  if MakeList then
  begin
    TElist^.seek(TElist^.getsize);
    WriteElist(TElist,M^,SortPattern,Entry);
    if NameIndex<>Nil then NameIndex^.AddString(Entry^.Name);
    TElist^.flush;
  end;
  Inc(nadded);
  written:=true;
end;                                     { InsertEntry }

{$IFDEF WINDOWS}
procedure InsertAllStrings;
var
  i,j,OldVerbosity: integer;
  l: longint;
begin
  TempEntries^.flush; TempEntries^.seek(0);
  OldVerbosity:=Verbosity; Verbosity:=0;
  for i:=0 to PSortedCollection(InpPtr)^.Count-1 do
  with POneStringObj(PSortedCollection(InpPtr)^.at(i))^ do
  begin
    ZeroEntry(Entry);
    with Entry^ do
    begin
      name:=SName^;
      nentry:=1;
      if StrCmpI(name,PreambleEntryName,1,1,255)=0 then
         EntryType:=TypeEntry^[PreambleTypeInd]
      else EntryType:=TypeEntry^[StringTypeInd];
      field[1]:=TypeField^[StringIndex];
      index[StringIndex]:=1;
      if StrLen(SValue)<256 then Content[1]:=StrPas(SValue)
      else begin
        Move(SValue^,Content[1][1],255); Content[1][0]:=#255;
        j:=FindBigFree(Entry,true);
        if j>0 then
        begin
          BigIndex[StringIndex]:=j;
          BLen[j]:=imin(StrLen(SValue),MaxBig);
          StrLCat(PChar(Big[j]),SValue,BLen[j]);
        end;
      end;
    end;

    Entry^.beginning:=TempEntries^.getsize;
    TempEntries^.seek(TempEntries^.getsize);
    WriteSuccess:=WriteSuccess and PutEntryTemp(TempEntries,Entry,false);
    TempEntries^.flush;
    LastEntryName:=Entry^.name;
    if MakeList then
    begin
      TElist^.seek(TElist^.getsize);
      WriteElist(TElist,M^,SortPattern,Entry);
      if NameIndex<>Nil then NameIndex^.AddString(Entry^.Name);
      TElist^.flush;
    end;
    Inc(nadded);
    written:=true;
  end;
  Verbosity:=OldVerbosity;
end;
{$ENDIF}

procedure CopyHeader(F: PStream; Unix: boolean);
var
  Hok: boolean;
  ImpF: text;
begin
  if ImportFormat<>BibTeXFormat then Exit;
  LFNNew(ImpF,true);
  if action=Ac_Export then
  begin
    if WasLinked then LFNAssign(ImpF,BibFiles^[BibRing[1]].name)
    else LFNAssign(ImpF,OldBibName^);
  end else LFNAssign(ImpF,ImpFile);
  LFNReset(ImpF,0);
  CopyFileHeader(ImpF,F,FirstEntry,UnixImp,Unix,Hok);
  LFNDispose(ImpF);
end;                 { CopyHeader }

procedure TidyUp;
begin
  if BibStream<>Nil then
  begin
    BibStream^.reset; Dispose(BibStream,Done); BibStream:=Nil;
  end;
  if Paux<>Nil then
  begin
    Paux^.reset; Dispose(Paux,Done); Paux:=Nil;
  end;
  if IndexFile<>Nil then
  begin
    IndexFile^.Reset; Dispose(IndexFile,Done); IndexFile:=Nil;
  end;
  if elist<>Nil then
  begin
    elist^.reset; Dispose(elist,Done); elist:=Nil;
  end;
  if Telist<>Nil then
  begin
    TElist^.reset; Dispose(Telist,Done); Telist:=Nil;
  end;
  if TempEntries<>Nil then
  begin
    TempEntries^.reset; Dispose(TempEntries,Done); TempEntries:=Nil;
  end;
  if (SortPattern<>Nil) and (SPMode<>KeepInMemory) then
  begin
    Dispose(SortPattern); SortPattern:=Nil;
  end;
  if NameIndex<>Nil then Dispose(NameIndex,Done);
{$IFDEF WINDOWS}
  if LastSrec <>Nil then Dispose(LastSrec);  LastSrec:=Nil;
  if LastSrec2<>Nil then Dispose(LastSrec2); LastSrec2:=Nil;
  if LastESrec<>Nil then Dispose(LastESrec); LastESrec:=Nil;
  if TSrec    <>Nil then Dispose(TSrec);     TSrec:=Nil;
  if WriteRec <>Nil then Dispose(WriteRec);  WriteRec:=Nil;
{$ENDIF}
  WaitingOff;
  Verbosity:=OldVerbosity;
  if action=Ac_Export then
  begin
    CloseFile(bib);
    BibName^:=OldBibName^;
    UnixBib:=OldUnixBib;
    Linked:=WasLinked;
    BibFileExists:=LFNFileExist(bibname^);
    LFNAssign(bib,bibname^); SetTextBuf(bib,bibbuf^,FileBufSize);
    CheckForIndexFile(bib,bibname);
    ResetBib(Entry);
  end;
  AllocStrings(false,@IndName,@OldBibName,Nil,Nil);
  AllocStrings(false,@Dir,@FileName,@Ext,Nil);
end;                                  { TidyUp }

begin                                 { BibFileChange }
  BibFileChange:=false; WriteSuccess:=true;
  NameIndex:=Nil;
  if (bibname^='') or (CurrentBibFile=0) then Exit;
  if Linked and (action<>Ac_Export) then
  begin
    ErrorMessageRC(Str_NoChangeInLink,''); Exit;
  end;
  if (TempDirList^='') then
  begin
    ErrorMessageRC(Str_NoAuxDir,''); Exit;
  end;
  if (action=Ac_Import) and (ImpFile='') then Exit;
  UseClipboard:=(action=Ac_Import) and (ImpFile=File_Clipboard);
  if (action=Ac_Export) and (ImpFile<>'') and (ImpFile[1]=File_Clipboard) then
  begin
    UseClipboard:=true; Delete(ImpFile,1,1);
  end;
  if (action=Ac_Index) and EditOnlyStrings then
  begin
    ErrorMessageRC(Str_CantIndexStrings,''); Exit;
  end;
  
  AllocStrings(true,@Dir,@FileName,@Ext,Nil);
  AllocStrings(true,@IndName,@OldBibName,Nil,Nil);
  SortPattern:=Nil; WasLinked:=false;
  Paux:=Nil; TempEntries:=Nil; TElist:=Nil; elist:=Nil; IndexFile:=Nil;
  BibStream:=Nil;
  SPMode:=DontKeep; SPPos:=-1;
  TimeOutOn:=false;
  HasSortEnv:=false;
  OldVerbosity:=Verbosity; Verbosity:=0;
  BeforeEntries:=false;
  written:=false;
  nadded:=0;
  nentries:=0; INentries:=0;
  IgName:=''; IgNumber:=0;
  CELast:=CEnd;
  IgStart:=CEnd; IgEnd:=CEnd; InsPlace:=CEnd; InsNumber:=0;
  FirstEntry :=-1;
  FirstEntPos:=-1;
  Sorted:=false;
  if action=Ac_Export then
  begin
    for i:=1 to maxfield do fields[i]:=DumpFields[i];
    Fields[MaxField+1]:=true;
  end else for i:=1 to maxfield+1 do fields[i]:=true;
  IndName^:='';
  OldRealNum:=Entry^.realnum; OldEntryNum:=Entry^.EntryNum;
  OldFirst:=Entry^.beginning; OldLast:=Entry^.Ending;
  LastEntryName:='';
  SavedSortOK:=true; SavedPatt:=Nil;
  M:=Nil; SavedMode:=Nil;
{$IFDEF WINDOWS}
  LastSrec:=Nil; LastSrec2:=Nil; LastESrec:=Nil;
  TSrec:=Nil; WriteRec:=Nil;
{$ELSE}
  LastSrec:=@RLastSrec; LastSrec2:=@RLastSrec2; LastESrec:=@RLastESRec;
  TSrec:=@RTSrec; WriteRec:=@RWriteRec;
{$ENDIF}

  if (action=Ac_Replace) or (action=Ac_Insert) or
     ((action=Ac_Export) and (ExpMode=CExp_Current)) or
     (MacroCommand and (action=Ac_Add)) then { Keeping the entry temporarily }
  begin
    New(TempEntries,Init(WorkStreamOrder));
    if (TempEntries=Nil) or (TempEntries^.status<>stOK) then goto AllocationError;
    TempEntries^.seek(0); TempEntries^.truncate;
    WriteSuccess:=WriteSuccess and PutEntryTemp(TempEntries,Entry,false);
    TempEntries^.flush;
  end;

  if action=Ac_Export then
  begin
    CloseFile(bib);
    WasLinked:=Linked;   Linked:=false;
    OldUnixBib:=UnixBib; OldBibName^:=BibName^;
    if UseClipboard then
    begin
      BibName^:=File_Clipboard;
    end else
    begin
      BibName^:=DumpName^; UnixBib:=UnixDump;
      LFNAssign(bib,bibname^); SetTextBuf(bib,bibbuf^,FileBufSize);
      ResetBib(Entry);
    end;
  end;

  if not WriteSuccess then
  begin
    AbortFlag:=true; goto AllocationError;
  end;

  TheFileExists:=(not ((action=Ac_Export) and UseClipboard))
                  and LFNFileExist(bibname^);
  if TheFileExists then BibSize:=FileSize(bibname^)
  else BibSize:=0;

  if WSortMode=1 then
  begin
    M:=ConfigSortMode;
    SPMode:=SortPattModeDef; SPPos:=SortPattPosDef;
  end else if WSortMode=2 then
  begin
    M:=CurrentSortMode;
    SPMode:=SortPattModeCur; SPPos:=SortPattPosCur;
  end else if WSortMode=3 then
  begin
    M:=ExportSortMode;
    SPMode:=SortPattModeExp; SPPos:=SortPattPosExp;
  end;
  if action=Ac_Sort then
  begin
    if EditOnlyStrings and (M^.StringNameSort=StrSortOff) then goto EndOfProcess;
    if not EditOnlyStrings and not M^.SortingOn then goto EndOfProcess;
  end;

  if Pos('P',M^.SortTypeOrder)=0 then M^.NameAsc[false]:=M^.NameAsc[true];
  for i:=1 to NSortKeys do
  if Pos(Chr(i),M^.SortTypeOrder)>0 then
  begin
    if (Pos('P',M^.SortTypeOrder)=0) or
       (Pos(Chr(i),M^.SortTypeOrder)<Pos('P',M^.SortTypeOrder)) then
    begin
      M^.KeyAsc[i,false]:=M^.KeyAsc[i,true];
      M^.NullKeyFirst[i,false]:=M^.NullKeyFirst[i,true];
      M^.SortKey[i,false]:=M^.SortKey[i,true];
    end;
  end;
  if M^.SortPatternExists then
  begin
    if SPMode=KeepInMemory then
    begin
      SortPattern:=PatRecPtr(KeepStack^[SPPos].P);
    end else if SPMode<>DontKeep then
    begin
      New(SortPattern);
      RecallBufferStack(SortPattern^,SPPos);
    end;
    SortPattern^.on:=true;
  end;

  { Does the file have a sort environment? Is is consistent? }

  if TheFileExists and (action<>Ac_Delete) then
  begin
    ResetBibFile(bib,bibname^);
    line:=''; i:=0;
    while (not eof(bib)) and (not HasSortEnv) and (i<MaxLookForSort) do
    begin
      ReadLine(bib,line,UnixBib);
      inc(i);
      UnTabify(line); ChrDelL(line,' '); StrLwr(line); 
      HasSortEnv:=(Pos('\sort'+lbrace,line)=1);
    end;
    if HasSortEnv and (action<>Ac_Sort) then { Consistency check }
    begin
      New(SavedMode);
      New(SavedPatt); SavedPatt^.noper:=0; SavedPatt^.npatt:=0;
      ZeroSortMode(SavedMode^,SavedPatt);
      MaxMemAvail;
      LoadSortMode(bib,Nil,SavedMode^,SavedPatt);
      ok:=EquivSortModes(M^,SavedMode^,SortPattern,SavedPatt);
      if (action=Ac_Strings) and EditOnlyStrings and
         (SavedMode^.StringNameSort<>M^.StringNameSort) then SavedSortOK:=false
      else if (EditOnlyStrings and (SavedMode^.StringNameSort<>StrSortOff) and
         (M^.StringNameSort=StrSortOff)) then SavedSortOK:=false
      else if SavedMode^.SortingOn and not M^.SortingOn then
      begin
        SavedSortOK:=false; ok:=true;
      end else if EditOnlyStrings and (SavedMode^.StringNameSort<>M^.StringNameSort) then
          ok:=false;
      Dispose(SavedPatt); SavedPatt:=Nil;
      Dispose(SavedMode); SavedMode:=Nil;
      if not ok then
      begin
        ErrorMessageRC(Str_WrongSortMode,'');
        CloseFile(bib);
        Goto EndOfProcess;
      end;
    end;
  end;
  CloseFile(bib);
  
  if (Action=Ac_Replace) or (Action=Ac_Delete) then
  begin
    IgName:=Oldname; Igstart:=OldFirst; IgEnd:=OldLast;
    IgNumber:=OldRealNum;
  end else
  begin
    IgName:=''; IgStart:=CEnd; IgEnd:=CEnd; IgNumber:=0;
  end;
  if Action=Ac_Delete then
  begin
    InsPlace:=CEnd; InsNumber:=0;
  end;

  if action=Ac_Sort then sorted:=true;
  if EditOnlyStrings and (M^.StringNameSort<>StrSortOff) then sorted:=true;
  if EditOnlyStrings and (action=Ac_Strings) then sorted:=false;
  if (not EditOnlyStrings) and M^.SortingOn then sorted:=true;
  if (action=Ac_Delete) or ((action=Ac_Replace) and equiv) or (action=Ac_Reformat)
     or (action=Ac_Index) then Sorted:=false;
  if (action=ac_Export) and UseClipboard then Sorted:=false;

  WriteIndexFile:=UseIndexFile;
  if (action=ac_Export) and UseClipboard then
  begin
    WriteIndexFile:=false; MakeInputIndex:=false;
  end;
  if WriteIndexFile and (not EditOnlyStrings) then equiv:=false;
  MakeInputIndex:=UseIndexFile or M^.SortingOn or sorted;
  if (action=Ac_Replace) and equiv then MakeInputIndex:=false;
  if (action=Ac_Sort) or (action=Ac_Reformat) then MakeInputIndex:=false;
  if action=Ac_Index then MakeInputIndex:=true;
  if (not TheFileExists) or (bibSize<=4) then MakeInputIndex:=false;
  if action=Ac_Strings then MakeInputIndex:=false;

  New(NameIndex,init);

  CurrentIndex:=false;
  if (MakeInputIndex or WriteIndexFile) then
  begin
    IndexFileStatus(bib,bibname,IndName^,M,SortPattern,
                    true,CurrentIndex,INentries,
                    EndOfHeader);
    {
    if CurrentIndex then message('"'+IndName+'" is current, contains '
                                 +num2str(INentries)+' entries')
    else message('"'+IndName+'" is not current');
    }
  end;
  if IndName^='' then WriteIndexFile:=false;
  if EditOnlyStrings and not CurrentIndex then WriteIndexFile:=false;
  
  MakeList:=false;
  if (action=Ac_Add) or ((action=Ac_Replace) and not equiv) or (action=Ac_Import)
     or ((action=Ac_Export) and not UseIndexFile)
     or (action=Ac_Reformat) or (action=Ac_Sort)
     or (action=Ac_Insert) {or (action=Ac_Strings)} or sorted or WriteIndexFile then
        MakeList:=true;

{$IFDEF WINDOWS}
  New(LastSrec); New(LastSrec2); New(LastESrec);
  New(TSrec); New(WriteRec);
{$ENDIF}

  if MakeInputIndex then         { Indexing }
  begin
    New(elist,init(WorkStreamOrder));
    if (elist=Nil) or (elist^.status<>stOK) then goto AllocationError;
    elist^.seek(0); elist^.truncate;
    if CurrentIndex and (not EditOnlyStrings) and
       CopyFromIndexFile and (action<>Ac_Index) then { Use index file }
    begin
      New(IndexFile,init(IndName^,stOpenRead,WorkBufSize));
      if (IndexFile<>Nil) and (IndexFile^.status=stOK) then
      begin
        IndexFile^.seek(EndOfHeader);
        Elist^.CopyFrom(IndexFile^,IndexFile^.getsize-EndOfHeader);
        nentries:=INentries;
      end;
      if IndexFile<>Nil then Dispose(IndexFile,Done); IndexFile:=Nil;
    end else
    begin                                             { Index from scratch }
      IndexBibFile(Elist,Entry,CElast,nentries,ok);
      if AbortFlag or (not ok) then
      begin
        written:=false;
        if not AbortFlag then ErrorMessageRC(Str_IndexingError,'');
        goto EndOfProcess;
      end;
    end;
    if CurrentIndex and (not EditOnlyStrings) and
       (VerifyIndexFile or (action=Ac_Index)) then
    begin                                               { Verify index file }
      if nentries<>INentries then
      begin
        CurrentIndex:=false;
        if VerifyIndexFile then Message(' File has '+num2str(nentries)
           +' entries, but index has '+num2str(Inentries)+' entries! ');
      end;
      if CurrentIndex then
      begin
        New(IndexFile,init(IndName^,stOpenRead,WorkBufSize));
        if (IndexFile<>Nil) and (IndexFile^.status=stOK) then
        begin
          WaitingMessage('Verifying...');
          IndexFile^.seek(EndOfHeader); Elist^.seek(0);
          for i:=1 to nentries do
          begin
            ReadSortRec(Elist,LastSrec^); ReadSortRec(IndexFile,WriteRec^);
            if (CompareEntries(M,LastSrec^,WriteRec^)<>0) or
                                 (LastSrec^.place<>WriteRec^.place) then
            begin
              if CurrentIndex and (VerifyIndexFile or (action<>Ac_Index)) then
                Message(' Mismatch at entry '+num2str(i)+': "'
                        +LastSrec^.name+'" at '+num2str(LastSrec^.place)
                        +' vs. "'+WriteRec^.name+'" at '+num2str(WriteRec^.place));
              CurrentIndex:=false;
            end;
          end;
          WaitingOff;
          if CurrentIndex and (action<>Ac_Index) then
            MessageRC(Str_IndexVerified,''); 
        end;
      end;
      if IndexFile<>Nil then Dispose(IndexFile,Done); IndexFile:=Nil;
    end;
  end;
  if Action=Ac_Index then   { Just index the file and leave }
  begin
    if CurrentIndex then
      CurrentIndex:=not YesNoRC(Str_IndexIsCurrent,'');
    if not CurrentIndex then
    begin
      New(IndexFile,Init(IndName^,stCreate,WorkBufSize));
      if (IndexFile=Nil) or (IndexFile^.Status<>stOK) then
      begin
        if IndexFile<>Nil then
        begin
          IndexFile^.Reset; Dispose(IndexFile,Done); IndexFile:=Nil;
        end;
        ErrorMessageRC(Str_IndexHeaderError,IndName^);
        goto AllocationError;
      end;
      IndexFileHeader(IndexFile,M^,SortPattern);
      Elist^.seek(0); IndexFile^.CopyFrom(Elist^,Elist^.getsize);
      CloseIndexFile(IndexFile,bib,bibname^,nentries);
      if IndexFile^.Status<>stOK then
      begin
        IndexFile^.Reset; Dispose(IndexFile,Done); IndexFile:=Nil;
        ErrorMessageRC(Str_IndexHeaderError,IndName^);
        BibFileChange:=false;
      end else BibFileChange:=true;
    end;
    goto EndOfProcess;
  end;

  { Add to the NameIndex collection }
  if (EList<>Nil) and (NameIndex<>Nil) then
  begin
    EList^.flush; EList^.reset; EList^.Seek(0);
    for i:=1 to nentries do
    begin
      ReadSortRec(EList,WriteRec^);
      NameIndex^.AddString(WriteRec^.Name);
    end;
    EList^.flush; EList^.reset; EList^.Seek(0);
{    message(num2str(PBigColOne(NameIndex^.ColCol.at(0))^.Count));}
    end;
                          { Find insertion point if not sorted }
  if not Sorted then
  begin
    if (Action=Ac_Add) or (Action=Ac_Import) or (Action=Ac_Export) then
    begin
      AskAddWhere(Action,insplace,moved,ok,selected);
      if not ok then
      begin
        written:=false; goto EndOfProcess;
      end;
    end else if Action=Ac_Strings then
    begin
      AskAddWhere(action,InsPlace,Moved,ok,CIns_FirstEntry);
      FirstEntPos:=InsPlace; BeforeEntries:=true; CELast:=FirstEntPos;
    end else if (Action=Ac_Insert) or (Action=Ac_Replace) then
    begin
      InsPlace:=OldFirst; InsNumber:=OldRealNum;
    end;
  end;

      { If last string is not before first entry, don't update index file }
  if EditOnlyStrings and WriteIndexFile and
     ((CELast<0) or (CELast>FirstEntPos)) then
  begin
    {
    message('Last string at '+num2str(CElast)+', first entry at '+
            num2str(FirstEntPos));
    }
    WriteIndexFile:=false;
  end;

  if sorted and M^.SortingOn and (action<>Ac_Sort) then   { Check file sortings }
  begin
    if (nentries>1) and (not SortModeAsk(elist,nentries)) then
    begin
      ErrorMessageRC(Str_ImproperSort,'');
      written:=false;
      goto EndOfProcess;
    end;        
  end;
  
  if TempEntries=Nil then
  begin
    New(TempEntries,Init(WorkStreamOrder));
    if (TempEntries=Nil) or (TempEntries^.status<>stOK) then goto AllocationError;
    TempEntries^.seek(0); TempEntries^.truncate;
  end;
  if MakeList then
  begin
    New(Telist,Init(WorkFileOnly));
    if (Telist=Nil) or (Telist^.status<>stOK) then goto AllocationError;
    TElist^.seek(0); TElist^.truncate;
  end;

  { Entering the requested entries into the temporary files }

  if (Action=Ac_Insert) or (Action=Ac_Replace) or
     (MacroCommand and (Action=Ac_Add)) then InsertEntry
  else if (action=Ac_Reformat) or (action=Ac_Sort) then ReformatFile
  else If Action=Ac_Add then ManualAdd(entry,written,changed,Elist,TElist,TempEntries,
                                  NameIndex,nadded,LastEntryName,M,SortPattern,MakeList)
  else if Action=Ac_Import then ImportEnt(Entry,Pattern,ImpFile,written,changed,
                                       UnixImp,EList,
                                       TEList,TempEntries,NameIndex,nadded,LastEntryName,
                                       FirstEntry,M,SortPattern,MakeList )
{$IFDEF WINDOWS}
  else if action=Ac_Strings then InsertAllStrings
{$ENDIF}
  else if action=Ac_Export then ExportEnt(Entry,Pattern,ImpFile,written,changed,
                                       UnixImp,EList,
                                       TEList,TempEntries,nadded,LastEntryName,
                                       OldBibName^,FirstEntry,M,SortPattern,MakeList,
                                       WasLinked,ExpMode);
{$IFNDEF WINDOWS}
  if not WriteSuccess then
  begin
    ErrorMessage('Error writing some of the entries!');
    written:=false;
  end;
{$ENDIF}
  if (TElist<>Nil) and (TElist^.status<>stOK) then goto AllocationError;
  if (TempEntries<>Nil) and (TempEntries^.status<>stOK) then goto AllocationError;
  if nadded=0 then written:=false;

                          { Sorting new additions }
  PreSorted:=false;
  if Sorted and PresortElist and (nadded>32) then
  begin
    SortElist(TElist,nadded,ok);
    if not ok then goto AllocationError;
    PreSorted:=true;
  end else if nadded=1 then PreSorted:=true;
  MaxMemAvail;
  
{ Merge the old and new entries }

  ok:=true; NumWritten:=0; AddShift:=0;
  if written or (Action=Ac_Delete) then
  begin
    if action=Ac_Delete then WaitingMessage('Deleting...')
    else if (action=Ac_Sort) or (action=Ac_Reformat) then WaitingMessage('Writing...')
    else if action=Ac_Strings then WaitingMessage('Inserting...')
    else WaitingMessage('Merging...');
    if written and sorted and (action<>Ac_Sort) and (action<>Ac_Reformat) and
                                (CELast<0) then GetLastPlace(CELast,Entry);
    AddSortEnv:=((AddSort2new=AddToAllNew) or
       (Sorted and (AddSort2new=AddToSortedNew)))
       and (action<>Ac_Delete) and (not TheFileExists);
    if (action=Ac_Export) and UseClipboard then AddSortEnv:=false;
    if FirstEntry<0 then
    begin
      ResetBib(Entry);
      GetEntry(Entry,Nil,1,true,Nil,ok);
      if ok and (Entry^.realnum=1) then FirstEntry:=Entry^.beginning
      else FirstEntry:=-1;
    end;
    if WriteIndexFile and (not EditOnlyStrings) then { Init new index file stream }
    begin
      New(IndexFile,Init(IndName^,stCreate,WorkBufSize));
      if IndexFile<>Nil then
      begin
        IndexFileHeader(IndexFile,M^,SortPattern);
        if IndexFile^.status<>stOK then
        begin
          IndexFile^.Reset; Dispose(IndexFile,Done); IndexFile:=Nil;
          ErrorMessageRC(Str_IndexHeaderError,IndName^);
        end;
      end else ErrorMessageRC(Str_IndexHeaderNil,IndName^);
      if IndexFile=Nil then WriteIndexFile:=false;
    end;

    if sorted then                    { Sorted merge }
    begin
      if M^.PattFirst then
      begin
        Pfirst:=true; Plast:=false;
      end else
      begin
        PFirst:=false; PLast:=true;
      end;
      elistpos:=0;
      with LastSrec^ do
      begin
        name:=Cfirst;
        place:=0; size:=0;
        for i:=1 to NSortKeys do keys[i]:=Cfirst;
        patt:=Pfirst;
      end;
      with LastESrec^ do
      begin
        name:=Cfirst;
        place:=-1; size:=0;
        for i:=1 to NSortKeys do keys[i]:=Cfirst;
        patt:=Pfirst;
      end;
      New(Paux,Init(WorkStreamOrder));
      if (Paux=Nil) or (Paux^.status<>stOK) then goto AllocationError;
      Paux^.seek(0); Paux^.truncate;
      MaxMemAvail;

      { Sort mode }
      if ((action=Ac_Import) or (action=Ac_Export)) and (not TheFileExists) then
      begin
        if AddSortEnv then WriteSortMode(Paux,M^,SortPattern,false,UnixBib);
        CopyHeader(Paux,UnixBib);
      end else if action=Ac_Sort then
      begin
        if AddSortEnv or ((action=Ac_Sort) and (HasSortEnv or
               YEsNoRC(Str_QAddSortEnv,'')))
                 then WriteSortMode(Paux,M^,SortPattern,false,UnixBib);
        if TheFileExists then
            CopyFileHeader(bib,Paux,FirstEntry,UnixBib,UnixBib,ok);
      end else
      begin
        if AddSortEnv and (not TheFileExists) then
          WriteSortMode(Paux,M^,SortPattern,false,UnixBib);
        FirstEntry:=0;
      end;

      { Preamble file }
      tmp:=PreambleName^;
      if (tmp<>'') and (Pos('\',tmp)=0) then tmp:=ProgramDir^+tmp;
      if not (TheFileExists or EditOnlyStrings or (action=Ac_Import)
         or (action=Ac_Export) ) and UsePreamble and
                      (tmp<>'') and (FileSize(tmp)>0) then
      begin
        LFNNew(Preamble,true);
        LFNAssign(Preamble,tmp);
        if LFNReset(Preamble,0)=0 then
        repeat
          ReadLine(Preamble,tmp,true);
          if (tmp<>'') or (Paux^.GetPos>0) then
          begin
            StreamWriteln(Paux,tmp,UnixBib);
          end;
        until eof(Preamble);
        LFNDispose(Preamble);
      end;

      if not (WriteIndexFile and EditOnlyStrings) and (SortPattern<>Nil)
         and (SPMode<>KeepInMemory) then
      begin
        Dispose(SortPattern); SortPattern:=Nil;
      end;
      CloseFile(bib);
      CurBibPos:=-1;
      if TheFileExists then
      begin
        New(BibStream,Init(bibname^,StOpenRead,WorkBufSize));
        BibStream^.seek(FirstEntry);
        CurBibPos:=FirstEntry;
        BibSize:=BibStream^.getsize;
      end;
      MaxMemAvail;
      if TElist<>Nil then
      begin
        TElist^.Reset; TElist^.seek(0);
      end;
      if Elist<>Nil then
      begin
        Elist^.Reset;  elist^.seek(0);
      end;
                                    { Start work }
      for i:=1 to nadded do
      begin
        if PreSorted then ReadSortRec(TElist,LastSrec^)
        else begin         { The loop for inserting the i-th added entry, }
          Telist^.seek(0); { if not pre-sorted }
          with LastSrec2^ do
          begin
            Name:=Clast; place:=-2;
            for ii:=1 to NSortKeys do Keys[ii]:=Clast;
            Patt:=PLast;
          end;
          for ii:=1 to nadded do     { Sort loop }
          begin
            ReadSortRec(TElist,TSrec^);  {message(TSrec^.name); }
            if (CompareEntries(M,TSrec^,LastSrec^) =1) and
               (CompareEntries(M,TSrec^,LastSrec2^)=-1) then LastSrec2^:=TSrec^;
          end;
          LastSrec^:=LastSrec2^;
        end;                           { Found the i=th new entry }

        { message('1 - '+LastSRec^.name);}

        if Elist<>Nil then    { Find where to put it }
        begin
          iii:=CompareEntries(M,LastSrec^,LastESrec^);
          while ((iii=0) or (iii=1)) and (elistpos<=nentries) do
          begin
            if WriteIndexFile and (not EditOnlyStrings) then { Update index file }
            begin
              if LastESrec^.place>=0 then { not the initial one }
              begin
                if (IgStart<0) or (LastESrec^.place<IgStart) or
                                  (LastESrec^.place>IgEnd) then
                begin
                  WriteRec^:=LastESrec^; WriteRec^.Place:=LastESrec^.Place+AddShift;
                  inc(NumWritten); WriteRec^.Ereal:=NumWritten;
                  WriteSortRec(IndexFile,WriteRec^);
                end else if IgStart>=0 then AddShift:=AddShift-(IgEnd-IgStart+1);
              end;
            end;
            Inc(elistpos);
            if elistpos<=nentries then     { Read next record }
            begin
              ReadSortRec(elist,LastESrec^);
              iii:=CompareEntries(M,LastSrec^,LastESrec^);
            end else                       { Beyond last record }
            begin
              LastESrec^.Place:=CELast+1; LastESrec^.Ereal:=0;
              LastESrec^.name:='<End of File>';
            end;
          end;
          if  LastESrec^.name='' then
          begin
            LastESrec^.Place:=CELast+1; LastESrec^.Ereal:=0;
            LastESrec^.name:='<End of File>';
          end;
        
      { Found the required insertion point, before entry number LastESrec.Ereal }
{
          message('"'+LastSrec^.Name+'" - just before "'+LastESrec^.name+
                   '", at position '+num2str(LastESrec^.place));
}
           WriteFromTo(BibStream,Paux,CurBibPos,BibSize,
                       LastESrec^.Place,IgStart,IgEnd,UnixBib);
        end;
        Entry^.name:='NOTHING';
        TempEntries^.seek(LastSrec^.place);
        GetEntryTemp(TempEntries,Entry,TTag);
        if WriteIndexFile and (not EditOnlyStrings) then
                                  LastSrec^.Place:=Paux^.getpos;
        WriteBibEntry(Paux,Entry,@fields,UnixBib);
        if WriteIndexFile and (not EditOnlyStrings) then   { New index entry }
        begin
          inc(NumWritten);
          LastSrec^.Ereal:=NumWritten;
          LastSRec^.Size:=Paux^.getpos-LastSRec^.Place;
          AddShift:=AddShift+LastSRec^.Size;
          WriteSortRec(IndexFile,LastSrec^);
        end;
        if action=Ac_Sort then
        begin
          if TTag then Tag(i,TagSet,Tags)
          else Tag(i,TagClear,Tags);
        end else if (action<>Ac_Reformat) and (LastESrec^.Ereal>0) then
        begin
          InsertNewTag(LastESrec^.Ereal+i-1,Tags);
          if TagNewEntries and (action in [Ac_Add,Ac_Import]) then { Tag new }
            Tag(LastESRec^.EReal+i-1,TagSet,Tags);
          if LastESrec^.Ereal<=IgNumber then inc(IgNumber);
        end;
        TrapAbort;
        if AbortFlag then
        begin
          written:=false; nadded:=0;
          goto EndOfProcess;
        end;
      end;
      if BeforeEntries then StreamWriteln(Paux,'',UnixBib);
      if (Elist<>Nil) and (nentries>0) and WriteIndexFile and (not EditOnlyStrings)
                    then  { rest of file }
      while ElistPos<=nentries do
      begin
        if (IgStart<0) or (LastESrec^.place<IgStart) or
                          (LastESrec^.place>IgEnd) then
        begin
          LastESRec^.Place:=LastESrec^.Place+AddShift;
          inc(NumWritten); LastESRec^.Ereal:=NumWritten;
          WriteSortRec(IndexFile,LastESRec^);
        end else if IgStart>=0 then AddShift:=AddShift-(IgEnd-IgStart+1);
        Inc(elistpos);
        if ElistPos<=nentries then ReadSortRec(elist,LastESrec^);
      end;
      WriteFromTo(BibStream,Paux,CurBibPos,BibSize,Cend,IgStart,IgEnd,UnixBib);

      if action=Ac_Sort then     { Update relevant Sort mode }
      begin
        M^.SortingOn:=true;
        if WSortMode=1 then ConfigSortMode^.SortingOn:=true
        else if WSortMode=2 then CurrentSortMode^.SortingOn:=true
        else if WSortMode=3 then ExportSortMode^.SortingOn:=true;
      end else DeleteOldTag(IgNumber,Tags);
    end else
    begin                                          { Unsorted }
      New(Paux,Init(WorkStreamOrder));
      if (Paux=Nil) or (Paux^.status<>stOK) then goto AllocationError;
      Paux^.seek(0); Paux^.truncate;

      { Header }
      if (not HasSortEnv) or SavedSortOK then ok:=false
      else begin
        ok:=(Action=Ac_Strings);
        if EditOnlyStrings then
          ok:=ok or (M^.StringNameSort=StrSortOff)
        else
          ok:=ok or not M^.SortingOn;
      end;
      if ok then
      begin
        if (FirstEntry=-1) and (nentries=0) then FirstEntry:=InsPlace;
{        message(num2str(FirstEntry));}
        WriteSortMode(Paux,M^,SortPattern,false,UnixBib);
        CopyFileHeader(bib,Paux,FirstEntry,UnixBib,UnixBib,ok);
        AddShift:=Paux^.getpos-FirstEntry;
      end else if ((action=Ac_Import) or (action=Ac_Export))
                                      and (not TheFileExists) then
      begin
        if AddSortEnv then WriteSortMode(Paux,M^,SortPattern,false,UnixBib);
        if (action<>Ac_Export) or not UseClipboard then
          CopyHeader(Paux,UnixBib);
        FirstEntry:=0;
      end else if AddSortEnv then
      begin
        WriteSortMode(Paux,M^,SortPattern,false,UnixBib);
        FirstEntry:=0;
      end else FirstEntry:=0;

      { Preamble file }
      tmp:=PreambleName^;
      if (tmp<>'') and (Pos('\',tmp)=0) then tmp:=ProgramDir^+tmp;
      if not (TheFileExists or EditOnlyStrings or (action=Ac_Import)
         or (action=Ac_Export) ) and UsePreamble and
                      (tmp<>'') and (FileSize(tmp)>0) then
      begin
        LFNNew(Preamble,true); LFNAssign(Preamble,tmp);
        if LFNReset(Preamble,0)=0 then
        repeat
          ReadLine(Preamble,tmp,true);
          if (tmp<>'') or (Paux^.GetPos>0) then
            StreamWriteln(Paux,tmp,UnixBib);
        until eof(Preamble);
        LFNDispose(Preamble);
      end;

      if (SortPattern<>Nil) and (SPMode<>KeepInMemory) then
      begin
        Dispose(SortPattern); SortPattern:=Nil;
      end;
      CloseFile(bib);
      BibStream:=Nil; CurBibPos:=-1;
      if TheFileExists then
      begin
        New(BibStream,Init(bibname^,stOpenRead,WorkBufSize));
        if BibStream^.status<>stOK then
          ErrorMessageRC(Str_StreamError,num2str(BibStream^.Status));
        BibStream^.seek(FirstEntry);
        if BibStream^.status<>stOK then
          ErrorMessageRC(Str_StreamError,num2str(BibStream^.Status));
        CurBibPos:=FirstEntry; BibSize:=BibStream^.getsize;
      end;
      MaxMemAvail;

      if WriteIndexFile and (TElist<>Nil) and (not EditOnlyStrings) then
          TElist^.seek(0);
      if TempEntries<>Nil then TempEntries^.seek(0);
      if WriteIndexFile and (not EditOnlyStrings) and (Elist<>Nil) then
      begin
        Elist^.seek(0);
        i:=1;
        while (i<=nentries) and ((InsNumber<=0) or (i<InsNumber)) do
        begin
          ReadSortRec(elist,WriteRec^);
          if i=IgNumber then AddShift:=AddShift-(IgEnd-IgStart+1)
          else begin
            inc(NumWritten);
            WriteRec^.Ereal:=NumWritten;
            WriteRec^.Place:=WriteRec^.Place+AddShift;
            WriteSortRec(IndexFile,WriteRec^);
          end;
          inc(i);
        end;
      end;
                                                   { Write head }
      WriteFromTo(BibStream,paux,CurBibPos,BibSize,
                  InsPlace,IgStart,IgEnd,UnixBib);
      AuxPlace:=Paux^.getpos;
                                 { Insert the additional entries }
      NewIgNumber:=IgNumber;
      for i:=1 to nadded do
      begin
        if WriteIndexFile and (not EditOnlyStrings) then  { To new index file }
        begin
          ReadSortRec(Telist,WriteRec^);
          inc(NumWritten);
          WriteRec^.Ereal:=NumWritten;
          WriteRec^.Place:=Paux^.getpos;
        end;
        GetEntryTemp(TempEntries,Entry,TTag);
        WriteBibEntry(Paux,Entry,@fields,UnixBib);
        if WriteIndexFile and (not EditOnlyStrings) then  { To new index file }
        begin
          WriteRec^.Size:=Paux^.getpos-WriteRec^.place;
          WriteSortRec(IndexFile,WriteRec^);
          AddShift:=AddShift+WriteRec^.Size;
        end;
        if InsNumber<IgNumber then Inc(NewIgNumber);
        if action<>Ac_Reformat then
        begin
          InsertNewTag(InsNumber,Tags);
          if TagNewEntries and (action in [Ac_Add,Ac_Import]) then { Tag new }
            Tag(InsNumber,TagSet,Tags);
        end;
        TrapAbort;
        if AbortFlag then
        begin
          written:=false; nadded:=0;
          goto EndOfProcess;
        end;
      end;
      if action<>Ac_Reformat then DeleteOldTag(NewIgNumber,Tags);
      
                                 { Copy the rest of the old bib }
                                 
      if BeforeEntries then StreamWriteln(Paux,'',UnixBib);
      WriteFromTo(BibStream,paux,CurBibPos,BibSize,
                  CEnd,IgStart,IgEnd,UnixBib);
      if WriteIndexFile and (not EditOnlyStrings) and (Elist<>Nil)
         and (InsNumber>0) then
      for i:=InsNumber to nentries do
      begin
        ReadSortRec(elist,WriteRec^);
        if i=IgNumber then AddShift:=AddShift-(IgEnd-IgStart+1)
        else begin
          inc(NumWritten);
          WriteRec^.Ereal:=NumWritten;
          WriteRec^.Place:=WriteRec^.Place+AddShift;
          WriteSortRec(IndexFile,WriteRec^);
        end;
      end;
    end;
    if LastEntryName='' then LastEntryName:=Entry^.name;

                                   { Copy the auxfile onto the bib file }
    WaitingMessage('Writing...');
    if BibStream<>Nil then Dispose(BibStream,Done); BibStream:=Nil;
    Paux^.Flush; Paux^.truncate;
    ok:=AuxToBib(Paux,bib,bibname^);
    LFNClose(bib);
    BibFileChange:=ok;
    if ok and (action<>ac_Export) then EntryCache^.Clear;
    if WriteIndexFile then     { Finish off index file }
    begin
      if not ok then
      begin
        Dispose(IndexFile,Done); IndexFile:=Nil;
        LFNNew(DelFile,true); LFNAssign(DelFile,IndName^);
        LFNErase(DelFile); LFNDispose(DelFile);
      end else if EditOnlyStrings then
      begin
        EditOnlyStrings:=false;
        Resetbib(Entry);
        GetEntry(Entry,Nil,1,false,Nil,ok);
        CloseFile(bib);
        EditOnlyStrings:=true;
        if not ok then goto EndOfProcess;
        AddShift:=Entry^.beginning-FirstEntPos;
{        
        message('Shifted by '+num2str(AddShift)+' chars, from '+num2str(FirstEntPos)
                +' to '+num2str(Entry^.beginning));
}
{$IFDEF WINDOWS}
        Dispose(Paux,Done); New(Paux,Init(WorkStreamOrder));
{$ELSE}
        Paux^.seek(0); Paux^.truncate;
{$ENDIF}
        if PAux^.getsize>10000000 then goto EndOfProcess;

        if (SortPattern=Nil) and M^.SortPatternExists then
        begin
          if SPMode=KeepInMemory then
          begin
            SortPattern:=PatRecPtr(KeepStack^[SPPos].P);
          end else if SPMode<>DontKeep then
          begin
            New(SortPattern);
            RecallBufferStack(SortPattern^,SPPos);
          end;
          SortPattern^.on:=true;
        end;
        IndexFileHeader(Paux,M^,SortPattern);
        New(IndexFile,Init(IndName^,stOpen,WorkBufSize));
        if (IndexFile=Nil) or (IndexFile^.status<>stOK) then goto EndOfProcess;
        IndexFile^.seek(EndOfHeader);
        EditOnlyStrings:=false;
        for ii:=1 to Inentries do
        begin
          ReadSortRec(IndexFile,WriteRec^);
          WriteRec^.place:=WriteRec^.place+AddShift;
          WriteSortRec(Paux,WriteRec^);
        end;
        EditOnlyStrings:=true;
        if (IndexFile=Nil) or (IndexFile^.status<>stOK) then goto EndOfProcess;
        CloseIndexFile(Paux,bib,bibname^,Inentries);
        Paux^.seek(0); IndexFile^.seek(0);
        IndexFile^.copyfrom(Paux^,Paux^.getsize);
        IndexFile^.truncate;
      end else
      begin
        if NumWritten>0 then CloseIndexFile(IndexFile,bib,bibname^,NumWritten)
        else begin
          Dispose(IndexFile,Done); IndexFile:=Nil;
          LFNNew(DelFile,true); LFNAssign(DelFile,IndName^);
          LFNErase(DelFile); LFNDispose(DelFile);
        end;
      end;
    end;
  end;

EndOfProcess:

  TidyUp;

  if (action<>Ac_Export) and (written or AbortFlag or (action=Ac_Delete)
             or (action=Ac_Index)) then
  begin
    CheckForIndexFile(bib,bibname);
    EntryCache^.LoadCache(Pattern);
  end;

  SearchingMessage;
  if action=Ac_Strings then { nothing, dealt with externally }
  else if written or (action=Ac_Delete) then   { Go to proper place in the bib file }
  begin
    EntryCache^.LookForCacheFile(bibname^,Nil,true,false,Nil,Nil,Nil);
    if not (action in [Ac_Reformat,Ac_Sort,Ac_Export]) then
      LastRealNum:=0;
    if action=Ac_Reformat then
    begin
      ResetBib(Entry);
      ReachNumber(Entry,Pattern,OldRealNum,OldEntryNum);
    end else if action=Ac_Sort then
    begin
      ResetBib(Entry);
      if OldRealNum>0 then
        ReachLabel(Entry,Pattern,OldName,false,false,true,ok);
    end else if action=Ac_Delete then
    begin
      ResetBib(Entry);
      if (Not ActivePattern(Pattern)) and (MakeUseOfIndex(Pattern)) then
      begin
        if OldEntryNum<=NumberOfEntries then
          ReachNumber(Entry,Pattern,OldEntryNum,OldEntryNum)
        else
          ReachNumber(Entry,Pattern,OldEntryNum-1,OldEntryNum-1);
      end else
      begin
        GetEntry(Entry,Nil,OldEntryNum,true,Pattern,ok);
        if (not ok) or (Entry^.entrynum<>OldEntryNum) then
        begin
          ResetBib(Entry);
          if OldEntryNum>1 then
            GetEntry(Entry,Nil,OldEntryNum-1,true,Pattern,ok);
        end;
      end;
    end else if action<>Ac_Export then
    begin
      if ActivePattern(Pattern) then
      begin
        PatternCheck(Entry,Pattern,ok,true);
        if not ok then Pattern^.on:=false;
      end;
      BibFileExists:=LFNFileExist(bibname^);
      ResetBib(Entry);
      ReachLabel(Entry,Pattern,LastEntryName,false,false,true,ok);
    end;
  end else if action<>Ac_Export then
  begin
    BibFileExists:=LFNFileExist(bibname^);
    ResetBib(Entry);
    if OldFirst<1000 then
      ReachNumber(Entry,Pattern,OldRealNum,OldEntryNum)
    else ReachEntry(Entry,OldRealNum,OldEntryNum,OldFirst,false);
  end;
  WaitingOff;
  Exit;

AllocationError:

  if not AbortFlag then ErrorMessageRC(Str_CantCreateTemp,'');
  TidyUp;
  if (action<>Ac_Export) and (action<>Ac_Strings) then
  begin
    if OldFirst<1000 then
      ReachNumber(Entry,Pattern,OldRealNum,OldEntryNum)
    else ReachEntry(Entry,OldRealNum,OldEntryNum,OldFirst,false);
  end;

end;                                            { BibFileChange }

function DeleteEntries(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        DelAll,Warn: boolean): boolean;
Label
  AbnormalTermination,
  EndOfProcess;
type
  DelPosRec = record
    start,finish: longint;
    Rnum: word;
  end;
var
  Oplace: longint;
  DelPos: DelPosRec;
  CurBibPos,BibSize,EndOfHeader,AddShift,FirstEntPos,Last: longint;
  i,Orealnum,Oentrynum,Oreal2,Oentry2,entmax: word;
  Ndel,NumWritten,NToDelete,nentries,Inentries: Word;
  ercode: byte;
  Paux,DelFile: PAuxStream;
  BibStream,IndexFile: PSafeBufStream;
  IndName: string;
  ok,CurrentIndex,WriteIndexFile,ReadFromIndex: boolean;
  SortPattern: PatRecPtr;
  Srec: SortRecType;
  DF: file;
  ch: char;
  CrString: string[4];

procedure TidyUp;
begin
  if BibStream<>Nil then Dispose(BibStream,Done); BibStream:=Nil;
  if IndexFile<>Nil then Dispose(IndexFile,Done); IndexFile:=Nil;
  if Paux<>Nil      then Dispose(Paux,Done);      Paux:=Nil;
  if DelFile<>Nil   then Dispose(DelFile,Done);   DelFile:=Nil;
  if (SortPattern<>Nil) and (SortPattModeCur<>KeepInMemory) then
     Dispose(SortPattern);
  SortPattern:=Nil;
end;

begin                           { DeleteEntries }
  DeleteEntries:=false;
  if Linked then
  begin
    ErrorMessageRC(Str_CantDeleteLinked,''); Exit;
  end;
  DelFile:=Nil; Paux:=Nil; BibStream:=Nil; IndexFile:=Nil; SortPattern:=Nil;
  ok:=false;
  if ((Pattern=Nil) or (not Pattern^.on)) and DelAll then
    ok:=(not Warn) or
      (EditOnlyStrings and YesNoRC(Str_QDeleteAllStrings,'')) or
      (not EditOnlyStrings and YesNoRC(Str_QDeleteAll,''))
  else if DelAll then
    ok:=(EditOnlyStrings and YesNoRC(Str_QDeleteAllPattStr,'')) or
      (not EditOnlyStrings and YesNoRC(Str_QDeleteAllPatt,''))
  else
    ok:=(EditOnlyStrings and YesNoRC(Str_QDeleteAllTaggedStr,'')) or
      (not EditOnlyStrings and YesNoRC(Str_QDeleteAllTagged,''));
  if not ok then Exit;
  DeSuspend;
  TimeOutOn:=false;
  Oplace:=Entry^.beginning;
  Oentrynum:=Entry^.entrynum; Orealnum:=Entry^.realnum;
  Oreal2:=Orealnum; Oentry2:=Oentrynum;
  IndName:=''; FirstEntPos:=-1; Inentries:=0; nentries:=0;
  WriteIndexFile:=UseIndexFile; CurrentIndex:=false;

  if WriteIndexFile then
  begin
    if CurrentSortMode^.SortingOn and CurrentSortMode^.SortPatternExists then
    begin
      if SortPattModeCur=KeepInMemory then
      begin
        SortPattern:=PatRecPtr(KeepStack^[SortPattPosCur].P);
      end else if SortPattModeCur<>DontKeep then
      begin
        New(SortPattern);
        RecallBufferStack(SortPattern^,SortPattPosCur);
      end;
      SortPattern^.on:=true;
    end;
    MaxMemAvail;
    IndexFileStatus(bib,bibname,IndName,CurrentSortMode,SortPattern,true,CurrentIndex,
                    Inentries,EndOfHeader);
    {
    if CurrentIndex then message(' '+IndName+' is current ')
    else message(' '+IndName+' is not current ');
    }
    if not EditOnlyStrings then nentries:=Inentries;
    if (IndName='') or (not CurrentIndex) then WriteIndexFile:=false;
    if (SortPattern<>Nil) and (SortPattModeCur<>KeepInMemory) then
       Dispose(SortPattern);
    SortPattern:=Nil;
  end;
  if EditOnlyStrings and WriteIndexFile then
  begin
    EditOnlyStrings:=false;
    ResetBib(Entry);
    GetEntry(Entry,Nil,1,false,Nil,ok);
    EditOnlyStrings:=true;
    if ok then FirstEntPos:=Entry^.beginning;
  end;

  { Create list of items to delete }
  New(DelFile,Init(WorkStreamOrder));
  if (DelFile=Nil) or (DelFile^.status<>stOK) then
  begin
    ErrorMessageRC(Str_CantCreateTemp,'');
    goto AbnormalTermination;
  end;
  WaitingMessage('Indexing...');
  DelFile^.seek(0); DelFile^.truncate;
  entmax:=0;
  NToDelete:=0; Last:=-1;
  ok:=true;
  ReadFromIndex:=(not EditOnlyStrings) and CurrentIndex and
                 ((Pattern=Nil) or (not Pattern^.on));
  if ReadFromIndex then
  begin
    New(IndexFile,Init(IndName,stOpenRead,WorkBufSize));
    if (IndexFile=Nil) or (IndexFile^.status<>stOK) then ReadFromIndex:=false
    else begin
      IndexFile^.seek(EndOfHeader);
      for i:=1 to nentries do
      begin
        ReadSortRec(IndexFile,Srec);
        if DelAll or ((not DelAll) and IsTagged(i,Tags)) then
        begin
          DelPos.Start:=Srec.place;
          DelPos.Finish:=Srec.place+Srec.size-1;
          DelPos.Rnum:=i;
          DelFile^.write(DelPos,sizeof(DelPosRec));
          inc(NToDelete);
        end;
      end;
    end;
    if IndexFile<>Nil then
    begin
      if IndexFile^.status<>stOK then ReadFromIndex:=false;
      Dispose(IndexFile,Done); IndexFile:=Nil;
    end;
  end;
  if not ReadFromIndex then
  begin
    DelFile^.seek(0);
    ResetBib(Entry);
    GetEntry(Entry,Nil,1,true,Pattern,ok);
    while ok and (Entry^.entrynum>entmax) and not AbortFlag do
    begin
      TrapAbort; if AbortFlag then goto AbnormalTermination;
      entmax:=Entry^.entrynum;
      Last:=Entry^.ending;
      if DelAll or ((not DelAll) and IsTagged(Entry^.realnum,Tags)) then
      begin
        DelPos.Start:=Entry^.beginning;
        DelPos.Finish:=Entry^.ending;
        DelPos.Rnum:=Entry^.realnum;
        DelFile^.write(DelPos,sizeof(DelPosRec));
        inc(NToDelete);
      end;
      GetEntry(Entry,Nil,Entry^.entrynum+1,true,Pattern,ok);
    end;
    if AbortFlag then goto AbnormalTermination;
  end;
  if DelFile^.status<>stOK then
  begin
    ErrorMessageRC(Str_CantCreateTemp,'');
    goto AbnormalTermination;
  end;
  if NToDelete=0 then
  begin
    messageRC(Str_NothingToDelete,'');
    goto AbnormalTermination;
  end;
  if (not ReadFromIndex) and EditOnlyStrings then
  begin
    TextSeek(bib,DelPos.Finish-1); CrString:='';
    i:=0;
    {$I-}
    repeat
      read(bib,ch);
      if IoResult=0 then CrString:=CrString+ch
      else i:=10;
      inc(i);
    until i>=4;
    {$I+}
    if CrString=#13#10#13#10 then
    begin
      DelPos.Finish:=DelPos.Finish+2; Last:=Last+2;
      DelFile^.seek((NToDelete-1)*sizeof(DelPosRec));
      DelFile^.write(DelPos,sizeof(DelPosRec));
      DelFile^.truncate;
    end;
  end;
  if EditOnlyStrings and WriteIndexFile and
     ((Last<0) or (FirstEntPos<0) or (Last>FirstEntPos)) then
        WriteIndexFile:=false;
  DelFile^.Flush;

  New(Paux,Init(WorkStreamOrder));
  if (Paux=Nil) or (Paux^.status<>stOK) then
  begin
    WaitingOff;
    ErrorMessageRC(Str_CantCreateTemp,'');
    goto AbnormalTermination;
  end;
  Paux^.seek(0); Paux^.Truncate;

  CloseFile(bib);
  WaitingMessage('Deleting...');
  New(BibStream,Init(bibname^,stOpenRead,WorkBufSize));
  if (BibStream=Nil) or (BibStream^.status<>stOK) then
  begin
    WaitingOff;
    ErrorMessageRC(Str_CantOpenBib,'');
    goto AbnormalTermination;
  end;
  BibStream^.seek(0);
  CurBibPos:=0; BibSize:=BibStream^.getsize;
  DelFile^.seek(0);
  Paux^.seek(0);
  for i:=1 to NToDelete do
  begin
    TrapAbort; if AbortFlag then goto AbnormalTermination;
    DelFile^.read(DelPos,sizeof(DelPosRec));
    with DelPos do
    begin
      WriteFromTo(BibStream,Paux,CurBibPos,BibSize,
                  Finish+1,Start,Finish,UnixBib);
      if RNum=Oreal2 then
      begin
        Oreal2:=0; OEntry2:=0;
      end else if RNum<Oreal2 then
      begin
        Dec(Oreal2); Dec(OEntry2);
      end;
      DeleteOldTag(RNum-(i-1),Tags);
    end;
  end;
  WriteFromTo(BibStream,Paux,CurBibPos,BibSize,CEnd,CEnd,CEnd,UnixBib);
  Paux^.truncate; Paux^.seek(0); Paux^.Flush;

  if BibStream<>Nil then Dispose(BibStream,Done); BibStream:=Nil;
  WaitingMessage('Writing...');
  ok:=AuxToBib(Paux,bib,bibname^);
  if ok then
  begin
    DeleteEntries:=true;
    EntryCache^.Clear;
    LastRealNum:=0;
  end;
  if not (WriteIndexFile and ok) then goto EndOfProcess;

                                              { Update index file }
  CloseFile(bib);
  WaitingMessage('Updating index...');
  if CurrentSortMode^.SortingOn and CurrentSortMode^.SortPatternExists then
  begin
    if SortPattModeCur=KeepInMemory then
    begin
      SortPattern:=PatRecPtr(KeepStack^[SortPattPosCur].P);
    end else if SortPattModeCur<>DontKeep then
    begin
      New(SortPattern);
      RecallBufferStack(SortPattern^,SortPattPosCur);
    end;
    SortPattern^.on:=true;
  end;
  MaxMemAvail;
{$IFDEF WINDOWS}
  Dispose(Paux,Done); New(Paux,Init(WorkStreamOrder));
{$ELSE}
  PAux^.reset; Paux^.seek(0); Paux^.truncate;
{$ENDIF}
  IndexFileHeader(Paux,CurrentSortMode^,SortPattern);
  if (SortPattern<>Nil) and (SortPattModeCur<>KeepInMemory) then
    Dispose(SortPattern);
  SortPattern:=Nil;

  New(IndexFile,Init(IndName,stOpen,WorkBufSize));
  if (IndexFile=Nil) or (IndexFile^.status<>stOK) then
  begin
    ErrorMessageRC(Str_CantOpenIndex,'');
    goto EndOfProcess;
  end;
  IndexFile^.seek(EndOfHeader);
  ndel:=1; NumWritten:=0; AddShift:=0;
  DelFile^.seek(0); DelFile^.read(DelPos,sizeof(DelPosRec));

  if EditOnlyStrings then
  begin
    EditOnlyStrings:=false;
    ResetBib(entry);
    GetEntry(Entry,Nil,1,false,Nil,ok);
    EditOnlyStrings:=true;
    if not ok then goto EndOfProcess;
    AddShift:=Entry^.beginning-FirstEntPos;
    EditOnlyStrings:=false;
    for i:=1 to Inentries do
    begin
      ReadSortRec(IndexFile,Srec);
      Srec.place:=Srec.place+AddShift;
      WriteSortRec(Paux,Srec);
    end;
    EditOnlyStrings:=true;
  end else
  begin
    for i:=1 to nentries do
    begin
      ReadSortRec(IndexFile,Srec);
      if Srec.Ereal=DelPos.RNum then           { Deleting }
      begin
        AddShift:=AddShift-Srec.size;
        if ndel<NToDelete then
        begin
          inc(ndel);
          DelFile^.read(DelPos,sizeof(DelPosRec));
        end else DelPos.RNum:=0;
      end else                                 { Writing }
      begin
        inc(NumWritten);
        Srec.place:=Srec.place+AddShift;
        Srec.ereal:=NumWritten;
        WriteSortRec(Paux,Srec);
      end;
    end;
  end;
  if (Paux^.status<>stOK) or (IndexFile^.status<>stOK) then
  begin
    ErrorMessageRC(Str_RWIndexError,'');
    goto EndOfProcess;
  end;
  Paux^.seek(0); IndexFile^.seek(0);
  IndexFile^.CopyFrom(Paux^,Paux^.getsize);
  IndexFile^.truncate;
  if EditOnlyStrings then CloseIndexFile(IndexFile,bib,bibname^,Inentries)
  else if NumWritten>0 then CloseIndexFile(IndexFile,bib,bibname^,NumWritten)
  else begin
    Dispose(IndexFile,Done); IndexFile:=Nil;
    LFNNew(df,true); LFNAssign(df,IndName);
    LFNErase(df); LFNDispose(df);
  end;

EndOfProcess:

  TidyUp;
  EntryCache^.LookForCacheFile(bibname^,Nil,true,false,Nil,Nil,Nil);
  EntryCache^.LoadCache(Pattern);
  CheckForIndexFile(bib,bibname);
  ResetBib(Entry);
  GetEntry(Entry,Nil,1,true,Pattern,ok);
  if (not ok) or (Entry^.realnum=0) then ResetBib(Entry);
  WaitingOff;
  Exit;

AbnormalTermination:
           
  TidyUp;
  EntryCache^.LookForCacheFile(bibname^,Nil,true,false,Nil,Nil,Nil);
  EntryCache^.LoadCache(Pattern);
  ResetBib(Entry);
  ReachNumber(Entry,Pattern,oreal2,oentry2);
  WaitingOff;
  Exit;
  
end;

end.
