{$N-,E-,V-}

Unit bibclip;

Interface

uses
  objects, bibstrg, bibstrm, bibvars, bibdisp, bibutil;

function  GetWinOldApVersion: word;
function  OpenClipboard: boolean;                          
function  EmptyClipboard: boolean;
procedure ClipboardSize(var bytes,pages: word);
procedure SetClipData(var S; Slen: word; var ok: boolean);
procedure GetClipData(var S; var Slen: word; var ok: boolean);
function  CloseClipboard: boolean;
procedure CopyToBuffer(var Ss; mlen,mlen1: word);
procedure PasteFromBuffer(var Ss; var Slen: word; var pl: longint;
                          mlen,mlen1,MaxBig: word);
                          
procedure EntryToClipboard(Entry: EntryRecPtr);
procedure ClipboardToEntry(Entry: EntryRecPtr);

Implementation

function GetWinOldApVersion: word;
{ Returns 0 if not installed }                           
assembler;                                               
asm                                                      
  mov ax, $1700                                          
  int $2f                                                
  cmp ax,$1700                                           
  jne @1                                                 
  mov ax,0                                               
@1:                                                      
end;                                                     
 
function OpenClipboard: boolean;                          
{ Open the clipboard. Result signals success if true }   
assembler;                                               
asm                                                      
  mov ax, $1701                                          
  int $2f                                                
  cmp ax,0                                               
  je @1                                                  
  mov al,true                                            
@1:                                                      
end;                                 { OpenClipBoard }
                                                         
function EmptyClipboard: boolean;
{ Empty the clipboard. Result signals success if true }   
assembler;                                               
asm                                                      
  mov ax, $1702
  int $2f                                                
  cmp ax,0                                               
  je @1                                                  
  mov al,true                                            
@1:                                                      
end;                                 { EmptyClipBoard }

procedure ClipboardSize(var bytes,pages: word);
{ Empty the clipboard. Result signals success if true }
assembler;
asm
  push es
  push di
  mov ax, $1704
  mov dx, 1
  int $2f
  les di, bytes
  mov es:[di], ax
  les di, pages
  mov es:[di], dx
  pop di
  pop es
end;                                { ClipboardSize }

procedure SetClipData(var S; Slen: word; var ok: boolean);
{ Put data into the Windows clipboard }
var
  sseg,sofs: word;
begin
  Sseg:=Seg(S); Sofs:=Ofs(S);
  asm
    mov ax, $1703
    mov dx, 1
    mov SI, 0
    mov cx, slen
    mov bx, sofs
    mov es, sseg
    int $2f
    cmp ax, 0
    je @1
    mov al, 1
  @1:
    les di, ok
    mov es:[di], al
  end;
end;                                { SetClipData }

procedure GetClipData(var S; var Slen: word; var ok: boolean);
{ Get data from the Windows clipboard }
var
  Pages,Bytes,Sseg,Sofs: word;
begin
  slen:=0; ok:=false;
  ClipboardSize(Bytes,Pages);
  if (pages=0) and (bytes>0) then
  begin
    Slen:=Bytes; ok:=false;
    Sseg:=Seg(S); SOfs:=Ofs(S);
    asm
      mov ax, $1705
      mov dx, 1
      mov bx, Sofs
      mov es, Sseg
      int $2f
      cmp ax,0
      je @1
      mov al, 1
      les di,ok
      mov es:[di], al
@1:
    end;
  end;
end;                                { GetClipData }

function CloseClipboard: boolean;
{ Close the clipboard. Result signals success if true }   
assembler;                                               
asm                                                      
  mov ax, $1708                                          
  int $2f                                                
  cmp ax,0                                               
  je @1                                                  
  mov al,true                                            
@1:                                                      
end;                                { CloseClipboard }

procedure CopyToBuffer(var Ss; mlen,mlen1: word);
var
  i: word;
  ok: boolean;
  l: string;
  S: BigType ABSOLUTE Ss;
begin
  if mlen=mlen1 then exit;
  if mlen>mlen1 then
  begin
    i:=mlen; mlen:=mlen1+1; mlen1:=i+1;
  end;
  if UseWindowsClipboard then
  begin                                  { Use Windows clipboard }
    if not OpenClipboard then
    begin
      ErrorMessage(' Clipboard in use by another program! '); exit;
    end;
    SetClipData(S[mlen],mlen1-mlen,ok);
    if CloseClipboard then;
  end else
  begin                                  { Use temporary file }
    if CutPasteBuffer=Nil then             { Create it }
    begin
      New(CutPasteBuffer,Init(WorkFileOnly));
      if (CutPasteBuffer=Nil) or (CutPasteBuffer^.status<>stOK) then
      begin
        ErrorMessage(' Error creating paste buffer stream! ');
        if CutPasteBuffer<>Nil then
        begin
          Dispose(CutPasteBuffer,Done); CutPasteBuffer:=Nil;
          exit;
        end;        
      end;
    end;
    CutPasteBuffer^.seek(0); CutPasteBuffer^.truncate;
    CutPasteBuffer^.write(S[mlen],mlen1-mlen);
  end;
end;                                { CopyToBuffer }

procedure PasteFromBuffer(var Ss; var Slen: word; var pl: longint;
                          mlen,mlen1,MaxBig: word);
var
  BufLen: longint;
  i,j,PasteLen,Pages,Bytes,ClipLen: word;
  ok: boolean;
  P,S: BigTypePtr;
begin
  S:=@Ss;
  if UseWindowsClipboard then
  begin                                  { Use Windows clipboard }
    if not OpenClipboard then
    begin
      ErrorMessage(' Clipboard in use by another program! '); exit;
    end;
    ClipboardSize(Bytes,Pages);
    if (pages>0) or (bytes>K64-16) or (bytes=0) then
    begin
      if (pages=0) and (bytes=0) then
        ErrorMessage(' Clipboard is empty! ')
      else
        ErrorMessage(' Clipboard contains more than 64K data! ');
      if CloseClipboard then;
      exit;
    end;
    getmem(P,bytes);
    MaxMemAvail;
    GetClipData(P^,ClipLen,ok);
    if CloseClipboard then;
    if not ok then
    begin
      ErrorMessage(' Error accessing clipboard data! ');
      if CloseClipboard then;
      exit;
    end;
    PasteLen:=0; i:=1;
    while (i<=ClipLen) and (P^[i]<>#0) and (PasteLen<MaxBig-pl) do
    begin
      if (P^[i]=#10) or (P^[i]=#9) then P^[i]:=' ';
      if (P^[i]<>#13) and ((i=1) or (P^[i]<>' ') or (P^[i-1]<>' ')) then
        inc(PasteLen);
      inc(i);
    end;
    ClipLen:=i-1;
    
    if mlen>mlen1 then
    begin
      i:=mlen; mlen:=mlen1+1; mlen1:=i+1;
    end;
    if mlen<>mlen1 then
    begin
      pl:=mlen;
      SDelete(S,Slen,pl,mlen1-mlen);
    end;
    for i:=Slen downto pl do
      if PasteLen<=MaxBig-i then S^[i+PasteLen]:=S^[i];
    j:=0;
    for i:=1 to ClipLen do
    begin
      if (P^[i]<>#13) and ((i=1) or (P^[i]<>' ') or (P^[i-1]<>' ')) then
      begin
        S^[pl+j]:=P^[i]; inc(j);
      end;
    end;
    freemem(P,bytes);
  end else
  begin                                  { Use temporary file }
    if CutPasteBuffer=Nil then
    begin
      ErrorMessage(' Buffer is empty! '); exit;
    end;
    BufLen:=CutPasteBuffer^.GetSize;
    if BufLen<=0 then
    begin
      ErrorMessage(' Buffer is empty! '); exit;
    end;
    if Buflen>MaxBig then PasteLen:=MaxBig
    else PasteLen:=BufLen;
    if mlen>mlen1 then
    begin
      i:=mlen; mlen:=mlen1+1; mlen1:=i+1;
    end;
    if mlen<>mlen1 then
    begin
      pl:=mlen;
      SDelete(S,Slen,pl,mlen1-mlen);
    end;
    if PasteLen>MaxBig-pl then PasteLen:=MaxBig-pl;
    for i:=Slen downto pl do
      if PasteLen<=MaxBig-i then S^[i+PasteLen]:=S^[i];
    CutPasteBuffer^.seek(0);
    CutPasteBuffer^.read(S^[pl],PasteLen);
  end;
  if MaxBig-PasteLen<Slen then Slen:=MaxBig
  else Slen:=Slen+PasteLen;
  pl:=pl+PasteLen;
end;                                { PasteFromBuffer }
procedure EntryToClipboard(Entry: EntryRecPtr);
var
  i,j,ifld: byte;
begin
  { if Entry^.nentry=0 then Exit; }
  if ClipboardPosition=0 then Exit;
  if (VirtualStream<>Nil) and (KeepStack^[ClipboardPosition].VFilePos>=0) then
    VirtualStream^.seek(KeepStack^[ClipboardPosition].VFilePos);
  for i:=MaxBuffStack downto ClipboardPosition do
  begin
    if KeepStack^[i].P<>Nil then
    begin
      if KeepStack^[i].Klen>0 then FreeMem(KeepStack^[i].P,KeepStack^[i].Klen);
      KeepStack^[i].P:=Nil;
    end;
    KeepStack^[i].VFilePos:=-1;
  end;
  BuffStackInd:=ClipboardPosition-1;
  PushBufferStack(Entry^,sizeof(SaveEntryRec),ClipBoardMode,0);
  with Entry^ do
  begin
    i:=1; j:=LastField;
    if EditOnlyStrings then
    begin
      i:=StringIndex; j:=StringIndex;
    end;
    for ifld:=i to j do
    if index[ifld]>0 then
    begin
      if BigIndex[ifld]=0 then
        PushBufferStack(content[index[ifld]],length(content[index[ifld]])+1,
                        ClipBoardMode,0)
      else
        PushBufferStack(Big[BigIndex[ifld]]^,Blen[BigIndex[ifld]],ClipBoardMode,0);
    end;
  end;
  if ClipboardMode<>DontKeep then ClipboardEmpty:=false;
  ClipboardName^:=Entry^.name;
  ClipboardString:=EditOnlyStrings;
end;                                { EntryToClipboard }

procedure ClipboardToEntry(Entry: EntryRecPtr);
var
  i,j,ifld,ClipPos: integer;
  mv: longint;
begin
  if ClipboardEmpty then Exit;
  if EditOnlyStrings<>ClipboardString then Exit;
  ZeroEntry(Entry);
  RecallBufferStack(Entry^,ClipboardPosition);
  ClipPos:=ClipboardPosition+1;
  with Entry^ do
  begin
    i:=1; j:=LastField;
    if EditOnlyStrings then
    begin
      i:=StringIndex; j:=StringIndex;
    end;
    for ifld:=i to j do
    if index[ifld]>0 then
    begin
      if BigIndex[ifld]=0 then
        RecallBufferStack(content[index[ifld]],ClipPos)
      else begin
        RecallBufferStack(Big[BigIndex[ifld]]^,ClipPos);
        Big[BigIndex[ifld]]^[Blen[BigIndex[ifld]]+1]:=#0;
        mv:=Blen[BigIndex[ifld]]; if mv>255 then mv:=255;
        Move(Big[BigIndex[ifld]]^,content[index[ifld]][1],mv);
        content[index[ifld]][0]:=Chr(mv);
      end;
      inc(ClipPos);
    end;
  end;
end;             { ClipboardToEntry }

end.
