{$N-,V-,W-,G+}

Unit wbibtbar;

{$R bitmaps.res}

interface

Uses
  Wobjects, rc_id, WinTypes, WinProcs, bibvars, wbibstat, bibutil, win31,
  rc_strng, wbibbtns, wbibgui, strings, wbibdisp, bibstrg, rc_Bits, wc_help,
  bibcache;

Const
  TbarOpenBtn       = 1;
  TBarRightBtn      = 2;
  TBarLeftBtn       = 3;
  TBarLastBtn       = 4;
  TBarFirstBtn      = 5;
  TBarEntryListBtn  = 6;
  TbarOverviewBtn   = 7;
  TbarNameBtn       = 8;
  TbarSearchBtn     = 9;
  TbarSearchNextBtn = 10;
  TbarNumberBtn     = 11;
  TbarTagBtn        = 12;
  TbarStringsBtn    = 13;
  TbarEditBtn       = 14;
  TbarDelBtn        = 15;
  TbarPattBtn       = 16;
  TbarPrintBtn      = 17;

  TBar_LastBtn      = 17;

  TBtnSize_Large = 1; TBtnSize_Small = 2; TBtnSize_Auto = 3;

type
  ToolBtnRec = record
    Id,HelpId,SHelpID,Order: integer;
  end;

  ToolBtnArr = array[1..TBar_LastBtn] of ToolBtnRec;
  ToolBtnPtr = ^ToolBtnArr;

  ToolBtnsBitArr = array[boolean] of array[1..TBar_LastBtn,1..2] of integer;

const
  ToolBtns: ToolBtnArr = (
    (Id: dl_TbarOpenBtn;              HelpId: HelpText_OpenBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarRightBtn;             HelpId: HelpText_NextBtn;
     SHelpId: HelpText_LastBtn;       Order: 0),
    (Id: dl_TbarLeftBtn;              HelpId: HelpText_BackBtn;
     SHelpId: HelpText_FirstBtn;      Order: 0),
    (Id: dl_TbarLastBtn;              HelpId: HelpText_LastBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarFirstBtn;             HelpId: HelpText_FirstBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarEntryListBtn;         HelpId: HelpText_ListBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarOverviewBtn;          HelpId: HelpText_OverBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarNameBtn;              HelpId: HelpText_LabelBtn;
     SHelpId: HelpMain_GotoLabelNext; Order: 0),
    (Id: dl_TbarSearchBtn;            HelpId: HelpText_SearchBtn;
     SHelpId: HelpText_SearchNextBtn; Order: 0),
    (Id: dl_TbarSearchNextBtn;        HelpId: HelpText_SearchNextBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarNumberBtn;            HelpId: HelpText_NumBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarTagBtn;               HelpId: HelpText_TagBtn;
     SHelpId: HelpMain_GotoTag;       Order: 0),
    (Id: dl_TBarStringsBtn;           HelpId: HelpMain_EditStrings;
     SHelpId: HelpText_EdAbbrevs;     Order: 0),
    (Id: dl_TbarEditBtn;              HelpId: HelpText_EditBtn;
     SHelpId: 0;                      Order: 0),
    (Id: dl_TbarDelBtn;               HelpId: HelpText_DelBtn;
     SHelpId: HelpMain_CutEntry;      Order: 0),
    (Id: dl_TbarPattBtn;              HelpId: HelpText_PattBtn;
     SHelpId: HelpMain_TogglePattern; Order: 0),
    (Id: dl_TbarPrintBtn;             HelpId: HelpMain_Print;
     SHelpId: HelpMain_PrintSetup;    Order: 0)
  );

  ToolBtnsBit: ToolBtnsBitArr = (
    (
     (rc_BitOpen1,      rc_BitOpenX1),
     (rc_BitRight1,     rc_BitRightX1),
     (rc_BitLeft1,      rc_BitLeftX1),
     (rc_BitLast1,      rc_BitLastX1),
     (rc_BitFirst1,     rc_BitFirstX1),
     (rc_BitEntryList1, rc_BitEntryListX1),
     (rc_BitOverview1,  rc_BitOverviewX1),
     (rc_BitName1,      rc_BitNameX1),
     (rc_BitSearch1,    rc_BitSearchX1),
     (rc_BitSearchNext1,rc_BitSearchNextX1),
     (rc_BitNumber1,    rc_BitNumberX1),
     (rc_BitTag1,       rc_BitTagX1),
     (rc_BitStrings1,   rc_BitStringsX1),
     (rc_BitModify1,    rc_BitModifyX1),
     (rc_BitDelete1,    rc_BitDeleteX1),
     (rc_BitPatt1,      rc_BitPattX1),
     (rc_BitPrint1,     rc_BitPrintX1)   ),
    (
     (rc_BitOpen2,      rc_BitOpenX2),
     (rc_BitRight2,     rc_BitRightX2),
     (rc_BitLeft2,      rc_BitLeftX2),
     (rc_BitLast2,      rc_BitLastX2),
     (rc_BitFirst2,     rc_BitFirstX2),
     (rc_BitEntryList2, rc_BitEntryListX2),
     (rc_BitOverview2,  rc_BitOverviewX2),
     (rc_BitName2,      rc_BitNameX2),
     (rc_BitSearch2,    rc_BitSearchX2),
     (rc_BitSearchNext2,rc_BitSearchNextX2),
     (rc_BitNumber2,    rc_BitNumberX2),
     (rc_BitTag2,       rc_BitTagX2),
     (rc_BitStrings2,   rc_BitStringsX2),
     (rc_BitModify2,    rc_BitModifyX2),
     (rc_BitDelete2,    rc_BitDeleteX2),
     (rc_BitPatt2,      rc_BitPattX2),
     (rc_BitPrint2,     rc_BitPrintX2)    )
    );


type

  PHelpIDRec = ^HelpIDRec;
  HelpIDRec = object(TObject)
    CtlID,HelpID,SHelpID: integer;
    constructor init(ACtlID,AHelpID,ASHelpID: integer);
  end;

  PToolbarDlg = ^TToolbarDlg;
  TToolbarDlg = object(TDialog)
    HelpIDs: TCollection;
    Height,Width: integer;
    IsEnabled: boolean;
    constructor Init(AParent: PWindowsObject; AName: PChar);
    procedure   ReorderBtns;
    procedure   SetupWindow; virtual;
    procedure   Update;
    procedure   WMControlColor(var Msg: TMessage); virtual wm_First + wm_CtlColor;
    destructor  Done; virtual;

    procedure wmMouseMove(var Msg: TMessage);    virtual wm_First+wm_MouseMove;
    procedure BtnMouseMove(var Msg: TMessage);   virtual wm_First+bbn_MouseMoved;
    procedure wmCommand(var Msg: TMessage);      virtual wm_first+wm_Command;
    procedure KeyUpDown;
  end;

  PToolbarConfDlg = ^TToolbarConfDlg;
  TToolbarConfDlg = object(TBasicDialog)
    hFinger: HBitmap;
    FingerBitmap: TBitmap;
    ToolBtns: ToolBtnPtr;
    Btns: ToolBtnArr;
    TextFont: HFont;
    TextHeight: Integer;
    changed: boolean;
    LargeButtons: PInteger;
    LargeBtns: Integer;
    ButtonBits: array[1..TBar_LastBtn] of array[boolean] of hBitmap;
    constructor init(AParent: PwindowsObject; AToolBtns: ToolBtnPtr;
                ALargeButtons: PInteger);
    procedure   wmMeasureItem(var Msg: TMessage); virtual wm_first+wm_MeasureItem;
    procedure   wmDrawItem(var Msg: TMessage);    virtual wm_first+wm_DrawItem;
    procedure   UploadBar;
    procedure   Update;
    procedure   SetupWindow; virtual;
    procedure   HandleBtnsLBox(var Msg: TMessage); virtual id_first+dl_TbarConfBtnsLBox;
    procedure   HandleTBarLBox(var Msg: TMessage); virtual id_first+dl_TbarConfTBarLBox;
    procedure   BtnSize;
    procedure   HandleLargeRBox(var Msg: TMessage);
                                             virtual id_first+dl_TBarConfLargeBtns;
    procedure   HandleSmallRBox(var Msg: TMessage);
                                             virtual id_first+dl_TBarConfSmallBtns;
    procedure   HandleAutoRBox(var Msg: TMessage);
                                             virtual id_first+dl_TBarConfAutoBtns;
    procedure   InsertAppend(Ins: boolean);
    procedure   InsertBtn(var Msg: TMessage);      virtual id_first+dl_TBarConfInsert;
    procedure   AppendBtn(var Msg: TMessage);      virtual id_first+dl_TBarConfAppend;
    procedure   RemoveBtn(var Msg: TMessage);      virtual id_first+dl_TBarConfRemove;
    procedure   SpacerBtn(var Msg: TMessage);      virtual id_first+dl_TBarConfSpacer;
    procedure   ok(var Msg: TMessage);             virtual id_first+id_ok;
    destructor  done; virtual;
  end;

var
  LargeTBarBtns: integer;
  Toolbar:     PToolbarDlg;

implementation

const
  ButtonOrigin:    array[boolean] of integer = (2,3);
  ButtonShift:     array[boolean] of integer = (1,2);
  ButtonSeparator: array[boolean] of integer = (3,4);

  ConfItemYSpacing = 2;
  ConfFingerSpacing = 2;
  ConfXShift = 2;

  BtnItem_Disabled = 1; BtnItem_Spacer = 2;

function IsLargeBtns(n: integer): boolean;
begin
  IsLargeBtns := (n=TBtnSize_Large) or
    ((n=TBtnSize_Auto) and (ScreenRect.right>800));
end;

constructor TToolbarConfDlg.init(AParent: PwindowsObject; AToolBtns: ToolBtnPtr;
            ALargeButtons: PInteger);
var
  i: integer;
  Large: boolean;
begin
  TBasicDialog.init(AParent,PChar(rc_TbarConfDlg));
  ToolBtns:=AToolBtns;
  LargeButtons:=ALargeButtons;
  LargeBtns:=LargeButtons^;
  Move(ToolBtns^,Btns,sizeof(Btns));
  Large:=IsLargeBtns(LargeBtns);
  for i:=1 to TBar_LastBtn do
  begin
    ButtonBits[i][true] :=LoadBitmap(HInstance,PChar(ToolBtnsBit[Large][i,1]));
    ButtonBits[i][false]:=LoadBitmap(HInstance,PChar(ToolBtnsBit[Large][i,2]));
  end;
  changed:=false;
  hFinger:=LoadBitmap(Hinstance,PChar(rc_BitFinger));
  GetObject(hFinger,sizeof(TBitmap),@FingerBitmap);
  TextFont:=CreateHelvFont(false,@TextHeight);
  HelpContext:=hc_GUIOptions;
end;                        { TToolbarConfDlg.init }

procedure TToolbarConfDlg.wmMeasureItem(var Msg: TMessage);
var
  Bitmap: TBitmap;
  ItemIndex: word;
  Spacer: boolean;
begin
  with PMeasureItemStruct(Msg.lParam)^ do
  begin
    itemWidth:=ScreenResX;
    if ItemID<0 then ItemHeight:=0
    else begin
      ItemIndex:=LoWord(ItemData);
      Spacer:=HiWord(ItemData) and BtnItem_Spacer <> 0;
      GetObject(ButtonBits[ItemIndex][false],sizeof(TBitmap),@Bitmap);
      ItemHeight:=Bitmap.bmHeight+2*ConfItemYSpacing+4;
      if Spacer then ItemHeight:=ItemHeight+TextHeight+ConfItemYSpacing;
    end;
  end;
end;                         { TToolbarConfDlg.wmMeasureItem }

procedure TToolbarConfDlg.wmDrawItem(var Msg: TMessage);
var
  MemDC: hDC;
  bits: HBitmap;
  OldFont: HFont;
  Bitmap: TBitmap;
  OldBrush,BorderBrush,BackBrush: HBrush;
  Height,Width,i: integer;
  ItemIndex: Word;
  ItemEnabled,Spacer: boolean;
  Frame: TRect;
  F: array[0..255] of char;
begin
  with PDrawItemStruct(Msg.lParam)^ do
  begin
    if ItemID<0 then Exit;
    ItemIndex:=LoWord(ItemData);
    if (ItemIndex<1) or (ItemIndex>TBar_LastBtn) then Exit;
    Spacer:=(HiWord(ItemData) and BtnItem_Spacer) <> 0;
    ItemEnabled:=(HiWord(ItemData) and BtnItem_Disabled) = 0;

    BackBrush:=CreateSolidBrush(GetSysColor(Color_Window));
    BorderBrush:=GetStockObject(Black_Brush);

    OldFont:=SelectObject(hDC,TextFont);
    MemDC := CreateCompatibleDC(hDC);
    Bits:=ButtonBits[ItemIndex][ItemEnabled];
    GetObject(Bits,sizeof(TBitmap),@Bitmap);
    Frame.Left:=rcItem.Left+FingerBitmap.bmWidth+ConfFingerSpacing+ConfXShift;
    Frame.Top:=rcItem.Top+ConfItemYSpacing;
    Frame.Right :=Frame.Left+Bitmap.bmWidth+4;
    Frame.Bottom:=Frame.Top+Bitmap.bmHeight+4;
    Height:=Frame.bottom-Frame.top;
    Width :=Frame.Right-Frame.Left;

    if not ItemEnabled then SetTextColor(hDC,GetSysColor(Color_GrayText))
    else SetTextColor(hDC,GetSysColor(Color_WindowText));
    SetBKMode(hDC,Transparent);
    if Spacer then
    begin
      StrPCopy(F,'Spacer');
      TextOut(hDC,Frame.Left,Frame.Top,F,StrLen(F));
      Frame.Top:=Frame.Top+TextHeight+ConfItemYSpacing;
      Frame.Bottom:=Frame.Bottom+TextHeight+ConfItemYSpacing;
    end;

    OldBrush := SelectObject(hDC, BorderBrush);
    PatBlt(hDC, Frame.left+1, Frame.top, Width-2, bdBorderWidth, PatCopy);
    PatBlt(hDC, Frame.left, Frame.top+1, bdBorderWidth, Height-2, PatCopy);
    PatBlt(hDC, Frame.left+1, Frame.bottom - bdBorderWidth, Width-2,
        bdBorderWidth, PatCopy);
    PatBlt(hDC, Frame.right - bdBorderWidth, Frame.top+1, bdBorderWidth,
        Height-2, PatCopy);

    SelectObject(hDC, GetStockObject(white_Brush));
    PatBlt(hDC, Frame.left+bdBorderWidth, Frame.top+bdBorderWidth,
             Width-2*bdBorderWidth-1,1, PatCopy);
    PatBlt(hDC, Frame.left+bdBorderWidth, Frame.top+bdBorderWidth,
             1, Height-2*bdBorderWidth-1, PatCopy);
    SelectObject(hDC, GetStockObject(DkGray_Brush));
    PatBlt(hDC, Frame.left+bdBorderWidth, Frame.bottom-bdBorderWidth,
             Width-2*bdBorderWidth,1, PatCopy);
    PatBlt(hDC, Frame.right-bdBorderWidth, Frame.top+bdBorderWidth,
             1, Height-2*bdBorderWidth, PatCopy);
    PatBlt(hDC, Frame.left+bdBorderWidth+1, Frame.bottom-bdBorderWidth-1,
             Width-2*bdBorderWidth-2,1, PatCopy);
    PatBlt(hDC, Frame.right-bdBorderWidth-1, Frame.top+bdBorderWidth+1,
             1, Height-2*bdBorderWidth-2, PatCopy);

    SelectObject(MemDC, Bits);   
    BitBlt(hDC, Frame.Left+2,Frame.Top+2,Bitmap.bmWidth,Bitmap.bmHeight,
             MemDC, 0, 0, srcCopy);

    { Text }
    if hWndItem=GetItemHandle(dl_TbarConfBtnsLbox) then
    begin
      LoadString(hInstance,Btns[ItemIndex].HelpID,F,255);
      TextOut(hDC,Frame.Right+6,Frame.bottom-TextHeight-3,F,StrLen(F));
    end;
    if (ItemState and Ods_Selected<>0) then
    begin
      SelectObject(MemDC, hFinger);
      BitBlt(hDC, rcItem.Left+ConfXShift,Frame.Top,
             FingerBitmap.bmWidth, FingerBitmap.bmHeight, MemDC, 0, 0, srcCopy);
    end else
    begin
      SelectObject(hDC, BackBrush);
      PatBlt(hDC,rcItem.Left+ConfXShift,Frame.Top,
             FingerBitmap.bmWidth, FingerBitmap.bmHeight, PatCopy);
    end;
    DeleteDC(MemDC);
    SelectObject(hDC,OldBrush);
    SelectObject(hDC,OldFont);
    DeleteObject(BackBrush);
  end;
end;                           { TToolbarConfDlg.wmDrawItem }

procedure TToolbarConfDlg.UploadBar;
var
  i,j,k,count: integer;
  BitFlags: Word;
begin
  SendDlgItemMsg(dl_TbarConfTBarLBox,lb_ResetContent,0,0);
  count:=0;
  for i:=1 to TBar_LastBtn do
  begin
    j:=0;
    for k:=1 to Tbar_LastBtn do
      if abs(Btns[k].Order)=i then j:=k;
    if j>0 then
    begin
      Bitflags:=0;
      if (Btns[j].Order<0) and (Count>0) then Bitflags:=Bitflags or BtnItem_Spacer;
      SendDlgItemMsg(dl_TBarConfTBarLBox,lb_AddString,0,MakeLong(j,Bitflags));
      inc(Count);
    end;
  end;
  for i:=1 to TBar_LastBtn do
  if Btns[i].Order=0 then
    SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_SetItemData,i-1,MakeLong(i,0))
  else
    SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_SetItemData,i-1,MakeLong(i,BtnItem_Disabled));
  InvalidateRect(GetItemHandle(dl_TBarConfBtnsLBox),Nil,true);
end;                           { TToolbarConfDlg.UploadBar }

procedure TToolbarConfDlg.Update;
var
  en: boolean;
  Ind1,Ind2,Count,Item1: integer;
begin
  Item1:=-1;
  Ind1 :=SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_GetCurSel,0,0);
  if Ind1<>lb_Err then
    Item1:=LoWord(SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_GetItemData,Ind1,0));
  Ind2 :=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCurSel,0,0);
  Count:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCount, 0,0);

  EnableWindow(GetItemHandle(dl_TBarConfSpacer), (Ind2<>lb_Err) and (Ind2<>0));
  EnableWindow(GetItemHandle(dl_TBarConfRemove), Ind2<>lb_Err);

  en:=(Ind1<>lb_Err) and ((Count=0) or (Ind2<>lb_Err));
  if en and (Item1>0) then  en:=(Btns[Item1].Order=0);
  EnableWindow(GetItemHandle(dl_TBarConfInsert), en);
  EnableWindow(GetItemHandle(dl_TBarConfAppend), en);
end;                          { TToolbarConfDlg.Update }

procedure TToolbarConfDlg.SetupWindow;
var
  i: word;
begin
  TBasicDialog.SetupWindow;

  for i:=1 to TBar_LastBtn do
  begin
    SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_AddString,0,MakeLong(i,0));
  end;
  UploadBar;
  SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_SetCurSel,0,0);
  SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,0,0);
  case LargeBtns of
    TBtnSize_Large: CheckDlgButton(HWindow,dl_TBarConfLargeBtns,bf_Checked);
    TBtnSize_Small: CheckDlgButton(HWindow,dl_TBarConfSmallBtns,bf_Checked);
    TBtnSize_Auto:  CheckDlgButton(HWindow,dl_TBarConfAutoBtns,bf_Checked);
  end;
end;                        { TToolbarConfDlg.SetupWindow }

procedure TToolbarConfDlg.HandleBtnsLBox(var Msg: TMessage);
begin
  Update; DefWndProc(Msg);
end;

procedure TToolbarConfDlg.HandleTBarLBox(var Msg: TMessage);
begin
  Update; DefWndProc(Msg);
end;

procedure TToolbarConfDlg.BtnSize;
var
  Large: boolean;
  i: integer;
  Ind1,Ind2: integer;
begin
  i:=TBtnSize_Auto;
  if IsDlgButtonChecked(HWindow,dl_TBarConfLargeBtns)=bf_Checked then
      i:=TBtnSize_Large;
  if IsDlgButtonChecked(HWindow,dl_TBarConfSmallBtns)=bf_Checked then
      i:=TBtnSize_Small;
  if i=LargeBtns then Exit;
  Large:=IsLargeBtns(i); LargeBtns:=i;
  Ind1 := SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_GetCurSel,0,0);
  Ind2 := SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCurSel,0,0);

  SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_ResetContent,0,0);
  for i:=1 to TBar_LastBtn do
  begin
    if ButtonBits[i][true]<>0  then DeleteObject(ButtonBits[i][true]);
    if ButtonBits[i][false]<>0 then DeleteObject(ButtonBits[i][false]);
    ButtonBits[i][true] :=LoadBitmap(HInstance,PChar(ToolBtnsBit[Large][i,1]));
    ButtonBits[i][false]:=LoadBitmap(HInstance,PChar(ToolBtnsBit[Large][i,2]));
    SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_AddString,0,MakeLong(i,0));
  end;
  UpLoadBar;
  if Ind1<>lb_Err then SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_SetCurSel,Ind1,0);
  if Ind2<>lb_Err then SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,Ind2,0);
  Update;
  Changed:=true;
end;                                { TToolbarConfDlg.BtnSize }

procedure TToolbarConfDlg.HandleLargeRBox(var Msg: TMessage);
begin BtnSize; end;

procedure TToolbarConfDlg.HandleSmallRBox(var Msg: TMessage);
begin BtnSize; end;

procedure TToolbarConfDlg.HandleAutoRBox(var Msg: TMessage);
begin BtnSize; Changed:=true; end;

procedure TToolbarConfDlg.InsertAppend(Ins: boolean);
var
  Ind1,Ind2,Count,sgn,i: integer;
  Item,place: Word;
begin
  Ind1:=SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_GetCurSel,0,0);
  Ind2:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCurSel,0,0);
  if (Ind1=lb_Err) then Exit;
  Count:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCount,0,0);
  if (Ind2=lb_Err) and (Count>0) then Exit;
  Item:=LoWord(SendDlgItemMsg(dl_TBarConfBtnsLBox,lb_GetItemData,Ind1,0));
  if Btns[Item].Order<>0 then
  begin
    messagebeep(0); Exit;
  end;
  if Ind2=lb_Err then place:=1
  else if Ins then place:=Ind2+1
  else place:=Ind2+2;
  if Ind2=lb_Err then Ind2:=0;
  for i:=1 to TBar_LastBtn do 
  begin
    if Btns[i].Order>0 then sgn:=1 else sgn:=-1;
    if abs(Btns[i].Order)>=place then Btns[i].Order:=Btns[i].Order+sgn;
  end;
  Btns[Item].Order:=place;
  UploadBar;
  if (SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,Ind2+1,0)=lb_Err) then
     SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,Ind2,0);
  Update;
  Changed:=true;
end;                         { TToobarConfDlg.InsertAppend }

procedure TToolbarConfDlg.InsertBtn(var Msg: TMessage);
begin
  InsertAppend(true);
end;                          { TToolbarConfDlg.InsertBtn }

procedure TToolbarConfDlg.AppendBtn(var Msg: TMessage);
begin
  InsertAppend(false);
end;

procedure TToolbarConfDlg.RemoveBtn(var Msg: TMessage);
var
  Ind,i,sgn: integer;
  Item: Word;
  ItemData: Longint;
  Spacer: boolean;
begin
  Ind:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCurSel,0,0);
  if (Ind=lb_Err) then
  begin
    Messagebeep(0); Exit;
  end;
  ItemData:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetItemData,Ind,0);
  Item:=LoWord(ItemData);
  Spacer:=(HiWord(ItemData) and btnItem_Spacer)<>0;
  Btns[Item].Order:=0;
  for i:=1 to TBar_LastBtn do
  begin
    if Btns[i].Order>0 then sgn:=1 else sgn:=-1;
    if abs(Btns[i].Order)>Ind+1 then Btns[i].Order:=Btns[i].Order-sgn;
    if spacer and (Btns[i].Order=Ind+1) then
      Btns[i].Order:=-Btns[i].Order;
  end;
  UploadBar;
  if (SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,Ind,0)=lb_Err)
    and (Ind>0) then
     SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,Ind-1,0);
  Update;
  Changed:=true;
end;                        { TToolbarConfDlg.RemoveBtn }

procedure TToolbarConfDlg.SpacerBtn(var Msg: TMessage);
var
  Ind,Item: integer;
  BitFlags: Word;
  ItemData: Longint;
begin
  Ind:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetCurSel,0,0);
  if Ind=lb_Err then
  begin
    Messagebeep(0); Exit;
  end;
  ItemData:=SendDlgItemMsg(dl_TBarConfTBarLBox,lb_GetItemData,Ind,0);
  Item:=LoWord(ItemData); BitFlags:=HiWord(ItemData);
  if BitFlags and BtnItem_Spacer=0 then
  begin
    Btns[Item].Order:=-abs(Btns[Item].Order);
  end else
  begin
    Btns[Item].Order:=abs(Btns[Item].Order);
  end;
  UploadBar;
  SendDlgItemMsg(dl_TBarConfTBarLBox,lb_SetCurSel,Ind,0);
  Changed:=true;
end;                           { TToolbarConfDlg.SpacerBtn }

procedure TToolbarConfDlg.ok(var Msg: TMessage);
var
  i: integer;
begin
  if not CanClose then Exit;
  if not Changed then EndDlg(id_cancel)
  else begin
    for i:=1 to TBar_LastBtn do ToolBtns^[i].Order:=Btns[i].Order;
    LargeButtons^:=TBtnSize_Auto;
    if IsDlgButtonChecked(HWindow,dl_TBarConfLargeBtns)=bf_Checked then
      LargeButtons^:=TBtnSize_Large;
    if IsDlgButtonChecked(HWindow,dl_TBarConfSmallBtns)=bf_Checked then
      LargeButtons^:=TBtnSize_Small;
    EndDlg(id_ok);
  end;
end;                         { TToolbarConfDlg.ok }

destructor TToolbarConfDlg.done;
var
  i: integer;
begin
  DeleteObject(hFinger);
  DeleteObject(TextFont);
  for i:=1 to TBar_LastBtn do
  begin
    if ButtonBits[i][true]<>0  then DeleteObject(ButtonBits[i][true]);
    if ButtonBits[i][false]<>0 then DeleteObject(ButtonBits[i][false]);
  end;
  TBasicDialog.Done;
end;                        { TToolbarConfDlg.done }

{ THelpIDRec methods }

constructor HelpIDRec.init(ACtlID,AHelpID,ASHelpID: integer);
begin
  TObject.init;
  CtlID:=ACtlID; HelpID:=AHelpID; SHelpID:=ASHelpID;
end;

{ TToolbarDlg methods }

Var
  ghKbrdHook: HHook;
  KbdHookInst: TFarProc;

function TrapKbHook(Code: integer; wParam: Word; lParam: longint): longint; export;
var
  Send,ScanCode,i: word;
  CtrlPressed,ShftPressed,arrow: boolean;

begin
  Send:=0; arrow:=false;
  if (Code=0) and (Code=HC_ACTION) and MainWinActive and not MainMenuActive and
     ((wParam=vk_Control) or (wParam=vk_Shift)) and
      ((lParam and wmChar_KeyWasDown=0) =
        (lParam and wmChar_BeingReleased=0)) then
                                      Toolbar^.KeyUpDown;
  TrapKbHook:=CallNextHookEx(ghKbrdHook,Code,wparam,lparam);
end;                           { TrapKbHook }

constructor TToolbarDlg.Init(AParent: PWindowsObject; AName: PChar);
var
  i: integer;
begin
  TDialog.Init(AParent,AName);
  HelpIDs.init(TBar_LastBtn,10);
  for i:=1 to TBar_LastBtn do
  with ToolBtns[i] do HelpIDs.Insert(New(PHelpIDRec,Init(id,HelpId,SHelpID)));
  IsEnabled:=false;
end;                        { TToolbarDlg.Init }

procedure TToolbarDlg.ReorderBtns;
var
  CurPoint,MaxHeight,i,j,k: integer;
  H: HWnd;
  Rect: TRect;
  Ht,Wd: integer;
  LargeBtns: boolean;
begin
  Show(sw_hide);
  LargeBtns:=IsLargeBtns(LargeTBarBtns);
  for i:=1 to TBar_LastBtn do
  with ToolBtns[i] do
  begin
    H:=GetItemHandle(id);
    ShowWindow(H,sw_Hide);
    {
    if Order=0 then ShowWindow(H,sw_hide)
    else ShowWindow(H,sw_show);
    }
    SendMessage(H,bb_SetBitmap,0,
      MakeLong(ToolBtnsBit[LargeBtns][i,1],
               ToolBtnsBit[LargeBtns][i,2]));
  end;
  CurPoint:=ButtonOrigin[LargeBtns]; MaxHeight:=0;
  for i:=1 to TBar_LastBtn do
  begin
    j:=0;
    for k:=1 to Tbar_LastBtn do
      if abs(ToolBtns[k].Order)=i then j:=k;
    if j>0 then
    begin
      if (CurPoint>ButtonOrigin[LargeBtns]) and (ToolBtns[j].Order<0) then
        CurPoint:=CurPoint+ButtonSeparator[LargeBtns];
      with ToolBtns[j] do
      begin
        H:=GetItemHandle(id);
        GetWindowRect(H,Rect);
        Ht:=Rect.bottom-Rect.top; Wd:=Rect.right-Rect.left;
        MoveWindow(H,CurPoint,1,Wd,Ht,true);
        ShowWindow(H,sw_show);
        CurPoint:=CurPoint+Wd+ButtonShift[LargeBtns];
        if MaxHeight<Ht then MaxHeight:=Ht;
      end;
    end;
  end;
  Height:=MaxHeight+3; Width:=CurPoint;
  GetClientRect(Parent^.HWindow,Rect); Width:=Rect.right-Rect.left;
  MoveWindow(HWindow,0,0, Width, Height,true); Show(sw_Show);
{  InvalidateRect(HWindow,Nil,true);}
end;                           { TToolbarDlg.ReorderBtns }

procedure TToolbarDlg.SetupWindow;
begin
  TDialog.SetupWindow;
  ReorderBtns;
  { Set keyboard hook for the accelerators }
  KbdHookInst:=MakeProcInstance(@TrapKbHook,HInstance);
  ghKbrdHook:=SetWindowsHookEx(wh_Keyboard,THookProc(KbdHookInst),
                               Hinstance,GetCurrentTask);
end;                           { TToolbarDlg.SetupWindow }

procedure TToolbarDlg.Update;
var
  en,IsFile: boolean;

procedure EnableBtn(Ind: integer; en: boolean);
begin
  if (ToolBtns[Ind].Order=0) then Exit;
  EnableWindow(GetItemHandle(Toolbtns[Ind].id),en);
end;

begin
  if not IsEnabled then Exit;
  IsFile:=(CurrentBibFile>0) and (bibname^<>'');
  EnableBtn(TBarOpenBtn,not Linked);
  EnableBtn(TBarRightBtn,     BibFileExists and IsFile);
  EnableBtn(TBarPrintBtn,     BibFileExists and IsFile);
  EnableBtn(TBarLeftBtn,      BibFileExists and IsFile and (WrapEOF2BOF or
                                                 (entry^.entrynum>1)));
  EnableBtn(TBarLastBtn,      BibFileExists and IsFile and not (
         EntryCache^.UseCache(Pattern) and (EntryCache^.Last>-1) and
                                         (Entry^.EntryNum=EntryCache^.Last)));
  EnableBtn(TBarFirstBtn,     BibFileExists and IsFile and (entry^.entrynum<>1));
  EnableBtn(TBarEntryListBtn, BibFileExists and IsFile);
  EnableBtn(TBarOverviewBtn,  BibFileExists and IsFile);
  EnableBtn(TBarNameBtn,      BibFileExists and IsFile);
  EnableBtn(TBarSearchBtn,    BibFileExists and IsFile);
  EnableBtn(TBarSearchNextBtn,BibFileExists and IsFile and
                              (UseSearchFields or (SearchString^<>'')));
  EnableBtn(TBarNumberBtn,    BibFileExists and IsFile);

  en:=((not BibFileExists) and (BibName^<>'')) or
      (BibFileExists and IsFile and not (BibReadOnly or Linked));
  EnableBtn(TBarStringsBtn,en);
  en:=BibFileExists and IsFile and not (BibReadOnly or Linked)
      and (Entry^.EntryNum>0);
  EnableBtn(TBarEditBtn,en);
  EnableBtn(TBarDelBtn, en);

  EnableBtn(TBarTagBtn,IsFile and (Entry^.Entrynum>0));
end;                          { TToolbarDlg.Update }

procedure TToolbarDlg.WMControlColor(var Msg: TMessage);
begin
  if Msg.LParamHi = ctlcolor_Dlg then
  begin
    SetBkMode(Msg.WParam, Transparent);
    Msg.Result := GetStockObject(LtGray_Brush);
  end else
    DefWndProc(Msg);
end;

procedure TToolbarDlg.wmMouseMove(var Msg: TMessage);
begin
  StatusBar^.ClearHelpText;
end;

procedure TToolbarDlg.BtnMouseMove(var Msg: TMessage);
var
  P: PHelpIDRec;

function Matches(P: pointer): boolean; far;
begin
  Matches:=(PHelpIDRec(P)^.CtlID = Msg.wParam);
end;

begin
  P:=Nil;
  P:=HelpIDs.FirstThat(@Matches);
  if P<>Nil then
  begin
    if (P^.SHelpID<>0) and
      ((GetKeyState(vk_Shift)<0) or (GetKeyState(vk_Control)<0)) then
      StatusBar^.PutHelpText(P^.SHelpID)
    else
      StatusBar^.PutHelpText(P^.HelpID);
    StatusBar^.CheckHelpPos(true);
  end;
end;                           { TToolbarDlg.BtnMouseMove }

procedure TToolbarDlg.wmCommand(var Msg: TMessage);
var
  i,j: integer;
begin
  j:=0;
  for i:=1 to TBar_LastBtn do if Msg.wParam=ToolBtns[i].id then j:=i;
  if j>0 then
  begin
    if (GetKeyState(vk_Shift)<0) or (GetKeyState(vk_Control)<0) then
      PostMessage(Parent^.HWindow,bib_TbButtonPressed,ToolBtns[j].id,1)
    else
      PostMessage(Parent^.HWindow,bib_TbButtonPressed,ToolBtns[j].id,0);
  end else
    TDialog.wmCommand(Msg);
end;

procedure TToolbarDlg.KeyUpDown;
var
  H: HWnd;
  pt,ptlocal: TPoint;
  Msg: TMessage;
  DC: hDC;
  DoIt: boolean;
begin
  GetCursorPos(pt);
  ptlocal:=pt; ScreenToClient(HWindow,ptlocal);
  H:=ChildWindowFromPoint(HWindow,ptlocal);
  if (H<>0) and (H<>HWindow) and IsWindowEnabled(H) then
  begin
    ptlocal:=pt; ScreenToClient(H,ptlocal);
    DC:=GetDC(H);
    DPtoLP(DC,ptlocal,1);
    DoIt:=(GetPixel(DC,ptlocal.x,ptlocal.y)<>-1);
    ReleaseDC(H,DC);
    if DoIt then
    begin
      Msg.wParam:=GetDlgCtrlID(H);
      BtnMouseMove(Msg);
    end;
  end;
end;                       { TToolbarDlg.KeyUpDown }


destructor TToolbarDlg.Done;
begin
  UnhookWindowsHookEx(ghKbrdHook);
  FreeProcInstance(KbdHookInst);
  HelpIDs.Done;
  TDialog.done;
end;


end.
