/*
 * (c) Copyright 2001-2003 Yann-Gal Guhneuc,
 * cole des Mines de Nantes and Object Technology International, Inc.
 * 
 * Use and copying of this software and preparation of derivative works
 * based upon this software are permitted. Any copy of this software or
 * of any derivative work must include the above copyright notice of
 * the author, this paragraph and the one after it.
 * 
 * This software is made available AS IS, and THE AUTHOR DISCLAIMS
 * ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, AND NOT WITHSTANDING ANY OTHER PROVISION CONTAINED HEREIN,
 * ANY LIABILITY FOR DAMAGES RESULTING FROM THE SOFTWARE OR ITS USE IS
 * EXPRESSLY DISCLAIMED, WHETHER ARISING IN CONTRACT, TORT (INCLUDING
 * NEGLIGENCE) OR STRICT LIABILITY, EVEN IF THE AUTHOR IS ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 * 
 * All Rights Reserved.
 */
package bibtex.visitor;

import bibtex.dom.BibtexConcatenatedValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexField;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexKey;
import bibtex.dom.BibtexPreamble;
import bibtex.dom.BibtexString;
import bibtex.dom.BibtexStringDefinition;
import bibtex.dom.BibtexStringReference;
import bibtex.dom.BibtexToplevelComment;

/**
 * @author 	Yann-Gal Guhneuc
 */
public interface BibtexVisitor {
	void close(final BibtexField bibtexField);
	void close(final BibtexFile bibtexFile);
	void close(final BibtexEntry bibtexEntry);
	void open(final BibtexEntry bibtexEntry);
	void open(final BibtexField bibtexField);
	void open(final BibtexFile bibtexFile);
	void visit(final BibtexConcatenatedValue bibtexConcatenatedValue);
	void visit(final BibtexKey bibtexKey);
	void visit(final BibtexPreamble bibtexPreamble);
	void visit(final BibtexString bibtexString);
	void visit(final BibtexStringDefinition bibtexStringDefinition);
	void visit(final BibtexStringReference bibtexStringReference);
	void visit(final BibtexToplevelComment bibtexToplevelComment);
}
