/*
 * FoundGUI.java
 *
 * Created on 17. Oktober 2005, 20:09
 */

/**
 *
 * This class implements a dialogue managing search results.
 * Calls to FoundGUI fill the list of slide entries.
 * The Working Collection actually is a special kind of a FoundGUI.
 *
 * @author  Olle Nebendahl
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class FoundGUI extends JDialog {

    java.awt.Point myCoordinates;

    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    
    private JButton editButton;
    private JButton chooseButton;
    
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel previewLabel;
    
    public JTextArea previewTextArea;

    public JList jList1;

    private JPanel jPanel1;
    private JPanel jPanel2;
    
    private JScrollPane previewScrollPane;

    DefaultListModel myListModel;

    boolean standsalone=false;
    int[] idList;
    int task;
    
    /** Creates new form FoundGUI */
    public FoundGUI() {
    
        myListModel = new DefaultListModel();
        myListModel.addElement("This");
        myListModel.addElement("is");
        myListModel.addElement("only");
        myListModel.addElement("a");
        myListModel.addElement("test");
        
        standsalone=true;

  
        initComponents();
    }
    
    public void setVisible(boolean b)
    {
        if(!b)
        {
            getLocation(myCoordinates);
            Constants.savePreferences();
        }
        else 
        if(!isVisible())setLocation(myCoordinates);
        super.setVisible(b);
    }
    

    public FoundGUI(int[] entries, boolean modal, boolean withCB) 
    {
        super();
        withChooseButton=withCB;
        fillFoundEntries(entries);
        initComponents();
    }

    public FoundGUI(Dialog owner, int[] entries, boolean modal, boolean withCB) 
    {
        super(owner, modal);
        withChooseButton=withCB;
        fillFoundEntries(entries);
        initComponents();
    }

    public FoundGUI(Frame owner, int[] entries, boolean modal, boolean withCB) 
    {
        super(owner, modal);
        withChooseButton=withCB;
        fillFoundEntries(entries);
        initComponents();
    }

    public FoundGUI(int[] entries) 
    {
        super();
        fillFoundEntries(entries);
        initComponents();
    }
    
    /*
    public FoundGUI(boolean b) 
    { 
        Frame owner=null;
        super(owner, modal); 
    }*/
    
    boolean withChooseButton = false;
    
    private void fillFoundEntries(int[] entries)
    {
        idList=entries;
        if(null==myListModel)myListModel = new DefaultListModel();
        else myListModel.clear();
        if(null==idList)
        {
            jButton1.setEnabled(false);
            jButton2.setEnabled(false);
            return;
        }
        int i=0;
        int l=entries.length;
        SlideRecord sr;
        String s;
        while(i<l)
        {
            sr=SlideCache.getSlide(entries[i++]);        
            myListModel.addElement(sr.getHeader());
        }
    }


    protected void initComponents() 
    {
        myCoordinates = Constants.prefFoundGUICoordinates;
        jLabel2 = new JLabel();
        jLabel1 = new JLabel();


        jButton1 = new JButton();
        jButton2 = new JButton();
        jButton3 = new JButton();

        jPanel1 = new JPanel();
        jPanel2 = new JPanel();
        
        jList1 = new JList(myListModel);
        
        

        jList1.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        jList1.setSelectedIndex(0);
        
        //jList1.setVisibleRowCount(5);
        
        
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListMouseClicked(evt);
            }
        });
        
        jList1.addListSelectionListener(new ListSelectionListener()
        {
            public void valueChanged(ListSelectionEvent e)
            {
                jList1valueChanged(e);
            }
        });
        
        
        JScrollPane jList1ScrollPane = new JScrollPane(jList1);

        getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));

        if(standsalone)setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        else setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        jLabel2.setText("search results");
        jPanel1.add(jLabel2);

        jLabel1.setText("");
        jPanel1.add(jLabel1);

        jButton1.setText("refine...");
        jButton2.setText("exclude...");
        jButton3.setText("add...");

        
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        
        jPanel1.add(jButton1);
        jPanel1.add(jButton2);
        jPanel1.add(jButton3);
        /*
        addWindowListener(new java.awt.event.WindowAdapter()
        {
          public void windowClosing(java.awt.event.WindowEvent evt)
          {
            onClose(evt);
          }
        });*/

        getContentPane().add(jPanel1);

        //jList1.setPreferredSize(new java.awt.Dimension(500, 200));
        //jList1.setPreferredSize(new Dimension(500,200));
        //jList1.setVisibleRowCount(4);
        jPanel2.add(jList1ScrollPane, BorderLayout.CENTER);
        //jPanel2.add(jList1);
        

        editButton = new JButton();
        editButton.setText("edit");
        editButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editButtonActionPerformed(evt);
            }
        });
        jPanel2.add(editButton);

        chooseButton = new JButton();
        chooseButton.setText("choose");
        chooseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseButtonActionPerformed(evt);
            }
        });
        if(withChooseButton)jPanel2.add(chooseButton);
        
        previewLabel = new JLabel();
        previewTextArea = new JTextArea();
        previewLabel.setText("preview:");
        previewTextArea.setText("select entry to get a preview of slide");
        float f = 9;
        previewTextArea.setFont(previewLabel.getFont().deriveFont(f));
        previewTextArea.setEditable(false);
        previewTextArea.setBackground(this.getBackground());
        //jPanel2.add(previewLabel);
        previewScrollPane = new JScrollPane(previewTextArea);
        previewScrollPane.setPreferredSize(new Dimension(200,100));
        jPanel2.add(previewScrollPane);
        

        getContentPane().add(jPanel2);

        pack();
    }
    

/*  private void onClose(java.awt.event.WindowEvent evt)
    {
        if(parent!=null)parent.setVisible(true);
    }*/
    
    private void jListMouseClicked(java.awt.event.MouseEvent evt) 
    {
        int clickCount=evt.getClickCount();
        if(2==clickCount)
        {
            //System.out.println("private void jListMouseClicked(java.awt.event.MouseEvent evt)");
            //System.out.println(clickCount+" "+jList1.getSelectedIndex());
            doEdit();
        }
    }
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        //refine button

        SG = new SearchGUI(this, true);
        SG.setVisible(true);
        if(SG.result!=null)
        {
           idList=Help.refine(idList,SG.result.asArray(Help.TAIL_FIRST));
           fillFoundEntries(idList);
        }
        
    }
    
    public void jList1valueChanged(ListSelectionEvent evt)
    {
    
        int k= jList1.getSelectedIndex();
        if(k==(-1))return;
        int i =idList[k];
        try
        {
            previewTextArea.setText(SlideConnection.getSlideSourceByIdSt(i));
        }
        catch(java.lang.NullPointerException e)
        {
            previewTextArea.setText("The selected slide cannot be found in the data base"
                                               +" - a known bug if You want to chose a slide "
                                               +"within the working collection or a list of search results that You`ve already deleted.");
        }
        pack();
        //System.out.println(jList1.getSelectedValue());
        
    }
    
    
    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        //exclude button
        SG = new SearchGUI(this, true);
        SG.setVisible(true);
        if(SG.result!=null)
        {
            Help.intArrayToString(idList);
    //           System.out.println(SG.result.length());
    //           Help.intArrayToString(SG.result);
    //           System.out.println("");
            idList=Help.exclude(idList,SG.result.asArray(Help.TAIL_FIRST));
            fillFoundEntries(idList);
            Help.intArrayToString(idList);
        }
    }


    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) 
    {
        //add button
        addButton();
    }
    
    public void addButton()
    {
        SG = new SearchGUI(this, true);
        SG.setVisible(true);
        if(SG.result.length()!=0)
        {
            //System.out.println(Help.intArrayToString(idList)+"*1*");
            //System.out.println(Help.intArrayToString(SG.result.asArray(Help.TAIL_FIRST))+"*2*");
            
            if(null!=idList)idList=Help.combine(idList,SG.result.asArray(Help.TAIL_FIRST));
            else idList=SG.result.asArray(Help.TAIL_FIRST);
            //System.out.println(Help.intArrayToString(idList)+"*3*");
            fillFoundEntries(idList);
            //add(SG.result.asArray(Help.TAIL_FIRST));
        }
    }
    
    public void add(int[] list)
    {
            int l = list.length;
            int[] list2 = new int[l];
            System.arraycopy(list,0,list2,0,l);
            java.util.Arrays.sort(list2);
            if(null!=idList)idList=Help.combine(idList,list2);
            else idList=list2;
            //System.out.println(Help.intArrayToString(idList)+"*3*");
            fillFoundEntries(idList);
            pack();
    }

    private void chooseButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        int k=jList1.getSelectedIndex();
        if(k==(-1))return;
        int[] i = new int[1];
        i[0]=idList[k];
        //System.out.println(Help.intArrayToString(i)+"*for working*");
        try
        {
            WorkingPool.add(i);
            WorkingPool.setVisible(true);
        }
        catch(java.lang.NullPointerException e)
        {
            JOptionPane.showMessageDialog(this, "The selected slide cannot be found in the data base"
                                               +" - a known bug if You want to chose a slide "
                                               +"within the working collection or a list of search results that You`ve already deleted.");            
        }

    }
    
    private void editButtonActionPerformed(java.awt.event.ActionEvent evt) 
    {
        doEdit();
    }
    
    private void doEdit()
    {
        int k=jList1.getSelectedIndex();
        if(k==(-1))return;
        int i =idList[k];
        if(Constants.DBG)System.out.println(i);
        try
        {
            final SlideEditGUI seg = new SlideEditGUI(new SlideWrapper(i));
            java.awt.EventQueue.invokeLater(new Runnable() {
                public void run() {
                    seg.setVisible(true);
                }
            });
        }
        catch(java.lang.NullPointerException e)
        {
            JOptionPane.showMessageDialog(this, "The selected slide cannot be found in the data base"
                                               +" - a known bug if You want to chose a slide "
                                               +"within the working collection or a list of search results that You`ve already deleted.");            
            return;
        }
        
        
    }
   
    public void update(int[] neu)
    {
      setVisible(true);/*
      jListBox1.
      switch(task)
      {
        case:SEARCH_ADD:
      }*/
    }
    
    /**
     * @param args the command line arguments
     */
     
    SearchGUI SG; 
    
    public static void main(String args[]) 
    {
        int[] iL = new int[0];
    
        final FoundGUI FG = new FoundGUI(new Frame(),iL,false,true);
        
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                FG.setVisible(true);
                FG.addButton();
            }
        });
    }
    
    public void pack()
    {
        if(jList1.getWidth()>400)jList1.setFixedCellWidth(400);
        super.pack();
    }
}
