import javax.swing.*;
import java.io.*;
/*
 * TalkLoader.java
 *
 * Created on 13. November 2005, 15:34
 */


/**
 *
 *  This class implements the main routine while loading new talks.
 *
 * @author  Olle Nebendahl
 */
class TalkLoader
{
    JFrame owner;
    ProgressGUI progressGUI;
    
    TalkLoader(JFrame ownera)
    {
        owner=ownera;
        progressGUI=new ProgressGUI(owner,"add talk",false);

        JFileChooser fileChooser = new JFileChooser(Constants.prefLastOpenDir);
        int returnVal = fileChooser.showOpenDialog(owner);
        
        if(returnVal == JFileChooser.APPROVE_OPTION) 
        {
            String fileName=fileChooser.getSelectedFile().getAbsolutePath();
            //Constants.prefLastOpenDir=fileChooser.getSelectedFile().getAbsolutePath();
            
            progressGUI.Label1.setText(fileName);

            //Constants.prefLastOpenDir=Constants.prefLastOpenDir.substring(0,Constants.prefLastOpenDir.lastIndexOf(fileName));
            Constants.prefLastOpenDir=fileChooser.getSelectedFile().getParentFile().getAbsolutePath();
            Constants.savePreferences();
            progressGUI.setVisible(true);            
            
            Logger.log("open this file: "+fileName);
            
            load(fileName,false);
        }        
    }
    
    TalkLoader(JFrame ownera,String pfad)
    {
        owner=ownera;

        final JFileChooser fc = new JFileChooser(pfad);
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(owner);
        if(returnVal==JFileChooser.APPROVE_OPTION)
        {
        
            File dir=fc.getSelectedFile();
            Constants.prefLastOpenDir=dir.getAbsolutePath();
            Constants.savePreferences();
            Logger.log("scanning:"+dir );
            String entries[] = dir.list( new CustomFilenameFilter(".tex"));
            
            String fileName;
            
            int l = entries.length;
            int i = 0;
            while(i<l)
            {
                fileName=entries[i++];
                progressGUI=new ProgressGUI(owner,"add talks",false);
                progressGUI.Label1.setText(fileName);
                progressGUI.setVisible(true);            
                Logger.log(fileName);
                load(dir+"\\"+fileName,true);
            }
        }
    }
    
    private void load(String fileName, boolean automatic)
    {
        boolean fertig=false;
        CommandRepresentation cr=null;
        TagRepresentation tr=null;
        SlideCommandChooser commandChooser;
        
        PNG ping = new PNG(fileName);
        if(ping.foundSlideCommands.size()==1)
        {
            fertig=true;
            cr=(CommandRepresentation)ping.foundSlideCommands.firstElement();
        }
        if(!fertig&&ping.foundSlideCommands.size()>1)
        {
            commandChooser = new SlideCommandChooser(owner,true,ping.foundSlideCommands);
            if(!automatic)commandChooser.setVisible(true);
            if(commandChooser.approved)
            {
                fertig=true;
                cr=commandChooser.result;
            }
        }
        if(!fertig&&(ping.foundCommands.getCount()>0))
        {
            commandChooser = new SlideCommandChooser(owner,true,ping.foundCommands);
            if(!automatic)commandChooser.setVisible(true);
            if(commandChooser.approved)
            {
                fertig=true;
                cr=commandChooser.result;
            }
        }
        if(!fertig)
        {
            AddTalkGUI ag=new AddTalkGUI(owner,true);
            if(!automatic)ag.setVisible(true);
            if(ag.approved)
            {
                fertig=true;
                //System.out.println("choice: "+ag.getChoice());
                if(ag.getChoice()==AddTalkGUI.COMMAND)cr=ag.getCommandRepresentation();
                if(ag.getChoice()==AddTalkGUI.TAG)tr=ag.getTagRepresentation();
            }
        }
        
        if(!fertig)
        {
            if(!automatic)
            {
                JOptionPane.showMessageDialog(owner,"I cannot read any talks, if I don't know\nhow slides are seperated.");
                return;
            }
            else
            {
                SlideExtractor s1 = new SlideExtractor(PrefSlideCommands.getFirst(),FOS.readFromFileWithoutTexComments(fileName),fileName,progressGUI);
                if(s1.foundSlides.size()==0)
                {
                    s1 = new SlideExtractor(new TagRepresentation("\\begin{slide}","\\end{slide}"),FOS.readFromFileWithoutTexComments(fileName),fileName,progressGUI);
                    return;
                }
                else return;
            }
        }
        
        //System.out.println(cr);
        //System.out.println(tr);
        
        SlideExtractor se;
        
        if(tr==null)se=new SlideExtractor(cr,FOS.readFromFileWithoutTexComments(fileName),fileName,progressGUI);
        else se=new SlideExtractor(tr,FOS.readFromFileWithoutTexComments(fileName),fileName,progressGUI);
    }
    
    
    public static void main(String[] a)
    {
        TalkLoader tl = new TalkLoader(null,".");
    }
}
