unit ETSyms;
{ Definitions for ET symbols

  JCC 27 Aug 90   begin and end for logical character and general macro
  JCC  6 Aug 90   Names of symbols.  beginfrac.
  JCC  6 Jun 90   Add definitions for arguments and fraction (prelim)
  JCC 14 Apr 90   Add definitions for TeX symbols.
}

interface

type
   namestring = string[20];

const
               {Standard ASCII: }
   tab      = #9;
   lf       = #10;
   cr       = #13;

               {ET specials: }
   symbol   = #7;
   bksp     = #8;

   beginsub = #1;
   endsub   = #2;
   beginsup = #3;
   endsup   = #4;
   beginmath= #5;
   endmath  = #6;
   begineq  = #14;
   endeq    = #15;
   beginarg = #16;
   endarg   = #17;
   beginfrac= #18;
   endfrac  = #19;
   beginlog = #20;
   endlog   = #21;
   beginmac = #22;
   endmac   = #23;

               {TeX defined:}
   TeXActiveCh = '\';
   CommentChar = '%';
   ArgChar     = '#';
   BeginGroup  = '{';
   EndGroup    = '}';


   beginset = [beginsub, beginsup, beginmath, begineq, beginarg];

   ETSet = [symbol, bksp, beginsub, endsub, beginsup, endsup,
            beginmath, endmath, begineq, endeq, beginarg, endarg,
            beginfrac, endfrac];

var NameSym: array[char] of namestring;



implementation


procedure InitNames;
  var c: char;
  begin         {InitNames}
     {Defaults:}
     for c := #32 to #255 do NameSym[c] := c;
     for c := #0 to #31 do NameSym[c] := '^' + chr(ord('@') + ord(c));

     NameSym[tab]      := '<tab>';
     NameSym[cr]       := '<cr>';
     NameSym[lf]       := '<lf>';

     NameSym[symbol]   := '<symbol>';
     NameSym[bksp]     := '<bksp>';
     NameSym[beginsub] := '<beginsub>';
     NameSym[endsub]   := '<endsub>';
     NameSym[beginsup] := '<beginsup>';
     NameSym[endsup]   := '<endsup>';
     NameSym[beginmath]:= '<beginmath>';
     NameSym[endmath]  := '<endmath>';
     NameSym[begineq]  := '<begineq>';
     NameSym[endeq]    := '<endeq>';
     NameSym[beginarg] := '<beginarg>';
     NameSym[endarg]   := '<endarg>';
     NameSym[beginfrac]:= '<frac>';
     NameSym[endfrac]  := '<endfrac>';

  end;          {InitNames}


begin
   InitNames
end.

