#if ProjectX < 5
#include <X11R5.rules>
#endif

/*
 *
 *                   Template file for Imake-TeX
 *
 *                   Copyright 1993 Rainer Klute
 *              <klute@irb.informatik.uni-dortmund.de>
 */

XCOMM Imake rules for TeX support
XCOMM rules: $Id: TeX.tmpl.sed,v 1.0 1993/08/17 15:28:51 klute Exp klute $

IRULESRC = $(CONFIGDIR) -ITEX_CONFIGDIR

/*
 * Paper formats:
 */

#ifndef PaperFormatA4
#define PaperFormatA4()							@@\
     FORMATXDVI = -paper a4						@@\
    FORMATDVIPS = -t a4							@@\
FORMATGHOSTVIEW = -a4
#endif /* PaperFormatA4 */


#ifndef PaperFormatA4R
#define PaperFormatA4R()						@@\
     FORMATXDVI = -paper a4r -s 4					@@\
    FORMATDVIPS = -t a4 -t landscape					@@\
FORMATGHOSTVIEW = -a4 -landscape
#endif /* PaperFormatA4R */


#ifndef PaperFormatLetterR
#define PaperFormatLetterR()						@@\
    FORMATXDVI = -paper usr -s 4					@@\
    FORMATDVIPS = -t letter -t landscape				@@\
FORMATGHOSTVIEW = -letter -landscape
#endif /* PaperFormatLetterR */




/* Picture convertion: */

#ifndef GifToEpsFilter
#define GifToEpsFilter   (giftoppm | ppmtopgm | pnmtops -noturn -rle)
#endif /* GifToEpsFilter */

#ifndef GifbwToEpsFilter
#define GifbwToEpsFilter (giftoppm | ppmtopgm | pgmtopbm | pnmtops -noturn -rle)
#endif /* GifbwToEpsFilter */

#ifndef TiffToEpsFilter
#define TiffToEpsFilter   (tifftopnm | pnmtops -noturn -rle)
#endif /* TiffToEpsFilter */

#ifndef FigToEpsFilter
#define FigToEpsFilter (fig2dev -L ps | sed -e 's/setgray fill/setgray eofill/g')
#endif /* FigToEpsFilter */

#ifndef TgifToEpsCmd
#define TgifToEpsCmd(file) tgif -print -eps file
#endif /* TgifToEpsCmd */

  GIFTOEPS = GifToEpsFilter
GIFBWTOEPS = GifbwToEpsFilter
 TIFFTOEPS = TiffToEpsFilter
  FIGTOEPS = FigToEpsFilter

#ifndef GifToEpsRule
#define GifToEpsRule()							@@\
.SUFFIXES: .gif .eps							@@\
.gif.eps:								@@\
	$(GIFTOEPS) <$*.gif >$*.eps
#endif /* GifToEpsRule */

#ifndef GifBwToEpsRule
#define GifBwToEpsRule()						@@\
.SUFFIXES: .gif-bw .eps							@@\
.gif-bw.eps:								@@\
	$(GIFBWTOEPS) <$*.gif-bw >$*.eps
#endif /* GifBwToEpsRule */

#ifndef TiffToEpsRule
#define TiffToEpsRule()							@@\
.SUFFIXES: .tif .tiff .eps						@@\
.tif.eps:								@@\
	$(TIFFTOEPS) <$*.tif >$*.eps					@@\
									@@\
.tiff.eps:								@@\
	$(TIFFTOEPS) <$*.tiff >$*.eps
#endif /* TiffToEpsRule */

#ifndef FigToEpsRule
#define FigToEpsRule()							@@\
.SUFFIXES: .fig .eps							@@\
.fig.eps:								@@\
	$(FIGTOEPS) <$*.fig >$*.eps
#endif /* FigToEpsRule */

#ifndef TgifToEpsRule
#define TgifToEpsRule()							@@\
.SUFFIXES: .obj .eps							@@\
.obj.eps:								@@\
	TgifToEpsCmd($*)
#endif /* TgifToEpsRule */


#ifndef EpsRules
#define EpsRules()							@@\
GifToEpsRule()								@@\
GifBwToEpsRule()							@@\
TiffToEpsRule()								@@\
FigToEpsRule()								@@\
TgifToEpsRule()
#endif /* EpsRules */


#ifndef EpsObject
#define EpsObject(file) file.eps
#endif /* EpsObject */


#ifndef EpsTarget
#define EpsTarget(epsfile)						@@\
AllTarget(epsfile.eps)						   	@@\
									@@\
clean::									@@\
	$(RM) epsfile.eps
#endif /* EpsTarget */



/* Default values for converters and viewers */

#ifndef DviToPsfigCmd
#define DviToPsfigCmd dvi2prt
#endif
#ifndef DviToPsfigOpt
#define DviToPsfigOpt /**/
#endif
#ifndef DviToPsCmd
#define DviToPsCmd dvips
#endif
#ifndef DviToPsOpt
#define DviToPsOpt $(FORMATDVIPS) -f
#endif
#ifndef ViewDviCmd
#define ViewDviCmd xdvi
#endif
#ifndef ViewDviOpt
#define ViewDviOpt $(FORMATXDVI)
#endif
#ifndef ViewPsCmd
#define ViewPsCmd ghostview
#endif
#ifndef ViewPsOpt
#define ViewPsOpt $(FORMATGHOSTVIEW)
#endif

DVITOPSFIGCMD = DviToPsfigCmd
DVITOPSFIGOPT = DviToPsfigOpt
   DVITOPSCMD = DviToPsCmd
   DVITOPSOPT = DviToPsOpt
   VIEWDVICMD = ViewDviCmd
   VIEWDVIOPT = ViewDviOpt
    VIEWPSCMD = ViewPsCmd
    VIEWPSOPT = ViewPsOpt



/* Default value for the "make depend" search pattern */

#ifndef TexDependPattern
#define TexDependPattern \
-e '/\\psfig/ s/^.*figure=\([^,}]*\).*/\1/p' \
-e '/\\epsffile/ s/.*epsffile *{\([^}]*\)}.*/\1/p' \
-e '/\\input/ s/.*input *{\([^}]*\.tex\)}.*/\1/p' \
-e '/\\verbfile/ s/.*verbfile {\([^}]*\.tex\)}.*/\1/p' \
-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*.tex\)}.*/\1/p' \
-e '/\\input/ s/.*input *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\include/ s/.*include *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\verbfile/ s/.*verbfile *{\([^}]*\)}.*/\1.tex/p' \
-e '/\\blackandwhite/ s/.*blackandwhite *{\([^}]*\)}.*/\1.tex/p'
#endif /* TexDependPattern */

TEXDEPENDPATTERN = TexDependPattern




TEXDEFAULTINPUTS = .:TEX_INPUTSDIR
TEXINPUTS = $(TEXDEFAULTINPUTS)


#ifndef ExportTexInputs
#define ExportTexInputs() \
	if [ "$(TEXINPUTS)" != "" ]; then \				@@\
	    TEXINPUTS=$(TEXINPUTS); \					@@\
	    export TEXINPUTS; \						@@\
	fi
#endif /* ExportTexInputs */


#ifndef InitialTexRun
#define InitialTexRun(texfile,deps,processor) ExportTexInputs(); \  	@@\
	if [ -f texfile.aux ]; then \					@@\
	    (set -x; $(CP) texfile.aux texfile.aux-old); \		@@\
	fi; \								@@\
	if [ ! -f deps ]; then \					@@\
	    (set -x; processor texfile.tex); \				@@\
	fi
#endif /* InitialTexRun */


#ifndef BreakIfExpress
#define BreakIfExpress() \
	if [ "$${TEXDRAFT=Draft}" != "Draft" -a \			@@\
	"`find . -newer $*.tex -name $*.dvi -print`" != "" ]; then \	@@\
	    echo ""; \						   	@@\
	    echo "*** I have created a draft version of your document's"; \ @@\
	    echo "*** DVI file. If you want a tidy one, remove the"; \	@@\
	    echo "*** TEXDRAFT environment variable resp. make macro."; \ @@\
	    echo ""; \							@@\
	    exit; \							@@\
	fi
#endif /* BreakIfExpress */


#ifndef BibtexRule
#define BibtexRule(texfile,bibtexLibrary,processor)			@@\
texfile.bbl:: bibtexLibrary texfile.tex					@@\
	@InitialTexRun(texfile,texfile.aux,processor); \		@@\
	if (set -x; bibtex texfile); then \				@@\
	    echo "Nothing" >/dev/null; \				@@\
	else \								@@\
	    (set -x; $(RM) texfile.bbl); \				@@\
	    exit 1; \							@@\
	fi
#endif /* BibtexRule */


#ifndef MakeindexRule
#define MakeindexRule(texfile,deps)					@@\
texfile.ind:: texfile.tex deps						@@\
	@InitialTexRun(texfile,RunAlways,latex); \			@@\
	(set -x; makeindex texfile) \					@@\
									@@\
texfile.dvi: texfile.ind
#endif /* MakeindexRule */


#ifndef GenericTexRule
#define GenericTexRule(processor)					@@\
.SUFFIXES: .dvi .tex							@@\
.tex.dvi:								@@\
	@ExportTexInputs(); \						@@\
	if [ -f $*.aux ]; then \					@@\
	    (set -x; $(CP) $*.aux $*.aux-old); \			@@\
	fi; \								@@\
	BreakIfExpress(); \						@@\
	if (set -x; processor $*.tex); then \				@@\
	    Result="OK"; \						@@\
	else \								@@\
	    (set -x; $(MV) $*.dvi $*-error.dvi); \			@@\
	    exit 1; \							@@\
	fi; \								@@\
	if [ -f $*.aux -a -f $*.aux-old ]; then \			@@\
	    AuxDiff=`(set -x; diff $*.aux-old $*.aux) | head -1`; \ 	@@\
	fi; \								@@\
	AwkOutput=`awk \						@@\
	'/LaTeX Warning: Label\(s\) may have changed. Rerun to get cross-references right./ {print $$0; exit} \	@@\
	/No file $*.toc./ {print $$0; exit} \				@@\
	/LaTeX Warning: Citation .* on page .* undefined./ {print $$0; exit}' $*.log`; \	@@\
	if [ "$${AwkOutput}$${AuxDiff}" != "" ]; then \			@@\
	    case Rerun$(RerunCount) in \				@@\
		Rerun)  (set -x; $(RM) $*.dvi; \			@@\
			$(MAKE) RerunCount=1 $*.dvi);; \		@@\
		Rerun1) (set -x; $(RM) $*.dvi; \			@@\
			$(MAKE) RerunCount=2 $*.dvi);; \		@@\
		Rerun*) ;; \						@@\
	    esac; \							@@\
	else \								@@\
	    echo "to make Ultrix's make happy" >/dev/null; \		@@\
	fi
#endif /* GenericTexRule */


#ifndef DviTarget
#define DviTarget(texfile,deps,processor)				@@\
texfile.dvi: deps							@@\
AllTarget(texfile.dvi)
#endif /* DviTarget */


#ifndef DviOutputTarget
#define DviOutputTarget(texfile)					@@\
dvi:: texfile.dvi							@@\
									@@\
viewdvi:: texfile.dvi							@@\
	$(VIEWDVICMD) $(VIEWDVIOPT) texfile.dvi &
#endif /* DviOutputTarget */


#ifndef PostscriptOutputTarget
#define PostscriptOutputTarget(texfile)					@@\
texfile.ps:: texfile.dvi						@@\
	$(DVITOPSCMD) $(DVITOPSOPT) texfile.dvi >texfile.ps		@@\
									@@\
ps:: texfile.ps								@@\
									@@\
postscript:: texfile.ps							@@\
									@@\
viewps:: texfile.ps							@@\
	$(VIEWPSCMD) $(VIEWPSOPT) texfile.ps &
#endif /* PostscriptOutputTarget */


#ifndef DvipsfigOutputTarget
#define DvipsfigOutputTarget(texfile)					@@\
texfile.dvipsfig:: texfile.dvi					   	@@\
	$(DVITOPSFIGCMD) $(DVITOPSFIGOPT) texfile.dvi >texfile.dvipsfig	@@\
									@@\
dvipsfig:: texfile.dvipsfig
#endif /* DvipsfigOutputTarget */


#ifndef TexCleanTarget
#define TexCleanTarget(texfile)						@@\
clean::									@@\
	$(RM) texfile.aux texfile.aux-old texfile.blg \			@@\
	      texfile.dvipsfig texfile.ilg texfile.log texfile.ps \ 	@@\
	      texfile.toc texfile-error.dvi				@@\
									@@\
veryclean:: clean							@@\
	$(RM) texfile.bbl texfile.dvi texfile.idx texfile.ind
#endif /* TexCleanTarget */


#ifndef TexDependTarget
#define TexDependTarget(texfile)					@@\
depend::								@@\
	@$(MV) Makefile Makefile.bak; \					@@\
	wa=texfile; \							@@\
	sed -e '/^# DO NOT DELETE/,$$ d' \				@@\
	    -e "/^# TEXDEPEND DO NOT DELETE - $$wa/,$$ d" \		@@\
	    Makefile.bak > Makefile; \					@@\
	echo "# TEXDEPEND DO NOT DELETE - $$wa" >> Makefile; \      	@@\
	todo=texfile.tex; \						@@\
	seen=""; \							@@\
	texinputs=`eval echo $(TEXINPUTS) | sed -e 's/:/ /g'`; \    	@@\
	echo "Recognized dependencies:"; \				@@\
	while [ -n "$$todo" ]; do \					@@\
	    for cur_file in $$todo; do \				@@\
		deps=`sed -n $(TEXDEPENDPATTERN) $$cur_file`; \     	@@\
		deps_tmp=""; \						@@\
		for dep_file in $${deps}; do \				@@\
		    found=false; \					@@\
		    for i in $${seen}; do \				@@\
			if [ "$${dep_file}" = "$${i}" ]; then \     	@@\
			    found=true; \				@@\
			    break; \					@@\
			fi; \						@@\
		    done; \						@@\
		    if [ "$${found}" = "false" ]; then \		@@\
			seen="$${seen} $${dep_file}"; \			@@\
		    else \						@@\
			continue; \					@@\
		    fi; \						@@\
		    for dir in $${texinputs}; do \			@@\
			if [ -f $$dir/$$dep_file ]; then \		@@\
			    deps_tmp="$${deps_tmp} $${dir}/$${dep_file}"; \ @@\
			    echo "$${dir}/$${dep_file}"; \		@@\
			    found=true; \				@@\
			    break; \					@@\
			fi; \						@@\
		    done; \						@@\
		    if [ "$${found}" = "false" ]; then \		@@\
			echo "Warning: $${dep_file} not found"; \   	@@\
		    fi; \						@@\
		done; \							@@\
		deps="$${deps_tmp}"; \					@@\
		for e in dvi; do \					@@\
		    for j in $${deps}; do \				@@\
			wa=texfile; \					@@\
			echo "$$wa.$$e: $$j" >> Makefile; \		@@\
		    done; \						@@\
		done; \							@@\
		todo_tmp="$$todo_tmp $$deps"; \				@@\
	    done; \							@@\
	    todo=$$todo_tmp; \						@@\
	    todo_tmp=""; \						@@\
	done; \								@@\
	sed -n -e '/^# DO NOT DELETE/,$$ p' Makefile.bak >> Makefile
#endif  /* TexDependTarget */




/*
 * NormalTexTarget
 */
#ifndef NormalTexTarget
#define NormalTexTarget(texfile,deps,processor)				@@\
DviTarget(texfile,deps,processor)					@@\
DviOutputTarget(texfile)						@@\
DvipsfigOutputTarget(texfile)						@@\
PostscriptOutputTarget(texfile)						@@\
TexCleanTarget(texfile)							@@\
TexDependTarget(texfile)
#endif /* NormalTexTarget */


/*
 * NormalTexBibtexTarget
 */
#ifndef NormalTexBibtexTarget
#define NormalTexBibtexTarget(texfile,deps,bibtexlib,processor)     	@@\
DviTarget(texfile,deps texfile.bbl,processor)				@@\
BibtexRule(texfile,bibtexlib,processor)					@@\
DviOutputTarget(texfile)						@@\
DvipsfigOutputTarget(texfile)						@@\
PostscriptOutputTarget(texfile)						@@\
TexCleanTarget(texfile)							@@\
TexDependTarget(texfile)
#endif /* NormalTexBibtexTarget */



/*
 * User-usable rules start here
 */

/*
 * NormalLatexRule - This rule must be used in Imakefiles describing one or
 *		   more LaTeX documents.
 */
#ifndef NormalLatexRule
#define NormalLatexRule() GenericTexRule(latex)
#endif /* NormalLatexRule */


/*
 * Normal...Target rules describe LaTeX documents using input files not
 * found by "make depend". Contrary to the Simple...Target rules there may
 * be more than one Normal...Target per Imakefile. However, the rule
 * NormalLatexRule() resp. NormalSlitexRule() must always be coded
 * explicitly.
 */

/*
 * NormalLatexTarget - for a LaTeX document with input files not found by
 *		     "make depend"
 */
#ifndef NormalLatexTarget
#define NormalLatexTarget(texfile,deps)					@@\
NormalTexTarget(texfile,deps,latex)
#endif /* NormalLatexTarget */


/*
 * NormalLatexIndexTarget - for a LaTeX document with an index and with input
 *			  files not found by "make depend"
 */
#ifndef NormalLatexIndexTarget
#define NormalLatexIndexTarget(texfile,deps)				@@\
MakeindexRule(texfile,deps)						@@\
NormalTexTarget(texfile,deps,latex)
#endif /* NormalLatexIndexTarget */


/*
 * NormalLatexBibtexTarget - for a LaTeX document with a bibliography created
 *			   by bibtex and with input files not found by
 *			   "make depend"
 */
#ifndef NormalLatexBibtexTarget
#define NormalLatexBibtexTarget(texfile,deps,bibtexlib)			@@\
NormalTexBibtexTarget(texfile,deps,bibtexlib,latex)
#endif /* NormalLatexBibtexTarget */


/*
 * NormalLatexBibtexIndexTarget - for a LaTeX document with a bibliography
 *				created by bibtex, with an index, and with
 *				input files not found by "make depend"
 */
#ifndef NormalLatexBibtexIndexTarget
#define NormalLatexBibtexIndexTarget(texfile,deps,bibtexlib)		@@\
MakeindexRule(texfile,deps)						@@\
NormalTexBibtexTarget(texfile,deps,bibtexlib,latex)
#endif /* NormalLatexBibtexIndexTarget */


/*
 * NormalLatexIndexBibtexTarget - the same as NormalLatexBibtexIndexTarget
 *				(for those who do not want to remember any
 *				particular order)
 */
#ifndef NormalLatexIndexBibtexTarget
#define NormalLatexIndexBibtexTarget(texfile,deps,bibtexlib)		@@\
NormalLatexBibtexIndexTarget(texfile,deps,bibtexlib)
#endif /* NormalLatexIndexBibtexTarget */


/*
 * Simple...Target rules are somewhat simpler :-) than Normal...Target
 * rules: All input file (if any) used in the document are found by "make
 * depend", the Imakefile describes a single document only, and you do not
 * need to code the NormalLatexRule() resp. NormalSlitexRule() explicitly.
 */

/*
 * SimpleLatexTarget - for a LaTeX document
 */
#ifndef SimpleLatexTarget
#define SimpleLatexTarget(texfile)					@@\
NormalLatexRule()							@@\
NormalLatexTarget(texfile,)
#endif /* SimpleLatexTarget */


/*
 * SimpleLatexIndexTarget - for a LaTeX document with an index
 */
#ifndef SimpleLatexIndexTarget
#define SimpleLatexIndexTarget(texfile)					@@\
NormalLatexRule()							@@\
MakeindexRule(texfile,)							@@\
NormalTexTarget(texfile,,latex)
#endif /* SimpleLatexIndexTarget */


/*
 * SimpleLatexBibtexTarget - for a LaTeX document with a bibliography created
 *			   by bibtex
 */
#ifndef SimpleLatexBibtexTarget
#define SimpleLatexBibtexTarget(texfile,bibtexlib)			@@\
NormalLatexRule()							@@\
NormalTexBibtexTarget(texfile,,bibtexlib,latex)
#endif /* SimpleLatexBibtexTarget */


/*
 * SimpleLatexBibtexIndexTarget - for a LaTeX document with a bibliography
 *				created by bibtex and with an index
 */
#ifndef SimpleLatexBibtexIndexTarget
#define SimpleLatexBibtexIndexTarget(texfile,bibtexlib)			@@\
NormalLatexRule()							@@\
MakeindexRule(texfile,)							@@\
NormalTexBibtexTarget(texfile,,bibtexlib,latex)
#endif /* SimpleLatexBibtexIndexTarget */


/*
 * SimpleLatexIndexBibtexTarget - the same as SimpleLatexBibtexIndexTarget
 *				(for those who do not want to remember any
 *				particular order)
 */
#ifndef SimpleLatexIndexBibtexTarget
#define SimpleLatexIndexBibtexTarget(texfile,bibtexlib)			@@\
SimpleLatexBibtexIndexTarget(texfile,bibtexlib)
#endif /* SimpleLatexIndexBibtexTarget */



/* The same for SLITeX: */

/*
 * NormalSlitexRule - This rule must be used in Imakefiles describing one or
 *		    more SLITeX documents.
 */
#ifndef NormalSlitexRule
#define NormalSlitexRule() GenericTexRule(slitex)
#endif /* NormalSlitexRule */


/*
 * NormalSlitexTarget - for a SLITeX document with input files not found by
 *		      "make depend"
 */
#ifndef NormalSlitexTarget
#define NormalSlitexTarget(texfile,deps)				@@\
NormalTexTarget(texfile,deps,slitex)
#endif /* NormalSlitexTarget */


/*
 * NormalSlitexIndexTarget - for a SLITeX document with an index and with input
 *			   files not found by "make depend"
 */
#ifndef NormalSlitexIndexTarget
#define NormalSlitexIndexTarget(texfile,deps)				@@\
MakeindexRule(texfile,deps)						@@\
NormalTexTarget(texfile,deps,slitex)
#endif /* NormalSlitexIndexTarget */


/*
 * NormalSlitexBibtexTarget - for a SLITeX document with a bibliography created
 *			    by bibtex and with input files not found by
 *			    "make depend"
 */
#ifndef NormalSlitexBibtexTarget
#define NormalSlitexBibtexTarget(texfile,deps,bibtexlib)		@@\
NormalTexBibtexTarget(texfile,deps,bibtexlib,slitex)
#endif /* NormalSlitexBibtexTarget */


/*
 * NormalSlitexBibtexIndexTarget - for a SLITeX document with a bibliography
 *				 created by bibtex, with an index, and with
 *				 input files not found by "make depend"
 */
#ifndef NormalSlitexBibtexIndexTarget
#define NormalSlitexBibtexIndexTarget(texfile,deps,bibtexlib)		@@\
MakeindexRule(texfile,deps)						@@\
NormalTexBibtexTarget(texfile,deps,bibtexlib,slitex)
#endif /* NormalSlitexBibtexIndexTarget */


/*
 * NormalSlitexIndexBibtexTarget - the same as NormalSlitexBibtexIndexTarget
 *				 (for those who do not want to remember any
 *				 particular order)
 */
#ifndef NormalSlitexIndexBibtexTarget
#define NormalSlitexIndexBibtexTarget(texfile,deps,bibtexlib)		@@\
NormalSlitexBibtexIndexTarget(texfile,deps,bibtexlib)
#endif /* NormalSlitexIndexBibtexTarget */


/*
 * SimpleSlitexTarget - for a SLITeX document
 */
#ifndef SimpleSlitexTarget
#define SimpleSlitexTarget(texfile)					@@\
NormalSlitexRule()							@@\
NormalSlitexTarget(texfile,)
#endif /* SimpleSlitexTarget */


/*
 * SimpleSlitexIndexTarget - for a SLITeX document with an index
 */
#ifndef SimpleSlitexIndexTarget
#define SimpleSlitexIndexTarget(texfile)				@@\
NormalSlitexRule()							@@\
MakeindexRule(texfile,)							@@\
NormalTexTarget(texfile,,slitex)
#endif /* SimpleSlitexIndexTarget */


/*
 * SimpleSlitexBibtexTarget - for a SLITeX document with a bibliography created
 *			    by bibtex
 */
#ifndef SimpleSlitexBibtexTarget
#define SimpleSlitexBibtexTarget(texfile,bibtexlib)			@@\
NormalSlitexRule()						  	@@\
NormalTexBibtexTarget(texfile,,bibtexlib,slitex)
#endif /* SimpleSlitexBibtexTarget */


/*
 * SimpleSlitexBibtexIndexTarget - for a SLITeX document with a bibliography
 *				 created by bibtex and with an index
 */
#ifndef SimpleSlitexBibtexIndexTarget
#define SimpleSlitexBibtexIndexTarget(texfile,bibtexlib)		@@\
NormalSlitexRule()						  	@@\
MakeindexRule(texfile,)							@@\
NormalTexBibtexTarget(texfile,,bibtexlib,slitex)
#endif /* SimpleSlitexBibtexIndexTarget */


/*
 * SimpleSlitexIndexBibtexTarget - the same as SimpleSlitexBibtexIndexTarget
 *				 (for those who do not want to remember any
 *				 particular order)
 */
#ifndef SimpleSlitexIndexBibtexTarget
#define SimpleSlitexIndexBibtexTarget(texfile,bibtexlib)		@@\
SimpleSlitexBibtexIndexTarget(texfile,bibtexlib)
#endif /* SimpleSlitexIndexBibtexTarget */
