// File          : NonNegativeIntPanel.java
// Description   : Panel for specifying a non-negative integers
// Last Modified : 2012-09-01
// Author        : Nicola L.C. Talbot
//                 http://www.dickimaw-books.com/

/*
    Copyright (C) 2006 Nicola L.C. Talbot

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.jmakepdfx;

import java.awt.*;
import java.awt.event.*;
import java.text.DecimalFormat;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;

/**
 * Panel for specifying a non-negative integers.
 * @author Nicola L C Talbot
 */

public class NonNegativeIntPanel extends JPanel
{
   public NonNegativeIntPanel(String panelLabel, int defValue)
   {
      super();
      setLayout(new BoxLayout(this, BoxLayout.X_AXIS));

      label = new JLabel(Jmakepdfx.getLabel(panelLabel));
      label.setDisplayedMnemonic(
         Jmakepdfx.getMnemonic(panelLabel));

      text = new NonNegativeIntField(defValue);

      add(label);
      add(text);

      label.setLabelFor(text);
   }

   public NonNegativeIntPanel(String panelLabel)
   {
      this(panelLabel, 0);
   }

   public Document getDocument()
   {
      return text.getDocument();
   }

   public NonNegativeIntField getTextField()
   {
      return text;
   }

   public int getValue()
   {
      return text.getValue();
   }

   public void setValue(int val)
   {
      text.setValue(val);
      text.setCaretPosition(0);
   }

   public String getLabelText()
   {
      return label.getText();
   }

   public void setEnabled(boolean flag)
   {
      if (label != null) label.setEnabled(flag);
      text.setEnabled(flag);
   }

   private JLabel label;
   private NonNegativeIntField text;
}
