/* Token.C
 *
 * The text to be parsed is broken into fundamental units called tokens.
 * To parse the LaTeX files, the program interprets and handles these tokens.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include <string.h>
#include <stdio.h>
#include "Operator.h"
#include "Global.h"
#include "Document.h"

/* Gets a new token from the last line read from a file. If no such line 
 * exists, it gets a new line from the open file. If no file is open, it
 * opens a new file. If no more files are left to open, returns failure. */
Token::Token()
{
   _valid = FALSE;
   Global::files->get_token(*this);    // Reads a new token from a file
}

/* Deal correctly with this new token. */
void Token::handle()
{
//   cerr << "Token: " << _text << endl;
   // Look up the appropriate operator from an array of operators.
   Operator *op = Operator::get_operator(_text);
   if(op)
      do
	 op->execute();       // Execute the operator.
      while((++op)->isvalid() && op->match(_text));
   else {
      if(_text[0] == '\\' &&  // Found unknown command and not in a comment
         !Stack::get(Environment::PDocument, Document::Comment, "")) {
         char message[MAXSTRING];  // It's a LaTeX command I don't understand!
	 sprintf(message,"Skipping unknown LaTeX command %s", _text);
         Global::files->warning(message);
         return;
      }
      Operator::plaintext(_text);  // If no operator, it must be plain text.
   }
}

int Token::isvalid()
{
   return(_valid);
}

void Token::make_text(char *token_text)
{
   strcpy(_text,token_text);
   _valid = TRUE;
}

int Token::match(char *str)
{
   return !strcmp(str,_text);
}

char *Token::get_text()
{
   return _text;
}
