/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge;

import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.merge.MergeManager;
import com.izforge.izpack.merge.resolve.PathResolver;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.zip.ZipOutputStream;

public class MergeManagerImpl
implements MergeManager {
    private List<Mergeable> mergeableList;
    private PathResolver pathResolver;

    public MergeManagerImpl(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
        this.mergeableList = new ArrayList<Mergeable>();
    }

    @Override
    public void addResourceToMerge(Mergeable mergeable) {
        this.mergeableList.add(mergeable);
    }

    @Override
    public void addResourceToMerge(String resourcePath) {
        this.mergeableList.addAll(this.pathResolver.getMergeableFromPath(resourcePath));
    }

    @Override
    public void addResourceToMerge(String resourcePath, String destination) {
        this.mergeableList.addAll(this.pathResolver.getMergeableFromPath(resourcePath, destination));
    }

    @Override
    public void merge(ZipOutputStream outputStream) {
        for (Mergeable mergeable : this.mergeableList) {
            mergeable.merge(outputStream);
        }
        this.mergeableList.clear();
    }

    @Override
    public void merge(java.util.zip.ZipOutputStream outputStream) {
        for (Mergeable mergeable : this.mergeableList) {
            mergeable.merge(outputStream);
        }
        this.mergeableList.clear();
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        for (Mergeable mergeable : this.mergeableList) {
            result.addAll(mergeable.recursivelyListFiles(fileFilter));
        }
        return result;
    }

    @Override
    public File find(FileFilter fileFilter) {
        for (Mergeable mergeable : this.mergeableList) {
            File file = mergeable.find(fileFilter);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    public String toString() {
        return "MergeManagerImpl{mergeableList=" + this.mergeableList + ", pathResolver=" + this.pathResolver + '}';
    }
}

