/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.data;

import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultVariables
implements Variables {
    private final Properties properties;
    private List<DynamicVariable> dynamicVariables = new ArrayList<DynamicVariable>();
    private final VariableSubstitutor replacer;
    private RulesEngine rules;
    private transient Map<String, Deque<Object>> blockedVariableNameStacks = new HashMap<String, Deque<Object>>();
    private static final Logger logger = Logger.getLogger(DefaultVariables.class.getName());

    public DefaultVariables() {
        this(new Properties());
    }

    public DefaultVariables(Properties properties) {
        this.properties = properties;
        this.replacer = new VariableSubstitutorImpl(properties);
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    @Override
    public void set(String name, String value) {
        if (value != null) {
            this.properties.setProperty(name, value);
            logger.fine("Dynamic variable '" + name + "' set to '" + value + "'");
        } else {
            this.properties.remove(name);
            logger.fine("Dynamic variable '" + name + "' unset");
        }
    }

    @Override
    public String get(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public String get(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, -1);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        int result = defaultValue;
        String value = this.get(name);
        if (value != null) {
            try {
                result = Integer.valueOf(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, -1L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        long result = defaultValue;
        String value = this.get(name);
        if (value != null) {
            try {
                result = Long.valueOf(value);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String replace(String value) {
        if (value != null) {
            try {
                value = this.replacer.substitute(value);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        return value;
    }

    @Override
    public synchronized void add(DynamicVariable variable) {
        this.dynamicVariables.add(variable);
    }

    @Override
    public synchronized void refresh() throws InstallerException {
        int maxCount;
        logger.fine("Refreshing dynamic variables");
        HashSet<DynamicVariable> checkedVariables = new HashSet<DynamicVariable>();
        Properties setVariables = new Properties();
        HashSet<String> unsetVariables = new HashSet<String>();
        int count = maxCount = 10 * this.dynamicVariables.size() + 1;
        boolean changed = true;
        while (changed) {
            changed = false;
            if (--count < 0) {
                throw new InstallerException(String.format("Refresh of dynamic variables seem to produce a loop. Stopped after %1s iterations. (Maybe a cyclic dependency of variables?)", maxCount));
            }
            for (DynamicVariable variable : this.dynamicVariables) {
                String name = variable.getName();
                if (!this.isBlockedVariableName(name)) {
                    String conditionId = variable.getConditionid();
                    if (conditionId == null || this.rules.isConditionTrue(conditionId)) {
                        if (!variable.isCheckonce() || !variable.isChecked()) {
                            String newValue;
                            try {
                                newValue = variable.evaluate(this.replacer);
                            }
                            catch (IzPackException exception) {
                                throw exception;
                            }
                            catch (Exception exception) {
                                throw new IzPackException("Failed to refresh dynamic variable (" + name + ")", exception);
                            }
                            if (newValue == null) {
                                if (variable.isAutoUnset()) {
                                    unsetVariables.add(name);
                                }
                            } else {
                                setVariables.put(name, newValue);
                            }
                            if (newValue != null && !newValue.contains("$")) {
                                variable.setChecked();
                                continue;
                            }
                            checkedVariables.add(variable);
                            continue;
                        }
                        String oldvalue = this.properties.getProperty(name);
                        if (oldvalue == null) continue;
                        setVariables.put(name, oldvalue);
                        continue;
                    }
                    if (!variable.isAutoUnset()) continue;
                    unsetVariables.add(name);
                    continue;
                }
                logger.fine("Dynamic variable '" + name + "' blocked from changing due to user input");
            }
            for (String key : unsetVariables) {
                if (setVariables.containsKey(key) || this.get(key) == null) continue;
                changed = true;
                this.set(key, null);
            }
            for (String key : setVariables.stringPropertyNames()) {
                String newValue = setVariables.getProperty(key);
                String oldValue = this.get(key);
                if (oldValue != null && oldValue.equals(newValue)) continue;
                changed = true;
                this.set(key, newValue);
            }
        }
        for (DynamicVariable variable : checkedVariables) {
            variable.setChecked();
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void registerBlockedVariableNames(Set<String> names, Object blocker) {
        if (names != null) {
            for (String name : names) {
                Deque<Object> blockerStack = this.blockedVariableNameStacks.get(name);
                if (blockerStack == null) {
                    blockerStack = new ArrayDeque<Object>();
                }
                blockerStack.push(blocker);
                this.blockedVariableNameStacks.put(name, blockerStack);
            }
        }
    }

    @Override
    public void unregisterBlockedVariableNames(Set<String> names, Object blocker) {
        if (names != null) {
            for (String name : names) {
                Deque<Object> blockerStack = this.blockedVariableNameStacks.get(name);
                if (blockerStack == null) continue;
                blockerStack.remove(blocker);
            }
        }
    }

    @Override
    public boolean isBlockedVariableName(String name) {
        Deque<Object> blockerStack = this.blockedVariableNameStacks.get(name);
        return blockerStack != null && !blockerStack.isEmpty();
    }
}

