/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.path.PathInputBase;
import com.izforge.izpack.panels.path.PathInputConsolePanel;
import com.izforge.izpack.panels.target.TargetPanelAutomation;
import com.izforge.izpack.panels.target.TargetPanelHelper;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;

public class TargetConsolePanel
extends PathInputConsolePanel
implements ConsolePanel {
    private final InstallData installData;

    public TargetConsolePanel(PanelView<ConsolePanel> panel, InstallData installData, Prompt prompt) {
        super(panel, installData, prompt);
        this.installData = installData;
    }

    @Override
    public boolean generateProperties(InstallData installData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        boolean result = false;
        String path = properties.getProperty("INSTALL_PATH");
        if (path == null || "".equals(path.trim())) {
            System.err.println("Missing mandatory target path!");
        } else if (TargetPanelHelper.isIncompatibleInstallation(path, installData.getInfo().isReadInstallationInformation())) {
            System.err.println(this.getIncompatibleInstallationMsg(installData));
        } else {
            path = installData.getVariables().replace(path);
            installData.setInstallPath(path);
            result = true;
        }
        return result;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        String path;
        this.printHeadLine(installData, console);
        String defaultPath = TargetPanelHelper.getPath(installData);
        PathInputBase.setInstallData(installData);
        if (defaultPath == null) {
            defaultPath = "";
        }
        while ((path = console.promptLocation(installData.getMessages().get("TargetPanel.info", new Object[0]) + " [" + defaultPath + "] ", defaultPath)) != null) {
            path = installData.getVariables().replace(path);
            String normalizedPath = PathInputBase.normalizePath(path);
            File pathFile = new File(normalizedPath);
            if (TargetPanelHelper.isIncompatibleInstallation(normalizedPath, installData.getInfo().isReadInstallationInformation())) {
                console.println(this.getIncompatibleInstallationMsg(installData));
                continue;
            }
            if (!PathInputBase.isWritable(normalizedPath)) {
                console.println(installData.getMessages().get("UserPathPanel.notwritable", new Object[0]));
                continue;
            }
            if (!normalizedPath.isEmpty()) {
                if (pathFile.isFile()) {
                    console.println(installData.getMessages().get("PathInputPanel.isfile", new Object[0]));
                    continue;
                }
                if (pathFile.exists()) {
                    if (!this.checkOverwrite(pathFile, console)) {
                        continue;
                    }
                } else {
                    if (!this.checkCreateDirectory(pathFile, console)) continue;
                    if (!installData.getPlatform().isValidDirectoryPath(pathFile)) {
                        console.println(installData.getMessages().get("TargetPanel.syntax.error", new Object[0]));
                        continue;
                    }
                }
                installData.setInstallPath(normalizedPath);
                return this.promptEndPanel(installData, console);
            }
            return this.run(installData, console);
        }
        return false;
    }

    private String getIncompatibleInstallationMsg(InstallData installData) {
        return installData.getMessages().get("TargetPanel.incompatibleInstallation", new Object[0]);
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new TargetPanelAutomation().createInstallationRecord(this.installData, panelRoot);
    }
}

