/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.undo.UndoManager;

public class EditorFilter
extends DocumentFilter {
    String[] keywords = new String[]{"beginfig", "endfig", "for", "draw", "drawarrow", "endfor", "def", "vardef", "enddef", "if", "fi", "withcolor", "fill", "shifted", "scaled", "rotated", "withpen"};
    String[] datatypes = new String[]{"picture", "numeric", "path", "pair", "transform", "color", "string", "boolean", "pen"};
    int fontSize = 14;
    HashMap<String, SimpleAttributeSet> tokenToAset;
    JTextPane editor;
    JButton saveButton;

    public EditorFilter(JTextPane jTextPane, JButton jButton) {
        this.editor = jTextPane;
        this.saveButton = jButton;
        this.tokenToAset = new HashMap();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.BLUE);
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setFontSize(simpleAttributeSet, this.fontSize);
        this.tokenToAset.put("keyword", simpleAttributeSet);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.GREEN);
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setFontSize(simpleAttributeSet, this.fontSize);
        this.tokenToAset.put("digits", simpleAttributeSet);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.BLACK);
        StyleConstants.setBold(simpleAttributeSet, false);
        StyleConstants.setFontSize(simpleAttributeSet, this.fontSize);
        this.tokenToAset.put("normal", simpleAttributeSet);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.GREEN);
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setFontSize(simpleAttributeSet, this.fontSize);
        this.tokenToAset.put("datatype", simpleAttributeSet);
        simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.MAGENTA);
        StyleConstants.setBold(simpleAttributeSet, true);
        StyleConstants.setFontSize(simpleAttributeSet, this.fontSize);
        this.tokenToAset.put("quoted", simpleAttributeSet);
        this.editor.setFont(new Font("Monospaced", 0, this.fontSize));
        final UndoManager undoManager = new UndoManager();
        this.editor.getDocument().addUndoableEditListener(undoManager);
        this.editor.getInputMap().put(KeyStroke.getKeyStroke("ctrl Z"), "undo");
        this.editor.getActionMap().put("undo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    undoManager.undo();
                }
                catch (Throwable throwable) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
        this.editor.getInputMap().put(KeyStroke.getKeyStroke("ctrl R"), "redo");
        this.editor.getActionMap().put("redo", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    undoManager.redo();
                }
                catch (Throwable throwable) {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
        this.saveButton.setEnabled(true);
        this.highlightAndInsert(filterBypass, n, string);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        this.saveButton.setEnabled(true);
        super.remove(filterBypass, n, n2);
        this.highlightAndInsert(filterBypass, n, string);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
        this.saveButton.setEnabled(true);
        boolean bl = filterBypass.getDocument().getText(n, n2).trim().isEmpty();
        super.remove(filterBypass, n, n2);
        String string = "";
        String string2 = "";
        try {
            String string3;
            string = this.indent(n, false);
            string2 = this.indent(n, true);
            int n3 = n - string.length() - 1;
            String string4 = string3 = n3 < 0 ? "" : this.editor.getDocument().getText(n3, 1);
            if (bl && string.length() > 0 && (string3.isEmpty() || string3.equals("\n"))) {
                super.remove(filterBypass, n3 + 1, string.length());
                super.insertString(filterBypass, n3 + 1, string2, this.tokenToAset.get("normal"));
            } else if (n > 0) {
                this.highlightAndInsert(filterBypass, n, "");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void highlightAndInsert(DocumentFilter.FilterBypass filterBypass, int n, String string) throws BadLocationException {
        Object object;
        int n2;
        if (string.length() == 1 && string.charAt(0) == '\n') {
            String string2 = "";
            try {
                string2 = this.indent(n, false);
                super.insertString(filterBypass, n, "\n" + string2, this.tokenToAset.get("normal"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        String string3 = "";
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': {
                    string3 = string3 + "    ";
                    continue block5;
                }
                default: {
                    string3 = string3 + c;
                }
            }
        }
        int n3 = n;
        if (string3.isEmpty() || !Character.isWhitespace(string3.charAt(0))) {
            --n3;
            while (n3 >= 0 && !Character.isWhitespace((char)(n2 = filterBypass.getDocument().getText(n3, 1).charAt(0)))) {
                --n3;
            }
            ++n3;
        }
        String string4 = filterBypass.getDocument().getText(n3, n - n3);
        if (string3.isEmpty() || !Character.isWhitespace(string3.charAt(string3.length() - 1))) {
            char c;
            int n4 = filterBypass.getDocument().getLength();
            for (n2 = n; n2 < n4 && !Character.isWhitespace(c = filterBypass.getDocument().getText(n2, 1).charAt(0)); ++n2) {
            }
        }
        String string5 = filterBypass.getDocument().getText(n, n2 - n);
        super.remove(filterBypass, n -= string4.length(), string4.length() + string5.length());
        String[] stringArray = string3.split(" ", -1);
        stringArray[0] = string4 + stringArray[0];
        int n5 = stringArray.length - 1;
        stringArray[n5] = stringArray[n5] + string5;
        string3 = string4 + string3 + string5;
        String string6 = "normal";
        if (n > 0 && ((Color)(object = StyleConstants.getForeground(this.editor.getStyledDocument().getCharacterElement(n - 1).getAttributes()))).equals(StyleConstants.getForeground(this.tokenToAset.get("quoted")))) {
            string6 = "quoted";
        }
        object = "";
        string3 = string3 + '\u0000';
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            String string7 = "normal";
            if (c == '\u0000') {
                string7 = "done";
            } else if (string6.equals("quoted") || string6.equals("lquote")) {
                string7 = c == '\"' ? "rquote" : "quoted";
            } else if (Character.isDigit(c)) {
                string7 = "digits";
            } else if (Character.isLetter(c)) {
                string7 = "word";
            } else if (c == '\"') {
                string7 = "lquote";
            }
            if (!string6.equals(string7)) {
                String string8 = "normal";
                if (string6.equals("digits")) {
                    string8 = "digits";
                } else if (string6.equals("word") && this.isKeyword((String)object)) {
                    string8 = "keyword";
                } else if (string6.equals("word") && this.isDatatype((String)object)) {
                    string8 = "datatype";
                } else if (string6.equals("quoted")) {
                    string8 = "quoted";
                }
                super.insertString(filterBypass, n, (String)object, this.tokenToAset.get(string8));
                n += ((String)object).length();
                string6 = string7;
                object = "";
            }
            object = (String)object + c;
        }
        this.editor.setCaretPosition(n - string5.length());
    }

    private String indent(int n, boolean bl) throws BadLocationException {
        int n2;
        int n3 = n;
        int n4 = -1;
        for (n2 = n - 1; n2 >= 0; --n2) {
            char c = this.editor.getText(n2, 1).charAt(0);
            if (c == '\n') {
                int n5 = n3 - n2 - 1;
                if (!bl || n5 < n4) break;
                if (n4 < 0) {
                    n4 = n5;
                }
                n3 = n2;
            }
            if (Character.isWhitespace(c)) continue;
            n3 = n2;
        }
        return this.editor.getText(n2 + 1, n3 - n2 - 1);
    }

    private boolean isKeyword(String string) {
        for (int i = 0; i < this.keywords.length; ++i) {
            if (!this.keywords[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isDatatype(String string) {
        for (int i = 0; i < this.datatypes.length; ++i) {
            if (!this.datatypes[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

