/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : key.h
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/
#ifndef __KEY_H
#define __KEY_H

#ifndef __MACRO_H
#include "macro.h"
#endif

#ifndef __NOTENAME_H           // Sign
#include "notename.h"
#endif

/****************************************************************************
  class Key
--*/

class Key : public Macro 
{
 friend class Transpose;       // to read baseSubstitute
 
protected:
    int flats;
    int sharps;

    void resetAccidentals();
    void setAccidental( const char* name, NESTED_IN( NoteName )Sign sign );
    void setAccidentals();
    void transposeAccidentals( int transpose );
    Key& transposeKey( int transpose, int transposeHeight );
    
public:
    virtual void execute( StringList& parameters, Staff& staff );
    void sustain( int pitch, NESTED_IN( NoteName )Sign sign );

    Key( const char *s, int fl, int sh );
    virtual ~Key();
};

#define ZEROKEY ((Key*)ZERO)
#define NOKEY   (*ZEROKEY)

//-- class Key //

/****************************************************************************
  class Transpose
--*/

class Transpose : public Macro
{
 public:
    virtual void execute( StringList& parameters, Staff& staff );

    Transpose( const char* name );
    virtual ~Transpose();
};
//-- class Transpose //

#endif // __KEY_H //
