/*
 * Decompiled with CFR 0.152.
 */
package pdbf.compilers;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pdbf.PDBF_Compiler;
import pdbf.compilers.HTML_PDF_Compiler;
import pdbf.misc.Tools;
import pdbf.tests.CheckAttached;

public class VM_TAR_Compiler {
    public static DecimalFormat df = new DecimalFormat("0000000000");
    public static String fileType = "ova";
    public static String ova_Header = "%PDF-1.5\n%\u00aa\u00ab\u00ac\u00ad.ovf\u0000\n1337 0 obj\nstream\n<head><meta charset=UTF-8><script>";
    public static String tar_Header = "%PDF-1.5\n%\u00aa\u00ab\u00ac\u00adDO_NOT_DELETE\u0000\n1337 0 obj\nstream\n<head><meta charset=UTF-8><script>";

    public static void main(String[] args) {
        boolean isVM = fileType.equals("ova");
        if (isVM) {
            System.out.println("Compiling VM...");
        } else {
            System.out.println("Compiling TAR...");
        }
        String a = new File(args[0]).getName();
        if (!a.toLowerCase().endsWith(".html")) {
            System.err.println("Error: Only .html files are supported as first argument!");
            System.exit(1);
        }
        if (!args[1].toLowerCase().endsWith("." + fileType)) {
            System.err.println("Error: Only ." + fileType + " files are supported as second argument!");
            System.exit(1);
        }
        String basename = args[0].substring(0, args[0].length() - 5);
        if (CheckAttached.checkAttached(new File(args[0]))) {
            System.err.println("Error: This PDBF file has already an tar or ova file attached!");
            System.exit(1);
        }
        try {
            String replaceInOvaOrTar;
            RandomAccessFile outFile = new RandomAccessFile(new File(String.valueOf(basename) + "." + fileType), "rw");
            outFile.setLength(0L);
            String removeFromPdbf = "%PDF-1.5\n" + HTML_PDF_Compiler.pdfHTML_Header;
            String addToPdbf = "</script>";
            RandomAccessFile ovaOrTarFile = new RandomAccessFile(new File(args[1]), "rw");
            RandomAccessFile pdbfFile = new RandomAccessFile(new File(args[0]), "rw");
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMinimumFractionDigits(2);
            long totalRemaining = ovaOrTarFile.length() + pdbfFile.length() + (long)addToPdbf.length() - (long)removeFromPdbf.length() + 512L;
            if (isVM) {
                replaceInOvaOrTar = ova_Header;
                ovaOrTarFile.seek(replaceInOvaOrTar.length());
                outFile.write(replaceInOvaOrTar.getBytes(StandardCharsets.ISO_8859_1));
            } else {
                replaceInOvaOrTar = "";
                byte[] b = new byte[512];
                ovaOrTarFile.read(b, 0, b.length);
                StringBuilder tarHeader = new StringBuilder(new String(b, StandardCharsets.ISO_8859_1));
                tarHeader.replace(0, tar_Header.length(), tar_Header);
                tarHeader.replace(156, 157, "0");
                VM_TAR_Compiler.tarHeaderLength(tarHeader, 0, 0);
                ovaOrTarFile.seek(0L);
                outFile.write(tarHeader.toString().getBytes(StandardCharsets.ISO_8859_1));
            }
            Pattern p = Pattern.compile("(?:</script>|(?: ?\r| ?\n|\r\n)endstream(?: ?\r| ?\n|\r\n))", 2);
            int halfbuffer = PDBF_Compiler.bytearray.length / 2;
            long remaining = ovaOrTarFile.length() - (long)replaceInOvaOrTar.length();
            int readbytes = (int)Math.min((long)halfbuffer, remaining);
            ovaOrTarFile.readFully(PDBF_Compiler.bytearray, halfbuffer, readbytes);
            remaining -= (long)readbytes;
            outFile.write(PDBF_Compiler.bytearray, halfbuffer, readbytes);
            do {
                System.out.println(String.valueOf(nf.format((double)outFile.length() / (double)totalRemaining)) + " done");
                System.arraycopy(PDBF_Compiler.bytearray, halfbuffer, PDBF_Compiler.bytearray, 0, halfbuffer);
                readbytes = (int)Math.min((long)halfbuffer, remaining);
                ovaOrTarFile.readFully(PDBF_Compiler.bytearray, halfbuffer, readbytes);
                remaining -= (long)readbytes;
                outFile.write(PDBF_Compiler.bytearray, halfbuffer, readbytes);
                String search = new String(PDBF_Compiler.bytearray, StandardCharsets.ISO_8859_1);
                Matcher m = p.matcher(search);
                if (!m.find()) continue;
                if (isVM) {
                    System.err.println("The OVA file cannot be used to generate a pdbf document! Try to change the content of the OVA file such that it doesnt contain the string \"</script>\" or \"endobj\" and then try again.");
                } else {
                    System.err.println("The TAR file cannot be used to generate a pdbf document! You can try to put the data into a compressed fileformat such as tar.gz or zip and then wrap that file again into a tar archive and then try again with that file.");
                }
                outFile.close();
                new File(String.valueOf(basename) + "." + fileType).delete();
                System.exit(1);
            } while (remaining > 0L);
            StringBuilder sb = new StringBuilder(512);
            byte[] tmp = new byte[512];
            long oldPos = outFile.getFilePointer();
            outFile.seek(0L);
            outFile.readFully(tmp);
            sb.append(new String(tmp, StandardCharsets.ISO_8859_1));
            VM_TAR_Compiler.tarHeaderChecksum(sb, 0);
            outFile.seek(0L);
            outFile.write(sb.toString().getBytes(StandardCharsets.ISO_8859_1));
            outFile.seek(oldPos);
            String name = "DO_NOT_DELETE\u0000";
            sb.replace(0, name.length(), name);
            String n = sb.toString();
            long von = outFile.length();
            outFile.write(n.getBytes(StandardCharsets.ISO_8859_1));
            pdbfFile.seek(removeFromPdbf.length());
            long pdbfLength = pdbfFile.length() - (long)removeFromPdbf.length() + (long)addToPdbf.length();
            long vm = outFile.length();
            outFile.write(addToPdbf.getBytes(StandardCharsets.ISO_8859_1));
            remaining = pdbfFile.length() - (long)removeFromPdbf.length();
            readbytes = (int)Math.min((long)halfbuffer, remaining);
            pdbfFile.readFully(PDBF_Compiler.bytearray, halfbuffer, readbytes);
            remaining -= (long)readbytes;
            outFile.write(PDBF_Compiler.bytearray, halfbuffer, readbytes);
            do {
                System.out.println(String.valueOf(nf.format((double)outFile.length() / (double)totalRemaining)) + " done");
                System.arraycopy(PDBF_Compiler.bytearray, halfbuffer, PDBF_Compiler.bytearray, 0, halfbuffer);
                Arrays.fill(PDBF_Compiler.bytearray, halfbuffer, 2 * halfbuffer, (byte)0);
                readbytes = (int)Math.min((long)halfbuffer, remaining);
                pdbfFile.readFully(PDBF_Compiler.bytearray, halfbuffer, readbytes);
                remaining -= (long)readbytes;
                outFile.write(PDBF_Compiler.bytearray, halfbuffer, readbytes);
                String search = new String(PDBF_Compiler.bytearray, StandardCharsets.ISO_8859_1);
                StringBuilder sb2 = new StringBuilder(search);
                int i = sb2.lastIndexOf("%%EOF\n");
                sb2.setLength(i + "%%EOF\n".length());
                long oldLength = sb2.length();
                long offset = vm - (long)removeFromPdbf.length() + (long)addToPdbf.length();
                if (remaining != 0L) continue;
                if (!Tools.fixXref(sb2, offset)) {
                    System.err.println("Fix XREF failed!");
                    System.exit(1);
                }
                outFile.seek(outFile.length() - oldLength);
                i = sb2.lastIndexOf("%%EOF");
                while ((outFile.length() - oldLength + (long)sb2.length()) % 512L != 0L) {
                    sb2.insert(i, '\n');
                }
                outFile.write(sb2.toString().getBytes(StandardCharsets.ISO_8859_1));
                long diffLength = (long)sb2.length() - oldLength;
                VM_TAR_Compiler.tarHeaderLength(sb, 0, (int)(pdbfLength + diffLength));
                VM_TAR_Compiler.tarHeaderChecksum(sb, 0);
                long curPos = outFile.getFilePointer();
                outFile.seek(von);
                outFile.write(sb.toString().getBytes(StandardCharsets.ISO_8859_1));
                outFile.seek(curPos);
            } while (remaining > 0L);
            ovaOrTarFile.close();
            pdbfFile.close();
            outFile.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    static void tarHeaderChecksum(StringBuilder sb, int offset) {
        int checksum = 0;
        sb.setCharAt(offset + 148, ' ');
        sb.setCharAt(offset + 149, ' ');
        sb.setCharAt(offset + 150, ' ');
        sb.setCharAt(offset + 151, ' ');
        sb.setCharAt(offset + 152, ' ');
        sb.setCharAt(offset + 153, ' ');
        sb.setCharAt(offset + 154, ' ');
        sb.setCharAt(offset + 155, ' ');
        int i = 0;
        while (i < 512) {
            checksum += sb.charAt(offset + i);
            ++i;
        }
        String chk = Integer.toOctalString(checksum);
        sb.replace(offset + 148, offset + 155, "0000000");
        sb.replace(offset + 155 - chk.length(), offset + 155, chk);
        sb.setCharAt(offset + 155, '\u0000');
    }

    static void tarPadding(StringBuilder sb) {
        int addZeros = 512 - sb.length() % 512;
        int i = 0;
        while (i < addZeros) {
            sb.append('\u0000');
            ++i;
        }
    }

    static void tarHeaderLength(StringBuilder sb, int offset, int length) {
        sb.replace(offset + 124, offset + 136, "00000000000\u0000");
        String si = Integer.toOctalString(length);
        sb.replace(offset + 135 - si.length(), offset + 135, si);
    }
}

