/*
 * Decompiled with CFR 0.152.
 */
package pdbf.compilers;

import java.io.File;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import pdbf.PDBF_Compiler;
import pdbf.compilers.Pre_Compiler;
import pdbf.misc.Tools;

public class HTML_PDF_Compiler {
    public static String pdfHTML_Header = "%\u00aa\u00ab\u00ac\u00ad<!DOCTYPE html><html dir=\"ltr\" mozdisallowselectionprint moznomarginboxes><head><meta charset=\"utf-8\"><script>\n1337 0 obj\nstream\n</script>\n";

    public static void main(String[] args) {
        String baseDir = Tools.getBaseDir();
        String baseDirData = Tools.getBaseDirData();
        System.out.println("Compiling HTML...");
        String a = new File(args[0]).getName();
        String filename = a.substring(0, a.length() - 4);
        String basename = args[0].substring(0, args[0].length() - 4);
        String pdfname = String.valueOf(baseDir) + filename + ".pdf";
        String outfile = String.valueOf(basename) + ".html";
        try {
            String viewerHEAD = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-head-alasql.html"), Tools.utf8);
            String viewerTAIL = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "template-tail-alasql.html"), Tools.utf8);
            String add = PDBF_Compiler.includeRes ? "</script>" : "</script> <link rel=\"stylesheet\" href=\"viewer.css\"/><link rel=\"stylesheet\" href=\"pivot.css\"/><link rel=\"stylesheet\" href=\"codemirror.css\"/><link rel=\"stylesheet\" href=\"jquery.dataTables.css\"/><link rel=\"stylesheet\" href=\"c3.css\"/><script src=\"lz-string.js\"></script><script src=\"base64.js\"></script><script src=\"d3.js\"></script><script src=\"alasql.js\"></script><script src=\"codemirror-compressed.js\"></script><script src=\"c3.js\"></script><script src=\"excanvas.compiled.js\"></script><script src=\"diff_match_patch.js\"></script><script src=\"jquery-3.0.0-beta1.min.js\"></script><script src=\"pivot.js\"></script><script src=\"jquery-ui-1.9.2.custom.min.js\"></script><script src=\"jquery.dataTables.js\"></script><script src=\"main.js\"></script><script src=\"preMain.js\"></script><script src=\"jstat.js\"></script><script src=\"compatibility.js\"></script><script src=\"l10n.js\"></script><script src=\"pdf.js\"></script><script src=\"pdf.worker.js\"></script><script src=\"viewer.js\"></script>";
            String all = FileUtils.readFileToString(new File(String.valueOf(baseDirData) + "all"), Tools.utf8);
            String preload = FileUtils.readFileToString(new File(String.valueOf(baseDir) + "pdbf-preload"));
            String viewer = String.valueOf(viewerHEAD) + "pdf_base64 = \"" + Tools.encodeFileToBase64Binary(new File(String.valueOf(pdfname.substring(0, pdfname.length() - 4)) + "Embed.pdf")) + "\";\r\n" + "db_base64 = \"\";\r\n" + "json_base64 = \"" + Tools.encodeFileToBase64Binary(new File(String.valueOf(baseDir) + "pdbf-config.json")) + "\";\r\n" + "dbjson_base64 = \"" + Tools.escapeSpecialChars(new File(String.valueOf(baseDir) + "pdbf-db.json")) + "\";\r\n" + preload + "\r\n" + (PDBF_Compiler.includeRes ? String.valueOf(all) + "\r\n" : "") + add + viewerTAIL;
            String insert = String.valueOf(pdfHTML_Header) + viewer + "<script>\n" + "endstream\n" + "endobj\n";
            String pdfcontent = FileUtils.readFileToString(new File(pdfname), StandardCharsets.ISO_8859_1);
            if (pdfcontent.toLowerCase().contains("</script>")) {
                System.err.println("The generated pdf cannot be used to generate a pdbf document! Try to either change some content in your tex file or try to add \\pdfcompresslevel=8 to your tex file.");
                System.exit(1);
            }
            StringBuilder sb = new StringBuilder(pdfcontent);
            int pdfmarker = sb.indexOf("%PDF-");
            int pdfmarkerend = sb.indexOf("\n", pdfmarker);
            sb.insert(pdfmarkerend + 1, insert);
            int offset = insert.length();
            Tools.fixXref(sb, offset);
            FileUtils.writeStringToFile(new File(outfile), sb.toString(), StandardCharsets.ISO_8859_1);
            Pre_Compiler.cleanup(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

