type box = TermBox    of dim * char list
         | NonTermBox of dim * char list
         | ParamBox   of dim * char list
         | OptBox     of dim * box
         | RepBox     of dim * box
         | TermRepBox of dim * box * box
         | OptRepBox  of dim * box
         | OrBoxList  of dim * box list
         | ConBox     of dim * box * box

and dim = {l : float; h : float; lc : float; rc : float}

val dim_l  : box -> float
val dim_h  : box -> float
val dim_lc : box -> float
val dim_rc : box -> float

val of_syntree : float -> float -> float -> float -> float -> Parser.syntree -> box
