/* difficul.c this file is part of the package "plain2latex"
   Copyright (C) 1998 Pedro Fortuny.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file readme.t2l to know how to use this program. And how you
    can support me :-)

    Pedro Fortuny. Dpto. Algebra. Universidad de Valladolid. Spain.
    pfortuny@vax631.cpd.uva.es

*/


/*   this file makes the difficult changes, i. e. those that do not consist
     in simply replacing one word or command by another one.*/
#include <stdio.h>
#include <string.h>



void difficult(FILE *original,char name_of_original[],
               FILE *destination,FILE *replace,FILE *log,char str[],
               int *line_number,int *new_line_number,char last_one[]);
/*  difficult;
    this function takes its name from the fact that it was created to
    make complicate changes and things similar. It is related with all
    the words that appear in "replace.txt" having what may be called
    command symbols, "|", "?", "&", "#"... whose meaning is explained
    in the file "replace.txt". The
    construction is "case by case" so it is not very "optimized".
    in fact, cases like ?, |, # and & are handled by something_between
    braces...*/


int copy_line(FILE *origin,FILE *destinat);
    /* copies a line from origin to destinat. you gessed it */


void something_between_braces(FILE *src, FILE *destination,
                          FILE *log,int *line_number,int *new_line_number,
                          int nbr,int type);
/* this function
   seeks for a number or a word or a whole string -according to the values
   of 'nbr' and 'type'-see rednumber and redword to know what a number or
   a word is in our
   context-. it overreads spaces in src. it copies the spaces
   and the number (word, string) it finds -all between two braces-.
   nbr==1 means: look for a number.
   type==1 means
   that it has to search
   a type of space -f.e. if we are in \hspace, we need a "pt", "cm" or
   something similar.

   type==2 means that it has to look for another type
   of word which is put into the same braces as
   the number. It reports an error if the thing looked for is
   not found.

   this function deals with those words ending with a "|"
   or having '#' in replace.txt -see there for more info. and also
   see principal and replace
   */


void error(char str[],FILE *log,int *line_number,int *new_line_number);
/* generic report of an
   error: the error is str[], it prints the log in the screen (stdout) and
   in the loG FILE. the structure of the error reports is always the same:

    "Error: line %i: %s" where %i is line_number, %s is str[]

*/

void warning(char str[],FILE *log,int *line_number,int *new_line_number);
/*warning: exactly as error */

void eliminate(char name_origin[],FILE *log,char word[],int *line,
               int *new_line_number);
/*eliminate: self-explaining; eliminates a command because it is
useless in LaTeX */


/*here comes the code of the functions */
void difficult(FILE *original,char name_of_original[],
               FILE *destination,FILE *replace,FILE *log,char str[],
               int *line_number,int *new_line_number,char last_one[]){
   char second_parameter[64]; /* the second parameter to search */
   char *place_in_str;        /* for '#' and '!' and '?': where to insert
                                the string to be read */
   char *another_place;       /* auxiliary */
   int i,j;
   int breakoff;
   char environ;

   /* if '||' simply copy the whole line and return */
   if(!strcmp(str,"||\n")){
      copy_line(original,destination);
      if(!feof(original))fwrite("\n",1,1,destination);
      *new_line_number=(*new_line_number)+1;
      fseek(original,-1,SEEK_CUR);
      return;
   }

   /* if there are '&', look for something to be put between braces */
   if(strchr(str,'&')){
     if(str[0]=='?'){  /* this is only to tell the user that the change
                          may be wrong */
       for(i=0;i<64;i++) second_parameter[i]='\0';
       for(i=1;i<=strlen(str);i++)second_parameter[i-1]=str[i];
       strcpy(str,second_parameter);
       warning("command (see next warning) may be wrong",
                              log,line_number,new_line_number);
       warning(str,log,line_number,new_line_number);
     }
     breakoff=1;   /* this is a switch to know if i have to return to principal */

     /* case of '&': look for A SOLE WORD
     which is between braces
     and which has to be put between braces */
     while(strchr(str,'&')){
         place_in_str=strchr(str,'&');
         for(another_place=&str[0];another_place<place_in_str;
             another_place++)
            fwrite(another_place,1,1,destination);
         strcpy(str,place_in_str+1);
         /*now comes a construction which is repeated in all cases:
           read all the spaces (including newlines)
           between the Plain command and the
           next thing
         */
         i=redspaces(original,line_number);
         for(j=0;j<=i-1;j++)fwrite(" ",1,1,destination);
         fread(second_parameter,1,1,original);
         if(second_parameter[0]=='\n'){
           fwrite("\n",1,1,destination);
           *line_number=*line_number+1;
           *new_line_number=(*new_line_number)+1;
           fread(&second_parameter[0],1,1,original);
           }
         /* end of the read-spaces construction */


         if(second_parameter[0]!='{'){
           error("Word between braces needed and not found",log,line_number,
                                            new_line_number);
           fwrite(str,strlen(str)-1,1,destination);
           fseek(original,-1,SEEK_CUR);
           return;
           }
         redword(original,second_parameter);
         fwrite(second_parameter,strlen(second_parameter)-1,1,destination);
         fread(&second_parameter[0],1,1,original);
         if(second_parameter[0]!='}'){
           error("} needed and not found",log,line_number,new_line_number);
           fwrite(str,strlen(str)-1,1,destination);
           fwrite("}",1,1,destination);
           fseek(original,-1,SEEK_CUR);
           }
     }
   fwrite(str,strlen(str)-2,1,destination);
   }



   /* '!' case: here we may have to open an environment */
   if(strchr(str,'!')){
     if(str[0]=='1'){
       environ='1';
       for(i=0;i<65;i++){
          j=i+1;
          str[i]=str[j];
       }
     }
     if(str[0]=='?'){ /* see up: tell the user that the change may be wrong */
       for(i=0;i<64;i++) second_parameter[i]='\0';
       for(i=1;i<=strlen(str);i++)second_parameter[i-1]=str[i];
       strcpy(str,second_parameter);
       warning("command (see next warning) may be wrong",
                              log,line_number,new_line_number);
       warning(str,log,line_number,new_line_number);
     }
     breakoff=1;  /* see up: switch to return */

     /* '!': we have to look for something between braces and put it
        also between braces. the difference between this case and
        '?' is that now we copy anything until we find a closing
        brace -sorry, it stops at the first occurrence...
     */
     while(strchr(str,'!')){
         place_in_str=strchr(str,'!');
         for(another_place=&str[0];another_place<place_in_str;
             another_place++)
            fwrite(another_place,1,1,destination);
         strcpy(str,place_in_str+1);
         /* read spaces -see up */
         i=redspaces(original,line_number);
         fread(&second_parameter[0],1,1,original);
         if(second_parameter[0]=='\n'){
           fwrite("\n",1,1,destination);
           *line_number=*line_number+1;
           *new_line_number=(*new_line_number)+1;
           fread(&second_parameter[0],1,1,original);
           }
         /* end of read spaces */


         if(second_parameter[0]!='{'){
           error("Word between braces needed and not found",log,line_number,
                                            new_line_number);
           fwrite(str,strlen(str)-1,1,destination);
           fseek(original,-1,SEEK_CUR);
           return;
           }
         fread(&second_parameter[0],1,1,original);
         if(environ=='1') i=0;
         /* copy all the things between the braces */
           while(second_parameter[0]!='}'){
             fwrite(&second_parameter[0],1,1,destination);
             if(environ=='1'){
                last_one[i]=second_parameter[0];
                i++;
             }
             fread(&second_parameter[0],1,1,original);
             if(feof(original)){
                 error("BRACE OPENED AND NEVER CLOSED",log,line_number,new_line_number);
                 exit(0); /* critical error:exit */
             }
             if(second_parameter[0]=='\n'){
               *line_number=*line_number+1;
               *new_line_number=(*new_line_number)+1;
             }
           }
         if(environ=='1') environ=='0';
     }
   fwrite(str,strlen(str)-1,1,destination);
   }

   if(breakoff==1) return;
   return;
}

int copy_line(FILE *origin,FILE *destinat){
   char reading_char;
   fread(&reading_char,1,1,origin);
   while(reading_char!='\n' && !feof(origin)){
   fwrite(&reading_char,1,1,destinat);
   fread(&reading_char,1,1,origin);
   }
return(0);
}


/* something_between_braces: does the same as the cases '!' and '&'
   but looking for something which in the original file is NOT between
   braces: typical \include foo
   etc...
*/
void something_between_braces(FILE *src, FILE *destination,
                          FILE *log,int *line_number,int *new_line_number,
                          int nbr,int type){
   char number[]="\n\n\n\n\n\n\n\n\n\n\n\n\n";
   char type_of_thing[]="\n\n\n\n\n\n\n\n\n\n";
   char types[][7]={"pt","cm","mm","in","truecm"};
   char possible_point;
   char one_word[64];
   int nmr_length,i,chr;
   if(nbr!=0)fwrite("*{",2,1,destination);
   else fwrite("{",1,1,destination);
   if(nbr==1){/*the thing is number+sth or only number*/
     chr=redspaces(src,line_number);
     for(i=1;i<=chr;i++)fwrite(" ",1,1,destination);
     nmr_length=rednumber(src,number);
     if(nmr_length==0){
       error("Number needed and not found",log,line_number,new_line_number);
       fwrite("}",1,1,destination);
       return;
     }
     fwrite(number,nmr_length,1,destination);
   }
   if(type==1){ /*the thing is nbr+sth (this case happens only when
                  nbr==1 -see principal- buy migth have more uses*/
     chr=redspaces(src,line_number);
     for(i=1;i<=chr;i++)fwrite(" ",1,1,destination);
     redword(src,type_of_thing);
     if((compare(type_of_thing,types[0])==0 &&  /* see the declarations */
         compare(type_of_thing,types[1])==0 &&  /* these are 'pt', 'cm' */
         compare(type_of_thing,types[2])==0 &&  /* and so on */
         compare(type_of_thing,types[3])==0 &&
         compare(type_of_thing,types[4])==0)){
       error("Type of space not indicated",log,line_number,new_line_number);
       fwrite("}",1,1,destination);
       fseek(src,-(strlen(type_of_thing)-1),SEEK_CUR);
       return;
     }
     fwrite(type_of_thing,strlen(type_of_thing)-1,1,destination);
     fwrite("}",1,1,destination);
   }
/*type==2 we have to read something of the form "word" or "word.dot"
  -the last one for files, f.e.-
  very important: sth may contain one dot: '.' (and only one)
  and if there is one, i suppose it forms part of it
*/
   if(type==2){
     chr=redspaces(src,line_number);
     for(i=1;i<=chr-2;i++)fwrite(" ",1,1,destination);
     redword(src,type_of_thing);
     if(strlen(type_of_thing)<2){
       fwrite(type_of_thing,strlen(type_of_thing)-1,1,destination);
       error("Name needed and not found",log,line_number,new_line_number);
     }
     else{
      for(i=1;i<=chr-1;i++)fwrite(" ",1,1,destination);
      fwrite(type_of_thing,strlen(type_of_thing)-1,1,destination);
      fread(&possible_point,1,1,src);
      if(possible_point=='.'){
        fwrite(".",1,1,destination);
        redword(src,type_of_thing);
        fwrite(type_of_thing,strlen(type_of_thing)-1,1,destination);
      }
      else fseek(src,-1,SEEK_CUR);
     }
     fwrite("}",1,1,destination);
   }
   if(type==3){ /* i have to put between braces something which may begin by*/
                /* \ (backslash) or be already between braces. here we do
                   not allow dots '.' to be in the middle. \hat a
                   is the typical example
                */
     redspaces(src,line_number);
     fread(&one_word[0],1,1,src);
     if(one_word[0]!='\\' && one_word[0]!='{'){
       fseek(src,-1,SEEK_CUR);
       redword(src,one_word);
       fwrite(one_word,strlen(one_word)-1,1,destination);
       fwrite("}",1,1,destination);
       return;
       }
     else{
       if(one_word[0]=='\\'){
          fwrite("\\",1,1,destination);
          redword(src,one_word);
          fwrite(one_word,strlen(one_word)-1,1,destination);
          fwrite("}",1,1,destination);
          return;
         }
       if(one_word[0]=='{'){
          fread(&one_word[0],1,1,src);
          while(one_word[0]!='}'){
            fwrite(&one_word[0],1,1,destination);
            fread(&one_word[0],1,1,src);
          }
          fwrite("}",1,1,destination);
          return;

       }
     }
   }
   return ;
}



void error(char str[],FILE *log,int *line_number,int *new_line_number){
   printf("Error: lines %i-->%i: %s\n",*line_number,*new_line_number,str);
   fprintf(log,"Error: lines %i-->%i %s\n",*line_number,*new_line_number,str);
   return;
}


void warning(char str[],FILE *log,int *line_number,int *new_line_number){
   printf("Warning: lines %i-->%i %s\n",*line_number,*new_line_number,str);
   fprintf(log,"Warning: lines %i-->%i %s\n",*line_number,*new_line_number,str);
   return;
}


void eliminate(char name_origin[],FILE *log,char word[],int *line,
               int *new_line_number){
   char word_without_newline[64];
   strcpy(word_without_newline,word);
   warning("LaTeX-useless command eliminated: (see next warning)",
          log,line,new_line_number);
   warning(word,
          log,line,new_line_number);
   fflush(stdout);
   return;
}
