/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.auxparser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.texparser.LatexLexer;
import net.sourceforge.texlipse.texparser.node.EOF;
import net.sourceforge.texlipse.texparser.node.TArgument;
import net.sourceforge.texlipse.texparser.node.TCcite;
import net.sourceforge.texlipse.texparser.node.TCsymbol;
import net.sourceforge.texlipse.texparser.node.TCword;
import net.sourceforge.texlipse.texparser.node.TWord;
import net.sourceforge.texlipse.texparser.node.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuxFileParser {
    private IProject project;
    private String rootAuxfile;

    public AuxFileParser(IProject project, String auxFile) {
        this.project = project;
        this.rootAuxfile = auxFile;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getRootAuxFile() {
        return this.rootAuxfile;
    }

    public List<String> getCitations() {
        return this.doParse(this.rootAuxfile, "\\citation");
    }

    public List<ReferenceEntry> getLabels() {
        List<String> labels = this.doParse(this.rootAuxfile, "\\newlabel");
        LinkedList<ReferenceEntry> result = new LinkedList<ReferenceEntry>();
        for (String key : labels) {
            result.add(new ReferenceEntry(key, "No info available"));
        }
        return result;
    }

    private List<String> doParse(String filename, String command) {
        IFile auxFile = this.project.getFile(filename);
        String input = null;
        try {
            input = TexlipseProperties.getFileContents((IResource)auxFile);
        }
        catch (IOException e) {
            TexlipsePlugin.log("Could not parse .aux-file " + auxFile, e);
            return new LinkedList<String>();
        }
        LatexLexer lexer = new LatexLexer(new PushbackReader(new StringReader(input), 4096));
        Token prevCommand = null;
        Token prevSymbol = null;
        Token prevText = null;
        LinkedList<String> results = new LinkedList<String>();
        try {
            Token t = lexer.next();
            while (!(t instanceof EOF)) {
                if (prevCommand == null) {
                    if ((t instanceof TCword || t instanceof TCcite) && t.getText().equalsIgnoreCase(command)) {
                        prevCommand = t;
                    }
                } else if ((t instanceof TWord || t instanceof TArgument) && command.equalsIgnoreCase(prevCommand.getText())) {
                    results.add(t.getText());
                    prevCommand = null;
                }
                if (prevText != null && prevText.getText().equalsIgnoreCase("input") && t instanceof TWord) {
                    prevText = null;
                    String newAuxFileName = t.getText();
                    results.addAll(this.doParse(newAuxFileName, command));
                }
                if (prevSymbol == null) {
                    if (t instanceof TCsymbol) {
                        prevSymbol = t;
                    }
                } else {
                    if (prevSymbol.getText().equals("\\@")) {
                        prevText = t;
                    }
                    prevSymbol = null;
                }
                t = lexer.next();
            }
        }
        catch (Exception exception) {}
        return results;
    }
}

