/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.bibeditor;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class BibBraceRule
implements IPredicateRule {
    protected IToken fToken;
    protected boolean entry = false;

    public BibBraceRule(boolean e, IToken token) {
        Assert.isNotNull((Object)token);
        this.fToken = token;
        this.entry = e;
    }

    private IToken doEvaluate(ICharacterScanner scanner, int count) {
        boolean inString = false;
        int c = scanner.read();
        if ((char)c == '{') {
            do {
                if ((char)(c = scanner.read()) == '{' && !inString) {
                    ++count;
                    continue;
                }
                if ((char)c == '}' && !inString) {
                    --count;
                    continue;
                }
                if ((char)c == '\"' && !inString) {
                    inString = true;
                    continue;
                }
                if ((char)c == '\"' && inString) {
                    inString = false;
                    continue;
                }
                if (c != -1) continue;
                return Token.UNDEFINED;
            } while (count > 0);
            return this.fToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.doEvaluate(scanner, 1);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            int c;
            boolean inString = false;
            while ((char)(c = scanner.read()) != ',' || inString) {
                if ((char)c == '@') {
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                if ((char)c == '\"' && !inString) {
                    inString = true;
                    continue;
                }
                if ((char)c == '\"' && inString) {
                    inString = false;
                    continue;
                }
                if (c != -1) continue;
                return Token.UNDEFINED;
            }
        }
        return this.doEvaluate(scanner, 1);
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }
}

