/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.editor.TexCompletionProcessor;
import net.sourceforge.texlipse.editor.TexCompletionProposal;
import net.sourceforge.texlipse.model.ReferenceManager;
import net.sourceforge.texlipse.model.TexCommandEntry;
import net.sourceforge.texlipse.model.TexDocumentModel;
import net.sourceforge.texlipse.templates.TexContextType;
import net.sourceforge.texlipse.templates.TexTemplateCompletion;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.ISourceViewer;

public class TexMathCompletionProcessor
implements IContentAssistProcessor {
    private TexTemplateCompletion templatesCompletion = new TexTemplateCompletion(TexContextType.MATH_CONTEXT_TYPE);
    private TexDocumentModel model;
    private ISourceViewer fviewer;

    public TexMathCompletionProcessor(TexDocumentModel tdm, ISourceViewer viewer) {
        this.model = tdm;
        this.fviewer = viewer;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String command;
        this.model.removeStatusLineErrorMessage();
        String lineStart = "";
        IDocument doc = viewer.getDocument();
        try {
            int lineStartOffset = doc.getLineOffset(doc.getLineOfOffset(offset));
            lineStart = doc.get(lineStartOffset, offset - lineStartOffset);
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexCompletionProcessor: ", e);
            return new ICompletionProposal[0];
        }
        if (lineStart.endsWith("\\\\")) {
            return null;
        }
        int backpos = lineStart.lastIndexOf(92);
        int templatepos = Math.max(Math.max(lineStart.lastIndexOf(32), lineStart.lastIndexOf(36)), lineStart.lastIndexOf(125)) + 1;
        String replacement = lineStart.substring(templatepos);
        ICompletionProposal[] templateProposals = this.computeTemplateCompletions(offset, replacement.length(), replacement, viewer);
        ICompletionProposal[] proposals = null;
        if (backpos >= 0 && (command = lineStart.substring(backpos + 1)).indexOf(32) < 0 && command.indexOf(123) < 0 && command.indexOf(40) < 0) {
            ReferenceManager refManager;
            List<TexCommandEntry> comEntries;
            String endString;
            CompletionProposal cp = null;
            if (("\\".equals(command) || "end".startsWith(command)) && (endString = TexCompletionProcessor.environmentEnd(doc.get(), offset)) != null) {
                cp = new CompletionProposal("\\" + endString, offset - replacement.length(), replacement.length(), endString.length() + 1);
            }
            if ((comEntries = (refManager = this.model.getRefMana()).getCompletionsCom(command, 3)) != null) {
                int start = 0;
                if (cp == null) {
                    proposals = new ICompletionProposal[comEntries.size()];
                } else {
                    proposals = new ICompletionProposal[comEntries.size() + 1];
                    proposals[0] = cp;
                    start = 1;
                }
                int len = command.length();
                int i = 0;
                while (i < comEntries.size()) {
                    proposals[start + i] = new TexCompletionProposal(comEntries.get(i), offset - len, len, this.fviewer);
                    ++i;
                }
            } else if (cp != null) {
                proposals = new ICompletionProposal[]{cp};
            }
        }
        if (proposals != null && templateProposals != null) {
            ICompletionProposal[] value = new ICompletionProposal[proposals.length + templateProposals.length];
            System.arraycopy(proposals, 0, value, 0, proposals.length);
            System.arraycopy(templateProposals, 0, value, proposals.length, templateProposals.length);
            return value;
        }
        if (templateProposals.length == 0) {
            this.model.setStatusLineErrorMessage(" No completions available.");
        }
        return templateProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'\\'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private ICompletionProposal[] computeTemplateCompletions(int offset, int replacementLength, String prefix, ITextViewer viewer) {
        ArrayList returnProposals = this.templatesCompletion.addTemplateProposals(viewer, offset, prefix);
        ICompletionProposal[] proposals = new ICompletionProposal[returnProposals.size()];
        returnProposals.toArray(proposals);
        return proposals;
    }
}

