/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.util.List;
import net.sourceforge.texlipse.model.PartialRetriever;
import net.sourceforge.texlipse.model.ReferenceContainer;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.model.TexCommandContainer;
import net.sourceforge.texlipse.model.TexCommandEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceManager
extends PartialRetriever {
    private ReferenceContainer bibContainer;
    private ReferenceContainer labelContainer;
    private TexCommandContainer commandContainer;

    public ReferenceManager(ReferenceContainer bibRc, ReferenceContainer labRc, TexCommandContainer commands) {
        this.bibContainer = bibRc;
        this.labelContainer = labRc;
        this.commandContainer = commands;
    }

    public ReferenceContainer getBibContainer() {
        return this.bibContainer;
    }

    public ReferenceEntry getBib(String name) {
        List<ReferenceEntry> bibEntries = this.bibContainer.getSortedReferences();
        int nr = ReferenceManager.getEntry(name.toLowerCase(), bibEntries, true);
        if (nr != -1) {
            return bibEntries.get(nr);
        }
        return null;
    }

    public ReferenceEntry getLabel(String ref) {
        List<ReferenceEntry> labels = this.labelContainer.getSortedReferences();
        int nr = ReferenceManager.getEntry(ref, labels, true);
        if (nr != -1) {
            return labels.get(nr);
        }
        return null;
    }

    public TexCommandEntry getEntry(String name) {
        List<TexCommandEntry> commands = this.commandContainer.getSortedCommands(3);
        int nr = ReferenceManager.getEntry(name, commands, false);
        if (nr != -1) {
            return commands.get(nr);
        }
        commands = this.commandContainer.getSortedCommands(1);
        nr = ReferenceManager.getEntry(name, commands, false);
        if (nr != -1) {
            return commands.get(nr);
        }
        return null;
    }

    public List<ReferenceEntry> getCompletionsRef(String start) {
        List<ReferenceEntry> labels = this.labelContainer.getSortedReferences();
        if (labels == null) {
            return null;
        }
        if (start.equals("")) {
            return labels;
        }
        int[] bounds = this.getCompletionsBin(start, labels, true);
        if (bounds[0] == -1) {
            return null;
        }
        return labels.subList(bounds[0], bounds[1]);
    }

    public List<ReferenceEntry> getCompletionsBib(String start) {
        List<ReferenceEntry> bibEntries = this.bibContainer.getSortedReferences();
        if (bibEntries == null) {
            return null;
        }
        if (start.equals("")) {
            return bibEntries;
        }
        int[] bounds = this.getCompletionsBin(start, bibEntries, true);
        if (bounds[0] == -1) {
            return null;
        }
        return bibEntries.subList(bounds[0], bounds[1]);
    }

    public List<TexCommandEntry> getCompletionsCom(String start, int context) {
        List<TexCommandEntry> commands = this.commandContainer.getSortedCommands(context);
        if (commands == null) {
            return null;
        }
        if (start.equals("")) {
            return commands;
        }
        int[] bounds = this.getCompletionsBin(start, commands, false);
        if (bounds[1] == -1) {
            return null;
        }
        return commands.subList(bounds[0], bounds[1]);
    }
}

