/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.spelling.SpellChecker;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SpellingCompletionProposal
implements ICompletionProposal {
    private String solution;
    private IMarker marker;

    public SpellingCompletionProposal(String solution, IMarker marker) {
        this.solution = solution;
        this.marker = marker;
    }

    public void apply(IDocument document) {
        try {
            int charStart;
            int documentOffset = charStart = this.marker.getAttribute("charStart", -1);
            int wordLength = this.marker.getAttribute("charEnd", -1) - charStart;
            if (this.solution.equals(SpellChecker.SPELL_CHECKER_ADD)) {
                String word = document.get(documentOffset, wordLength);
                SpellChecker.addWordToAspell(word);
            } else if (!this.solution.equals(SpellChecker.SPELL_CHECKER_IGNORE)) {
                document.replace(documentOffset, wordLength, this.solution);
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Replacing Spelling Marker", e);
        }
        try {
            this.marker.delete();
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Removing Spelling Marker", e);
        }
    }

    public Point getSelection(IDocument document) {
        int offset = this.marker.getAttribute("charStart", -1);
        if (offset == -1) {
            return null;
        }
        return new Point(offset, this.solution.length());
    }

    public String getAdditionalProposalInfo() {
        return this.solution;
    }

    public String getDisplayString() {
        return this.solution;
    }

    public Image getImage() {
        return TexlipsePlugin.getImage("replacetext");
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

