/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.tableview.views;

import net.sourceforge.texlipse.tableview.views.TexRow;
import net.sourceforge.texlipse.tableview.views.TexRowList;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;

public class TexCellListener
implements KeyListener {
    private TableViewer viewer;
    private int column;
    private TexRowList texRowList;

    private TexCellListener() {
    }

    public TexCellListener(TableViewer viewer, TexRowList texRowList, int column) {
        this.viewer = viewer;
        this.texRowList = texRowList;
        this.column = column;
    }

    public void keyPressed(KeyEvent e) {
        if ((e.stateMask & 0x70000) != 262144) {
            return;
        }
        int row = this.viewer.getTable().getSelectionIndex();
        int columns = this.viewer.getTable().getColumnCount();
        int rows = this.viewer.getTable().getItemCount();
        if ((e.stateMask & 0x70000) == 262144) {
            double sum = 0.0;
            switch (e.keyCode) {
                case 0x1000001: {
                    if (row <= 0) break;
                    this.viewer.editElement(this.viewer.getElementAt(row - 1), this.column);
                    break;
                }
                case 0x1000002: {
                    if (row >= rows - 1) {
                        this.texRowList.addRow();
                    }
                    this.viewer.editElement(this.viewer.getElementAt(row + 1), this.column);
                    break;
                }
                case 0x1000003: {
                    if (this.column <= 0) break;
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column - 1);
                    break;
                }
                case 0x1000004: {
                    if (this.column >= columns - 1) break;
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column + 1);
                    break;
                }
                case 16777272: {
                    sum = this.texRowList.sum(this.column, row, 1);
                    if (row <= 0) break;
                    this.viewer.editElement(this.viewer.getElementAt(row - 1), this.column);
                    ((TexRow)this.texRowList.getRows().get(row)).setCol(this.column, (double)((int)sum) == sum ? Integer.toString((int)sum) : Double.toString(sum));
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column);
                    break;
                }
                case 16777266: {
                    sum = this.texRowList.sum(this.column, row, 2);
                    if (row >= this.texRowList.getRows().size() - 1) break;
                    this.viewer.editElement(this.viewer.getElementAt(row + 1), this.column);
                    ((TexRow)this.texRowList.getRows().get(row)).setCol(this.column, (double)((int)sum) == sum ? Integer.toString((int)sum) : Double.toString(sum));
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column);
                    break;
                }
                case 16777268: {
                    sum = this.texRowList.sum(this.column, row, 3);
                    if (this.column <= 0) break;
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column - 1);
                    ((TexRow)this.texRowList.getRows().get(row)).setCol(this.column, (double)((int)sum) == sum ? Integer.toString((int)sum) : Double.toString(sum));
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column);
                    break;
                }
                case 16777270: {
                    sum = this.texRowList.sum(this.column, row, 4);
                    if (this.column >= 31) break;
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column + 1);
                    ((TexRow)this.texRowList.getRows().get(row)).setCol(this.column, (double)((int)sum) == sum ? Integer.toString((int)sum) : Double.toString(sum));
                    this.viewer.editElement(this.viewer.getElementAt(row), this.column);
                }
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }
}

