/* $Id: rtest2.cc,v 1.8 1997/04/13 12:59:00 dps Exp $ */
/* Reader test program */

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include "strip.h"
#include "interface.h"

/* Dummy to just read the files out */
void reader_test_raw(istream *f)
{
    const char *s;
    const tok_seq::tok *d;
    tok_seq rd(f);
    static const char null[]={ '\0' };

    while ((d=rd.read_token())!=NULL)
    {

	printf((d->end==tok_seq::tok::TOK_START) ? "<" : "</");
	if (d->tokval!=T_TABLE)
	{
	    s=(d->data.d==NULL) ? null : d->data.d;
	}

	switch(d->tokval)
	{
	case T_TABLE:
	    printf("TABLE %d x %d>\n", d->data.table.cols, d->data.table.rows);
	    break;

	case T_PARAGRAPH:
	    printf("PARAGRAPH>%s\n\n", s);
	    break;

	case T_FIELD:
	    printf("FIELD>%s", s);
	    break;

	case T_ROW:
	    printf("ROW>%s\n", s);
	    break;

	case T_SPEC:
	    printf("SPEC>%s", s);
	    break;

	case T_LIST:
	    printf("LIST>%s\n", s);
	    break;

	case T_ITEM:
	    printf("ITEM>%s\n", s);
	    break;
	    
	case T_DOC:
	    printf("DOCUMENT>%s", s);
	    break;

	case T_CODE:
	    fputs("CODE ", stdout);
	    switch(*s)
	    {
	    case CH_PAGE:
		fputs("page break", stdout);
		break;

	    case CH_FOOTNOTE:
		fputs("footnote", stdout);
		break;

	    default:
		printf("unexpected value %d", *s);
		break;
	    }
	    puts(">");
	    break;

	case T_OTHER:
	    printf("OTHER>%s\n", s);
	    break;

	default:
	    printf("?>%s\n", s);
	    break;
	}
	fflush(stdout);
    }
}


int main(int argc, const char **argv)
{
    FILE *f;

    argc=argc;
    f=fopen(argv[1],"r");
    if (f==NULL)
    {
	fprintf(stderr,"%s not found\n", argv[1]);
	exit(1);
    }
    else
    {
	fclose(f);
	word_junk_filter filt(argv[1]);
	istream in(&filt);
	reader_test_raw(&in);
    }
    return 0;
}

