#include "Demoone.h"
 
Cpptcl_Members(Toaster) = { 
	cppDatamember("Time left till done",Toaster::timeleft,int),
};
Cpptcl_IClass(Toaster,"Toaster",tcl_object);

//.min(0.0)

Toaster::Toaster(tcl_args& arg)
:tcl_object(arg)
{
    timeleft = 0.0;
}

void Toaster::wait(void) {
        // do something
}

int Toaster::parse_tcl_command(tcl_args& arg) {
    if(arg("#seconds","set timer on toaster")=="addTime") {
        float add;
        arg >> add >> done;
        NO_EXCEPTIONS(arg);
        if(add <0) {
            tcl_ << "You can only increment the timer" 
                 << tcl_error;
        } else {
            timeleft += add;
            tcl_ << timeleft << result;
        }
        return tcl_;
    } else if(arg("","Wait a second")=="wait") {
        arg >> done;
        NO_EXCEPTIONS(arg);
        if(timeleft >= 1) {
            wait();
            timeleft -= 1;
        } else {
            timeleft = 0;
        }
        tcl_ << timeleft << " seconds left" << result;
        return tcl_;
    } else {
        return tcl_object::parse_tcl_command(arg);
    }
}

/* 
 * You can either create Toasters directly in C++ by
 * calling the constructor (it needs a trivial argument	list
 * with	its	name), or you create a 'cpx_class' to deal with
 * it in C++.  This	happens	automatically if you register
 * with	'cppmeta', like this:
 */

int Cpptcl_InitFunction(Demoone_Init) {
	// Complex macro which declares a new C++ class and from what it derives.
	Cpptcl_Object(Toaster, tcl_base);
	// Tell Tcl about this package
	Tcl_PkgProvide(interp,"Demoone","0.1");
  	// Use this nice wrapper which does the following:
	// 1: Finds my package's library files, and sets the global
	//    variable 'demoone_library' to their location.  It looks in 
	//    a platform dependent way for where those files should be,
	//    and examines the given environment variable DEMOONE_LIBRARY
	//    too.  You could add as an optional extra argument a compiled
	//    in location too. e.g. On MacOS, we look for the directory
	//    'demoone0.1' is a particular place.
	//
	// 2: Sets a little Tcl evaluation to source the file 'demoone.tcl'
	//    in that location, and return any appropriate error if that
	//    failed.
	//
	return interp.PackageLibraryInit("demoone_library", /* Tcl variable */
	                                 "DEMOONE_LIBRARY", /* Environment var */
	                                 "demoone", /* Name of package */
	                                 "demoone.tcl", /* Name of init file */
	                                 "0.1", /* Version */
	                                 "DemoOne"); /* Pretty name of package */
}
