/* ioctl2.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

/*
  Under Win32s we habe no console support
  Emulate them for EMX startup code
*/

static int _rsxnt_win32s_ioctl(int fd, int request, int arg)
{
    int *type = (int *) arg;
    *type = HT_DEV_CON;
    return 0;
}

int __ioctl2(int fd, int request, int arg)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD type;
    int *arg_ptr;

    if (fd >= N_FILES || fd < 0)
	return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
	return _rsxnt_errno(EBADF);

    if (_rsxnt_win32_version == WIN32S
	&& fd < 3 && p->file[fd].f_handle == BAD_FS_HANDLE)
	return _rsxnt_win32s_ioctl (fd, request, arg);

    if (p->file[fd].f_mode == HT_SOCKET)
    {
	if (!_rsxnt_socket_fop.ioctl)
	    return _rsxnt_errno (EBADF);
	else
	    return (*_rsxnt_socket_fop.ioctl)
	      ((int) p->file[fd].f_handle, request, arg);
    }

    type = _rsxnt_get_ht_type(p->file[fd].f_handle);

    if (request == FGETHTYPE) {
	if (type == 0xffffffff)
	    return _rsxnt_errno(EBADF);
	arg_ptr = (int *) arg;
	*arg_ptr = type;
	return 0;

    } else if (fd == 0 && type == HT_DEV_CON) {
	return _rsxnt_termio_ioctl(p, request, arg);
    } else
	return _rsxnt_errno(EINVAL);
}
