/* vvprintf.c (emx+gcc) -- Copyright (c) 1987-1996 by Eberhard Mattes */

#include <stdio.h>
#include <stdarg.h>
#include <sys/video.h>
#include "video2.h"
#include <emx/io.h>

static int _v_flush (FILE *stream, int c)
{
  int n;

  n = stream->_ptr - stream->_buffer;
  if (n > 0)
    _v_puts_len (stream->_buffer, n);
  stream->_ptr = stream->_buffer;
  *stream->_ptr++ = (char)c;
  stream->_wcount = stream->_buf_size - 1;
  return 0;
}


int v_vprintf (const char *fmt, va_list arg_ptr)
{
  FILE trick;
  struct _file2 trick2;
  int result;
  char buf[512];

  trick._buffer = buf;
  trick._ptr = buf;
  trick._rcount = 0;
  trick._wcount = sizeof (buf);
  trick._handle = -1;
  trick._flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOWRT;
  trick._buf_size = sizeof (buf);
  trick._flush = _v_flush;
  trick._ungetc_count = 0;
  _setdummymore (&trick, &trick2);
  result = _output (&trick, fmt, arg_ptr);
  _v_flush (&trick, 0);
  return result;
}
