/***************************************************************************\
*									    *
*   COMMCTRL.H								    *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_COMMCTRL_H)
#define _COMMCTRL_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	HWND	hwndFrom;
	UINT	idFrom;
	UINT	code;
} NMHDR, *LPNMHDR;

#define TBSTATE_ENABLED 	0x04
#define TBSTYLE_BUTTON		0x00
#define TBSTYLE_SEP		0x01
#define TBSTYLE_TOOLTIPS	0x0100

#ifdef UNICODE
#define SB_SETTEXT		(WM_USER+11)
#define SB_GETTEXT		(WM_USER+13)
#else
#define SB_SETTEXT		(WM_USER+1)
#define SB_GETTEXT		(WM_USER+2)
#endif

#define SB_SETPARTS		(WM_USER+4)
#define SB_GETPARTS		(WM_USER+6)

#define SBT_NOBORDERS		 0x0100
#define SBT_POPOUT		 0x0200
#define SBT_OWNERDRAW		 0x1000

#define TTN_FIRST		(0U-520U)
#ifdef UNICODE
#define TTN_NEEDTEXT		(TTN_FIRST - 10)
#else
#define TTN_NEEDTEXT		(TTN_FIRST - 0)
#endif

#define LVM_FIRST		0x1000
#define TV_FIRST		0x1100
#define HDM_FIRST		0x1200

#define LVN_FIRST		(0U-100U)
#define LVN_LAST		(0U-199U)

#define WC_LISTVIEWA		"SysListView32"
#define WC_LISTVIEWW		L"SysListView32"
#ifdef UNICODE
#define WC_LISTVIEW		WC_LISTVIEWW
#else
#define WC_LISTVIEW		WC_LISTVIEWA
#endif

#define LVS_ICON		0x0000
#define LVS_REPORT		0x0001
#define LVS_SMALLICON		0x0002
#define LVS_LIST		0x0003
#define LVS_TYPEMASK		0x0003
#define LVS_SINGLESEL		0x0004
#define LVS_SHOWSELALWAYS	0x0008
#define LVS_SORTASCENDING	0x0010
#define LVS_SORTDESCENDING	0x0020
#define LVS_SHAREIMAGELISTS	0x0040
#define LVS_NOLABELWRAP 	0x0080
#define LVS_AUTOARRANGE 	0x0100
#define LVS_EDITLABELS		0x0200
#define LVS_NOSCROLL		0x2000
#define LVS_TYPESTYLEMASK	0xfc00
#define LVS_ALIGNTOP		0x0000
#define LVS_ALIGNLEFT		0x0800
#define LVS_ALIGNMASK		0x0c00
#define LVS_OWNERDRAWFIXED	0x0400
#define LVS_NOCOLUMNHEADER	0x4000
#define LVS_NOSORTHEADER	0x8000
#define LVSIL_NORMAL		0x0000
#define LVSIL_SMALL		0x0001
#define LVSIL_STATE		0x0002
#define LVIF_TEXT		0x0001
#define LVIF_IMAGE		0x0002
#define LVIF_PARAM		0x0004
#define LVIF_STATE		0x0008
#define LVIS_FOCUSED		0x0001
#define LVIS_SELECTED		0x0002
#define LVIS_CUT		0x0004
#define LVIS_DROPHILITED	0x0008
#define LVIS_OVERLAYMASK	0x0F00
#define LVIS_STATEIMAGEMASK	0xF000

#define LVM_GETBKCOLOR		    (LVM_FIRST + 0)
#define ListView_GetBkColor(hwnd)   (COLORREF)SendMessage((hwnd), LVM_GETBKCOLOR, 0, 0L)
#define LVM_SETBKCOLOR		    (LVM_FIRST + 1)
#define ListView_SetBkColor(hwnd, clrBk) (BOOL)SendMessage((hwnd), LVM_SETBKCOLOR, 0, (LPARAM)(COLORREF)(clrBk))
#define LVM_GETIMAGELIST	    (LVM_FIRST + 2)
#define ListView_GetImageList(hwnd, iImageList) (HIMAGELIST)SendMessage((hwnd), LVM_GETIMAGELIST, (WPARAM)(INT)(iImageList), 0L)
#define LVM_SETIMAGELIST	    (LVM_FIRST + 3)
#define ListView_SetImageList(hwnd, himl, iImageList) (HIMAGELIST)(UINT)SendMessage((hwnd), LVM_SETIMAGELIST, (WPARAM)(iImageList), (LPARAM)(UINT)(HIMAGELIST)(himl))
#define LVM_GETITEMCOUNT	    (LVM_FIRST + 4)
#define ListView_GetItemCount(hwnd) (int)SendMessage((hwnd), LVM_GETITEMCOUNT, 0, 0L)
#define ListView_GetColumn(hwnd, iCol, pcol) (BOOL)SendMessage((hwnd), LVM_GETCOLUMN, (WPARAM)(int)(iCol), (LPARAM)(LV_COLUMN FAR*)(pcol))
#define ListView_SetColumn(hwnd, iCol, pcol) (BOOL)SendMessage((hwnd), LVM_SETCOLUMN, (WPARAM)(int)(iCol), (LPARAM)(const LV_COLUMN FAR*)(pcol))
#define ListView_InsertColumn(hwnd, iCol, pcol) (int)SendMessage((hwnd), LVM_INSERTCOLUMN, (WPARAM)(int)(iCol), (LPARAM)(const LV_COLUMN FAR*)(pcol))
#define ListView_DeleteColumn(hwnd, iCol) (BOOL)SendMessage((hwnd), LVM_DELETECOLUMN, (WPARAM)(int)(iCol), 0)
#define ListView_GetColumnWidth(hwnd, iCol) (int)SendMessage((hwnd), LVM_GETCOLUMNWIDTH, (WPARAM)(int)(iCol), 0)
#define ListView_SetColumnWidth(hwnd, iCol, cx) (BOOL)SendMessage((hwnd), LVM_SETCOLUMNWIDTH, (WPARAM)(int)(iCol), MAKELPARAM((cx), 0))
#define ListView_InsertItem(hwnd, pitem) (int)SendMessage((hwnd), LVM_INSERTITEM, 0, (LPARAM)(const LV_ITEM FAR*)(pitem))

#define LVCF_FMT		0x0001
#define LVCF_WIDTH		0x0002
#define LVCF_TEXT		0x0004
#define LVCF_SUBITEM		0x0008
#define LVCFMT_LEFT		0x0000
#define LVCFMT_RIGHT		0x0001
#define LVCFMT_CENTER		0x0002
#define LVCFMT_JUSTIFYMASK	0x0003
#define LVM_SETCOLUMNA		(LVM_FIRST + 26)
#define LVM_SETCOLUMNW		(LVM_FIRST + 96)
#ifdef UNICODE
#define  LVM_SETCOLUMN		LVM_SETCOLUMNW
#else
#define  LVM_SETCOLUMN		LVM_SETCOLUMNA
#endif

#define HANDLE_WM_NOTIFY(hWnd, wParam, lParam, fn) \
(fn)((hWnd),(int)(wParam),(NMHDR *)(lParam))

typedef struct {
    int     iBitmap;
    int     idCommand;
    BYTE    fsState;
    BYTE    fsStyle;
    BYTE    bReserved[2];
    DWORD   dwData;
    int     iString;
} TBBUTTON,
*LPTBBUTTON;

typedef struct {
    NMHDR	hdr;
    LPTSTR	lpszText;
    TCHAR	szText[80];
    HINSTANCE	hinst;
    UINT	uFlags;
} TOOLTIPTEXT,
*LPTOOLTIPTEXT;

typedef struct
{
    UINT	mask;
    int 	fmt;
    int 	cx;
    LPTSTR	pszText;
    int 	cchTextMax;
    int 	iSubItem;
} LV_COLUMN;

typedef struct
{
    POINT	pt;
    UINT	flags;
    int 	iItem;
} LV_HITTESTINFO;

struct dummy_IMAGELIST;
typedef struct dummy_IMAGELIST *HIMAGELIST;

void WINAPI InitCommonControls();

HWND WINAPI CreateToolbarEx(HWND, DWORD, UINT, int, HINSTANCE, UINT,
    __const__ LPTBBUTTON, int, int, int, int, int, UINT);
HIMAGELIST  WINAPI ImageList_Create(int cx, int cy, UINT flags, int cInitial, int cGrow);
BOOL	    WINAPI ImageList_Destroy(HIMAGELIST himl);
int	    WINAPI ImageList_GetImageCount(HIMAGELIST himl);
int	    WINAPI ImageList_Add(HIMAGELIST himl, HBITMAP hbmImage, HBITMAP hbmMask);
int	    WINAPI ImageList_ReplaceIcon(HIMAGELIST himl, int i, HICON hicon);
COLORREF    WINAPI ImageList_SetBkColor(HIMAGELIST himl, COLORREF clrBk);
COLORREF    WINAPI ImageList_GetBkColor(HIMAGELIST himl);
BOOL	    WINAPI ImageList_SetOverlayImage(HIMAGELIST himl, int iImage, int iOverlay);
BOOL        WINAPI ImageList_Replace(HIMAGELIST himl, int i, HBITMAP hbmImage, HBITMAP hbmMask);
int         WINAPI ImageList_AddMasked(HIMAGELIST himl, HBITMAP hbmImage, COLORREF crMask);
BOOL        WINAPI ImageList_DrawEx(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, int dx, int dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle);
BOOL        WINAPI ImageList_Remove(HIMAGELIST himl, int i);
HICON       WINAPI ImageList_GetIcon(HIMAGELIST himl, int i, UINT flags);
HIMAGELIST  WINAPI ImageList_LoadImageA(HINSTANCE hi, LPCSTR lpbmp, int cx, int cGrow, COLORREF crMask, UINT uType, UINT uFlags);
HIMAGELIST  WINAPI ImageList_LoadImageW(HINSTANCE hi, LPCWSTR lpbmp, int cx, int cGrow, COLORREF crMask, UINT uType, UINT uFlags);

#define     ImageList_AddIcon(himl, hicon) ImageList_ReplaceIcon(himl, -1, hicon)

#define CreateStatusWindow TFUNCT(CreateStatusWindow)
HWND WINAPI CreateStatusWindow(LONG, LPCTSTR, HWND, UINT);

#ifndef FORWARD_SB_SETTEXT
#define FORWARD_SB_SETTEXT(hwnd, part, type, text, fn) \
    (void)(fn)((hwnd), SB_SETTEXT, (WPARAM)((part)|(type)),(LPARAM)(text))
#endif
#ifndef FORWARD_SB_SETPARTS
#define FORWARD_SB_SETPARTS(hwnd, npart, width, fn) \
    (void)(fn)((hwnd), SB_SETPARTS, (WPARAM)(npart),(LPARAM)(LPINT)(width))
#endif

#ifdef __cplusplus
}
#endif

#endif /* !defined (_COMMCTRL_H) */
