/***************************************************************************\
*                                                                           *
*   WINMENU.H                                                               *
*                                                                           *
*   Some headers are used from the cygnus project                           *
*   Modified by:                                                            *
*    kiefer@isys.de                                                         *
*    rainer@mathematik.uni-bielefeld.de                                     *
*									    *
\***************************************************************************/

#if !defined (_WINMENU_H)
#define _WINMENU_H

#ifdef __cplusplus
extern "C" {
#endif


#define MF_INSERT 0x00000000L
#define MF_CHANGE 0x00000080L
#define MF_APPEND 0x00000100L
#define MF_DELETE  0x00000200L
#define MF_REMOVE 0x00001000L
#define MF_BYCOMMAND 0x00000000L
#define MF_BYPOSITION 0x00000400L
#define MF_SEPARATOR  0x00000800L
#define MF_ENABLED 0x00000000L
#define MF_GRAYED 0x00000001L
#define MF_DISABLED 0x00000002L
#define MF_UNCHECKED 0x00000000L
#define MF_CHECKED 0x00000008L
#define MF_USECHECKBITMAPS 0x00000200L
#define MF_STRING 0x00000000L
#define MF_BITMAP 0x00000004L
#define MF_OWNERDRAW 0x00000100L
#define MF_POPUP 0x00000010L
#define MF_MENUBARBREAK 0x00000020L
#define MF_MENUBREAK 0x00000040L
#define MF_UNHILITE 0x00000000L
#define MF_HILITE 0x00000080L
#define MF_SYSMENU 0x00002000L
#define MF_HELP 0x00004000L
#define MF_MOUSESELECT 0x00008000L

#define MFT_SEPARATOR       MF_SEPARATOR

#if !defined(RC_INVOKED)
HMENU WINAPI GetMenu(HWND hWnd);
BOOL WINAPI SetMenu(HWND hWnd, HMENU hMenu);
#define LoadMenu  TFUNCT(LoadMenu)
HMENU WINAPI LoadMenu(HINSTANCE hInst, LPCTSTR lpMenuName);
typedef VOID MENUTEMPLATE;
#define LoadMenuIndirect TFUNCT(LoadMenuIndirect)
HMENU WINAPI LoadMenuIndirect(CONST MENUTEMPLATE *lpMenuTemplate);
#define ChangeMenu TFUNCT(ChangeMenu)
BOOL WINAPI ChangeMenu(HMENU hMenu, UINT cmd, LPCTSTR lpszNewItem,
	UINT cmdInsert, UINT flags);
BOOL WINAPI HiliteMenuItem(HWND hWnd, HMENU hMenu,
	UINT uIDHiliteItem, UINT uHilite);
#define GetMenuString TFUNCT(GetMenuString)
int WINAPI GetMenuString(HMENU hMenu, UINT uIDItem, LPTSTR lpString,
	int nMaxCount, UINT uFlag);
UINT WINAPI GetMenuState(HMENU hMenu, UINT uId, UINT uFlags);
BOOL WINAPI DrawMenuBar(HWND hWnd);
HMENU WINAPI GetSystemMenu(HWND hWnd, BOOL bRevert);
HMENU WINAPI CreateMenu(VOID);
HMENU WINAPI CreatePopupMenu(VOID);
BOOL WINAPI DestroyMenu(HMENU hMenu);
DWORD WINAPI CheckMenuItem(HMENU hMenu, UINT uIDCheckItem, UINT uCheck);
BOOL WINAPI EnableMenuItem(HMENU hMenu, UINT uIDEnableItem, UINT uEnable);
HMENU WINAPI GetSubMenu(HMENU hMenu, int nPos);
UINT WINAPI GetMenuItemID(HMENU hMenu, int nPos);
int WINAPI GetMenuItemCount(HMENU hMenu);
#define InsertMenu TFUNCT(InsertMenu)
BOOL WINAPI InsertMenu(HMENU hMenu, UINT uPosition,
	UINT uFlags, UINT uIDNewItem, LPCTSTR lpNewItem);
#define AppendMenu TFUNCT(AppendMenu)
BOOL WINAPI AppendMenu(HMENU hMenu, UINT uFlags, UINT uIDNewItem,
	LPCTSTR lpNewItem);
#define ModifyMenu TFUNCT(ModifyMenu)
BOOL WINAPI ModifyMenu(HMENU hMnu, UINT uPosition, UINT uFlags,
	UINT uIDNewItem, LPCTSTR lpNewItem);
BOOL WINAPI RemoveMenu(HMENU hMenu, UINT uPosition, UINT uFlags);
BOOL WINAPI DeleteMenu(HMENU hMenu, UINT uPosition, UINT uFlags);
BOOL WINAPI SetMenuItemBitmaps(HMENU hMenu, UINT uPosition,
	UINT uFlags, HBITMAP hBitmapUnchecked, HBITMAP hBitmapChecked);
LONG WINAPI GetMenuCheckMarkDimensions(VOID);
BOOL WINAPI TrackPopupMenu(HMENU hMenu, UINT uFlags, int x, int y,
	int nReserved, HWND hWnd, CONST RECT *prcRect);
#endif /* RC_INVOKED */

#ifdef __cplusplus
}
#endif

#endif /* !defined (_WINMENU_H) */
