#include <stdio.h>
#include <math.h>
#define BASE 11
#define D (BASE-1)

void print(FILE *f, int ax, int ay, int dx, int dy)
{
  double len, s, c;

  len = sqrt((long)dy*dy + dx*dx);
  s = dy/len;
  c = dx/len;
  fprintf(f, "  %3lg,%3lg,%3lg,%3lg,\n",
          floor(c * ax - s * ay + .5),
  	  floor(s * ax + c * ay + .5),
  	  floor(c * ax - s * -ay + .5),
  	  floor(s * ax + c * -ay + .5));
}

int main(void)
{
  int dx, dy, ax, ay;
  FILE *f;

  ax = -6; ay = 2;

  if ((f = fopen("ahdtbl.c", "w")) == NULL) {
    fprintf(stderr, "can't open output\n");
    return 1;
  }
  fprintf(f, "static struct ahofs {\n"
	     "  signed char x1,y1,x2,y2;\n"
	     "} ahofs[] = {\n");

  for (dy = 0, dx = BASE; dy < BASE; ++dy)
    print(f, ax, ay, dx, dy);

  for ( ; dx > -BASE; --dx)
    print(f, ax, ay, dx, dy);

  for ( ; dy > -BASE; --dy)
    print(f, ax, ay, dx, dy);

  for ( ; dx < BASE; ++dx)
    print(f, ax, ay, dx, dy);

  for ( ; dy < 0; ++dy)
    print(f, ax, ay, dx, dy);

  fprintf(f, "};");
  fclose(f);

  return 0;
}
