# Makefile for ted. (c) Gene Ressler 92

# Turbo C make V3.1
# Turbo C++ compiler, version 1.00
# TLINK V3.0

# Version
VMAJOR  = 1
VMINOR  = 1

.SILENT

# Following for production.
CFLAGS  = -O -Z -G- -k -ml -v -y -DNDEBUG

# Following for development.
# CFLAGS  = -O -Z -G- -k -ml -v -y -DTRACE

TCDIR   = c:\\tc\\
TCLIBDIR= $(TCDIR)lib\\
TCBINDIR= $(TCDIR)bin\\
TCBGIDIR= $(TCDIR)bgi\\

CC      = $(TCBINDIR)tcc
LINK    = $(TCBINDIR)tlink /m /v $(TCLIBDIR)c0l @ted.lnk, ted, ted, $(TCLIBDIR)cl $(TCLIBDIR)graphics
XREF    = $(TCBINDIR)objxref /rv $(TCLIBDIR)c0l @ted.lnk $(TCLIBDIR)cl.lib $(TCLIBDIR)graphics.lib
MAKE    = $(TCBINDIR)make

BINDIR  = ..\\install
STRIP   = c:\\td\\tdstrip

ZIP     = c:\\bin\\pkzip.exe
ZIPDIR  = d:\\ted
ZIPNAME = lated11a

# Get bitmaps from subdirectories
.PATH.sbm = bitmap      # standard bitmaps
.PATH.bmp = bitmap      # custom bitmaps
.PATH.csr = bitmap      # cursors

.c.obj:
	$(CC) $(CFLAGS) -c $<
.c.exe:
	$(CC) $(CFLAGS) $<
.sbm.c:
	makebmap -s $<
	echo $<:
.bmp.c:
	makebmap    $<
	echo $<:
.csr.c:
	makebmap -i $<
	echo $<:

O1 = button.obj canvas.obj checks.obj command.obj cursor.obj
O2 = datetime.obj dialog.obj editbox.obj env.obj event.obj
O3 = file.obj graphics.obj handler.obj header.obj key.obj 
O4 = main.obj malloc.obj menu.obj message.obj mouse.obj 
O5 = radio.obj settings.obj scroll.obj table.obj dtext.obj 
O6 = units.obj version.obj walk.obj window.obj $(TCBGIDIR)egavga.obj
O7 = $(TCBGIDIR)litt.obj

OBJECTS = $(O1) $(O2) $(O3) $(O4) $(O5) $(O6) $(O7)

UTILS = makarrow.exe makbmdep.exe makebmap.exe makekeys.exe     \
	animal.exe makever.exe

ted.exe: $(OBJECTS) ted.lnk 
	$(LINK)


utils:  $(UTILS)
		
clean:
	if exist *.bak          del *.bak
	if exist *.obj          del *.obj
	if exist *.map          del *.map
	if exist *.asm          del *.asm
	if exist *.i            del *.i
	if exist bitmap\\*.c    del bitmap\\*.c
	if exist tmp.*          del tmp.*
	if exist *.tmp          del *.tmp
	if exist *.dvi          del *.dvi
	if exist *.log          del *.log
	if exist *.aux          del *.aux
	if exist no-name.*      del no-name.*
	if exist *.dlg          del *.dlg

# Obsolete...
first:
	$(MAKE) clean
	for %f in ($(.PATH.sbm)\\*.sbm) do makebmap -s %f
	$(MAKE)

install: ted.exe default.set
	copy ted.exe $(BINDIR)
	$(STRIP) $(BINDIR)\\ted.exe
	copy default.set $(BINDIR)\\ted.set
	if exist docs\\ted.dvi copy docs\\ted.dvi $(BINDIR)

zip:
	if exist $(ZIPDIR)\\$(ZIPNAME).ZIP del $(ZIPDIR)\\$(ZIPNAME).ZIP
	$(ZIP) -p -r -x$(ZIPNAME).ZIP $(ZIPDIR)\\$(ZIPNAME) $(ZIPDIR)\\*.*
	dir $(ZIPDIR)\\$(ZIPNAME).ZIP

xref:   $(OBJECTS) ted.lnk
	$(XREF) > ted.xrf

# link file
ted.lnk         : makefile.tcc
	echo Link file
	echo $(O1)+ >  ted.lnk
	echo $(O2)+ >> ted.lnk
	echo $(O3)+ >> ted.lnk
	echo $(O4)+ >> ted.lnk
	echo $(O5)+ >> ted.lnk
	echo $(O6)+ >> ted.lnk
	echo $(O7)  >> ted.lnk

# utilities
makarrow.exe    : makarrow.c
makbmdep.exe    : makbmdep.c
makebmap.exe    : makebmap.c
makekey.exe     : makekey.c
animal.exe      : animal.c

# version
version.c       : $(OBJECTS)
	makever $(VMAJOR) $(VMINOR)
	type version.c
	echo ...

# object files
button.obj      : button.c window.h key.h resource.h
canvas.obj      : canvas.c window.h canvas.h resource.h settings.h obj.def
checks.obj      : checks.c window.h
command.obj     : command.c window.h canvas.h settings.h env.h
cursor.obj      : cursor.c window.h
dialog.obj      : dialog.c window.h key.h bitmap\\ok.c bitmap\\cancel.c \
			bitmap\\yes.c bitmap\\no.c bitmap\\larrow.c \
			bitmap\\rarrow.c bitmap\\uarrow.c bitmap\\darrow.c \
			bitmap\\slider.c bitmap\\color.c
dtext.obj       : dtext.c window.h
editbox.obj     : editbox.c window.h key.h resource.h
env.obj         : env.c window.h canvas.h env.h resource.h key.h settings.h \
			bitmap\\pick.c bitmap\\unpick.c bitmap\\cyclpick.c \
			bitmap\\copy.c bitmap\\move.c bitmap\\del.c \
			bitmap\\modify.c bitmap\\text.c bitmap\\polyline.c \
			bitmap\\vector.c bitmap\\rect.c bitmap\\dashrect.c \
			bitmap\\fillrect.c bitmap\\oval.c bitmap\\oval2.c \
			bitmap\\oval4.c bitmap\\circ.c bitmap\\fillcirc.c \
			bitmap\\origin.c bitmap\\zoom.c bitmap\\undo.c \
			bitmap\\thick.c bitmap\\thin.c bitmap\\chgthick.c \
			bitmap\\ljust.c bitmap\\rjust.c bitmap\\hcjust.c \
			bitmap\\tjust.c bitmap\\bjust.c bitmap\\vcjust.c
event.obj       : event.c window.h wintern.h key.h
file.obj        : file.c window.h resource.h key.h
graphics.obj    : graphics.c window.h ahdtbl.c
handler.obj     : handler.c window.h canvas.h env.h settings.h lvslopes.c\
		  resource.h
header.obj      : header.c window.h
key.obj         : key.c window.h key.h
main.obj        : main.c window.h settings.h canvas.h env.h
malloc.obj      : malloc.c window.h settings.h canvas.h env.h
menu.obj        : menu.c window.h wintern.h key.h
message.obj     : message.c window.h resource.h key.h
mouse.obj       : mouse.c window.h bitmap\\arrow.c bitmap\\wait.c
radio.obj       : radio.c window.h key.h
scroll.obj      : scroll.c window.h wintern.h resource.h key.h
settings.obj    : settings.c canvas.h env.h settings.h window.h
table.obj       : table.c window.h resource.h key.h
units.obj       : units.c window.h settings.h canvas.h
walk.obj        : walk.c window.h wintern.h
window.obj      : window.c window.h wintern.h

# window header uses button declarations
window.h        : bitmap\\cancel.c bitmap\\darrow.c bitmap\\larrow.c \
			bitmap\\no.c bitmap\\ok.c bitmap\\rarrow.c \
			bitmap\\slider.c bitmap\\uarrow.c bitmap\\yes.c \
			bitmap\\color.c

# canvas data structures use object defs
canvas.h        : obj.def

# standard bitmaps
cancel.c        : cancel.sbm
darrow.c        : darrow.sbm
larrow.c        : larrow.sbm
no.c            : no.sbm
ok.c            : ok.sbm
rarrow.c        : rarrow.sbm
slider.c        : slider.sbm
uarrow.c        : uarrow.sbm
yes.c           : yes.sbm
color.c         : color.sbm

# custom bitmaps
bjust.c         : bjust.bmp
circ.c          : circ.bmp
copy.c          : copy.bmp
cyclpick.c      : cyclpick.bmp
dashrect.c      : dashrect.bmp
del.c           : del.bmp
fillcirc.c      : fillcirc.bmp
fillrect.c      : fillrect.bmp
hcjust.c        : hcjust.bmp
ljust.c         : ljust.bmp
move.c          : move.bmp
open.c          : open.bmp
origin.c        : origin.bmp
oval.c          : oval.bmp
oval2.c         : oval2.bmp
oval4.c         : oval4.bmp
pick.c          : pick.bmp
pickarea.c      : pickarea.bmp
polyline.c      : polyline.bmp
modify.c        : modify.bmp
rect.c          : rect.bmp
rjust.c         : rjust.bmp
text.c          : text.bmp
textrect.c      : textrect.bmp
thick.c         : thick.bmp
thin.c          : thin.bmp
chgthick.c      : chgthick.bmp
tjust.c         : tjust.bmp
undo.c          : undo.bmp
unpick.c        : unpick.bmp
vcjust.c        : vcjust.bmp
vector.c        : vector.bmp
zoom.c          : zoom.bmp

# cursor bitmaps
arrow.c         : arrow.csr
wait.c          : wait.csr
