procedure JoinFont(nfont        : integer;
                  var CharReMap : CharReMapArr;
                  var FParam    : FontParamRec;
                  var FDim      : FontDimenRec;
                  var FChar     : CharDataType;
                  var FLig      : ptrLigRecord;
                  var FLigB     : ptrLigRecord);
var ptrC, ptrCH : ptrCharReMap;
    ptrL, ptrLH, pLH : ptrLigRecord;
    ptrDD  : ptrDVIRecord;
    icf, i, j, k : integer;
    ich : byte;
    fl : boolean;
begin

     {---- delete not necessary fragments in Main LigTable ----}
     FreeLigRecord(FLig,false);

     {---- delete not necessary fragments in Bound LigTable ----}
     FreeLigRecord(FLigB,false);

     {---- Join Main LigTable ------}
     if FLig <> nil then
     begin
         ptrL:=ptrLigMain;
         if ptrL = nil then ptrLigMain:=FLig
         else begin
              while ptrL^.ptrNext <> nil do ptrL:=ptrL^.ptrNext;
              ptrL^.ptrNext:=FLig;
         end;
     end;

     {---- Join Bound LigTable ------}
     if FLigB <> nil then
     begin
         ptrL:=ptrLigBound;
         if ptrL = nil then ptrLigBound:=FLigB
         else begin
              while ptrL^.ptrNext <> nil do ptrL:=ptrL^.ptrNext;
              ptrL^.ptrNext:=FLigB;
         end;
     end;

     {--- assign DVI char sizes ---}
     for i:=0 to 255 do
     if CharDataGlb^[i].marked = CharDVI then
     begin
         ptrDD:=CharDataGlb^[i].ptrDVI; icf:=0;
         while ptrDD <> nil do
         begin
              if (ptrDD^.TDVI = DVIFont) then icf:=ptrDD^.nfont;
              if (ptrDD^.TDVI = DVIChar) and (icf = nfont) then
              begin
                 j:=ptrDD^.nchar;
                 if FChar[j].defined then
                 begin
                      ptrDD^.cwidth:=FChar[j].CharWD;
                      ptrDD^.cheight:=FChar[j].CharHT;
                      ptrDD^.cdepth:=FChar[j].CharDP;
                 end
                 else begin
                      ErrorLog('Character '+ConvChar(j)
                               +' from the font D '+ConvByte(nfont)
                               +' is not defined.');
                      ptrDD^.cwidth:=0.0;
                      ptrDD^.cheight:=0.0;
                      ptrDD^.cdepth:=0.0;
                 end;
              end;
              ptrDD:=ptrDD^.ptrNext;
         end;
     end; {for i}

     {----- Convert Characters ------}
     for i:=0 to 255 do
     with FChar[i] do
     begin
         if included then
         if CharReMap[i] = nil then
         begin
              ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
              ErrorLog('               no reference for ptototype.');
              included:=false; FlagError:=true;
         end
         else begin
               if FlAddParm = 1 then {NextLarger}
               begin
                  if not (FChar[NextLarger].included) then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [NEXTLARGER '+ConvChar(NextLarger)+'] which is not included.');
                       ErrorLog('               Attribute NEXTLARGER is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else if CharReMap[NextLarger] = nil then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [NEXTLARGER '+ConvChar(NextLarger)+'] which has no ptototype.');
                       ErrorLog('               Attribute NEXTLARGER is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else begin
                       NextLarger:=CharReMap[NextLarger]^.charmap;
                  end;
               end; {FlAddParm = 1}

               if FlAddParm in [2, 3] then {VarChar}
               begin

                  if Top <> 0 then
                  begin
                  if not (FChar[Top].included) then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/TOP '+ConvChar(Top)+' ] which is not included.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else if CharReMap[Top] = nil then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/TOP '+ConvChar(Top)+'] which has no ptototype.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else begin
                       Top:=CharReMap[Top]^.charmap;
                  end;
                  end;

                  if Mid <> 0 then
                  begin
                  if not (FChar[Mid].included) then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/MID '+ConvChar(Mid)+'] which is not included.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else if CharReMap[Mid] = nil then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/MID '+ConvChar(Mid)+'] which has no ptototype.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else begin
                       Mid:=CharReMap[Mid]^.charmap;
                  end;
                  end;

                  if Bot <> 0 then
                  begin
                  if not (FChar[Bot].included) then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/BOT '+ConvChar(Bot)+'] which is not included.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else if CharReMap[Bot] = nil then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/BOT '+ConvChar(Bot)+'] which has no ptototype.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else begin
                       Bot:=CharReMap[Bot]^.charmap;
                  end;
                  end;

               end; {FlAddParm = 2, 3}

               if FlAddParm = 3 then {VarChar + REP}
               begin

                  if not (FChar[Rep].included) then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/REP '+ConvChar(Rep)+'] which is not included.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else if CharReMap[Rep] = nil then
                  begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has');
                       ErrorLog('               the reference [VARCHAR/REP '+ConvChar(Rep)+'] which has no ptototype.');
                       ErrorLog('               Attribute VARCHAR is discarded.');
                       FlAddParm:=0; FlagError:=true;
                  end
                  else begin
                       Rep:=CharReMap[Rep]^.charmap;
                  end;

               end; {FlAddParm = 3}

         end; {if included}
     end; {for i}

     {--- remap characters ---}
     for i:=0 to 255 do
     with FChar[i] do
     begin
         if included then
         begin
               ptrC:=CharReMap[i];
               if ptrC = nil then
               begin
                       ErrorLog('*** Error : Character '+ConvChar(i)+' in font D '+ConvInt(nfont)+' has no prototype.');
                       ErrorLog('               Character is discarded.');
                       FlagError:=true;
               end;

               while ptrC <> nil do
               begin

                    k:=ptrC^.charmap;

                    with CharDataGlb^[k] do
                    begin

                         if not FlCharWD then CharWD:=FChar[i].CharWD;
                         if not FlCharHT then CharHT:=FChar[i].CharHT;
                         if not FlCharDP then CharDP:=FChar[i].CharDP;
                         if not FlCharIC then CharIC:=FChar[i].CharIC;

                         if not FlTop then Top:=FChar[i].Top;
                         if not FlMid then Mid:=FChar[i].Mid;
                         if not FlBot then Bot:=FChar[i].Bot;
                         if not FlRep then Rep:=FChar[i].Rep;

                         if FlNextLarger or FlVarChar then
                         begin
                              if FChar[i].FlAddParm <> 0 then
                              begin
                                   ErrorLog('*** Warning : Character '+ConvChar(k)
                                         +' already has attribute VARCHAR/NEXTLARGER.');
                                   ErrorLog('              Original attribute for char '
                                         +ConvChar(i)+' in font D '+ConvInt(nfont)+' is deleted.');
                                   FlagError:=true;
                              end;
                         end
                         else begin
                              FlAddParm:=FChar[i].FlAddParm;
                              NextLarger:=FChar[i].NextLarger;
                         end;

                    end;

                    ptrC:=ptrC^.ptrNext;

               end; {while}

         end; {if include}
     end; {for i}


     {--- set sizechar ---}
     for i:=0 to 255 do
     with CharDataGlb^[i] do
     begin

        if DefPKWidth then fl:=false
                      else fl:=(marked = CharUsed);

        if fl and (mapfont = nfont) then
        begin
          j:=mapchar;
          if FChar[j].defined then
          begin
               PKWidth:=FChar[j].CharWD;
          end
          else begin
               ErrorLog('*** Error : Character '+ConvChar(j)+' in font D '+ConvInt(nfont)+' is not defined.');
               ErrorLog('      PKWIDTH value for the character '+ConvChar(i)+' is set to 0.0');
               FlagError:=true; PKWidth:=0.0;
          end;
        end; {--- set char size ---}
     end;

     {---- delete conversion table ----}
     for i:=0 to 255 do
     begin
          ptrC:=CharReMap[i];
          while ptrC <> nil do
          begin
               ptrCH:=ptrC;
               ptrC:=ptrC^.ptrNext;
               dispose(ptrCH);
          end; {while}
     end; {for i}

     FLig:=nil; FLigB:=nil;

end; {JoinFont}

