{$A+,B+,D+,E+,F-,I+,L-,N-,O-,R+,S+,V+}
{$M 16384,655360}
{ Checking of DVI files for characters of CS fonts with code > 127     }
{ Substitution of font names                                           }
{  Prague, March 31, 1993            Oldrich Ulrych                    }
{ Current page printing added on January 1, 1994                       }


program dviout;

uses dos,use32,ouunit,fordviou;

const PROGNAME  = 'DVI-OUT2';             { name of this program   }
      PROGVER   = '1.1 (March 31,1993, upgrade January 1994,';
      OSVER     = '              upgraded and compiled for OS/2 March 19, 2000)';
      PROGTYPE  = 'checking of DVI files for characters with code above 127';
      SUBFDEF   = 'SUBST.DVO';           { default name for substitution file}
      BMAX      = 30000;                 { length of working buffers (<60000)}
      RECMAX    =  1000;                 { maximum of substituted fonts }
      FMAX      =  1000;                 { maximum of fonts used in dvi }
      COMMCHARS = ['#','%'];             { comment characters in subst. file}
      SPACES    = [' '];                 { characters behaving as spaces }
      fex       : boolean = false;       { output file exists }
      sub       : boolean = false;       { substitution file exists}
      check     : boolean = false;       { checking only, no changes }
      log       : boolean = false;       { not to do the log file }
      csfonts   : boolean = false;       { default is cs -> cm }

type  pbuf      = array[0..BMAX] of byte;{ type of working arrays }

var   bufi, bufo   : ^pbuf;              { input and output buffer }
      nfi, nfo     : string;             { names of input and output files }
      nfs, nft     : string;             { names of sub and temp. file}
      fi, fo       : file;               { input and output files }
      pib, nib     : word;               { first and free pointers of input }
      nob          : word;               { free pointer in output }
      iw           : word;               { current pointer in input buffer }
      li           : longint;            { length of input file}
      pbop         : longint;            { previous begin of the page }
      po           : longint;            { pointer in output file }
      i,j          : byte;               { auxiliary counters}
      fnum         : array[1..FMAX] of longint; { numbers of defined fonts}
      fpoint       : array[1..FMAX] of word;    { pointer to subst. table }
      fchar        : array[1..FMAX] of longint; { character above 127}
      nfon         : word;               { length of defined font table}
      curfont   : longint;               { number of current font }
      issubst   : boolean;               { true if curfont is substituted }
      haltcode  : integer;
        auxs     : string;
        ftemp    : string;
        dt       : datetime;
        fr       : searchrec;
        pb       : byte;
        ii, io, ik: byte;
        iv       : longint;

procedure typeinfo(haltcode:integer);     { writes help                      }
begin;                                    { and halts with exit code HALTCODE}
writeln;
writeln(PROGTYPE);
writeln;
writeln('     '+PROGNAME+' [options] i_file [options] [o_file] [options]');
writeln;
writeln('options:');
writeln;
writeln('-s[:sub_file]   file with substitutions (default SUBST.DVO) ');
writeln('-c              no substitution is done (dvi file is unchanged)    ');
writeln('-l              makes the log file (dvi-out.dlg)');
writeln('-m              cm fonts are substituted by cs fonts ');
writeln('                according to the default table');
writeln;
if haltcode >= 0 then halt(haltcode);
end;

function foundonpath(name,path: string; var filename: string): boolean;
var found    : boolean;
    subpath  : string;
    i        : integer;
    foundf   : searchrec;
begin; found := false;
if path[length(path)] <> ';' then path := path + ';';
findfirst(name,anyfile-directory,foundf);
if doserror = 0 then begin; found := true; filename := subpath; end;
while (length(path) > 0) and not found do
  begin;  i := pos(';',path);
  subpath := copy(path,1,i-1);  delete(path,1,i);
  if subpath[length(subpath)] <> '\' then subpath := subpath + '\';
  subpath := subpath + name;
  findfirst(subpath,anyfile-directory,foundf);
  if doserror = 0 then begin; found := true; filename := subpath; end;
  end;
foundonpath := found;
end;

procedure commandline(var nfi,nfo:string; { name of input and output file }
          var nfs:string;                 { name of file with substitutions}
          var fex,sub,check:boolean);     { output exists, given sub,only check}
var dir     : dirstr;
    name    : namestr;
    ext     : extstr;
    found   : searchrec;
    option  : string;
    optstr  : string;
    i, k : integer;
begin;  nfi := '';  nfo := '';            { names of input and output files }
i := 1; k := 0;
while (i <= paramcount) do
  if commandstr(i,option) then
    begin;
    if length(option) = 0 then typeinfo(2);
    fsplit(option,dir,name,ext);
    if (length(nfi) = 0) and (ext = '') then ext := '.dvi';
    findfirst(dir+name+ext,anyfile,found);
    if (doserror <> 0) and (length(nfi) = 0) then typeinfo(3);
    if (length(nfi) > 0) and (doserror = 0) then fex := true;
    option := dir+name+ext;
    if length(nfo) > 0 then typeinfo(1)
    else
      if length(nfi) > 0 then nfo := option
      else nfi := option;
    end;
if length(nfi) = 0 then typeinfo(1);
if length(nfo) = 0 then begin; nfo := nfi; fex := true; end;
i := 1;  nfs := '';
while (i <= paramcount) do
 if commandopt(i,option,optstr) then
   begin;
   if length(option) = 1 then
     case option[1] of
       'c','C': check := true;
       'l','L': log := true;
       'm','M': csfonts := true;
       's','S': begin; if length(optstr) = 0 then optstr := SUBFDEF;
                findfirst(optstr,anyfile-directory,found);
                if doserror <> 0 then
                  if foundonpath(optstr,getenv('PATH'),optstr) then
                  else
                         begin;
                         writeln('Substitution file  '+optstr+'  not found.');
                         halt(3);
                         end;
                nfs := optstr;
                sub := true;
                end;
                         else     begin;
                                  writeln('BAD COMMAND LINE OF '+PROGNAME);
                                  for i := 1 to paramcount do write(paramstr(i)+' ');
                                  writeln;
                                  halt(1); end;
       end;
  end;
end;

procedure writeoutput(var nob,pib,iw:word);    { writes block to output}
begin;
move(bufi^[pib],bufo^[nob],iw-pib); inc(nob,iw-pib); pib := iw;
{$I-}
blockwrite(fo,bufo^[0],nob);
{$I+}
if IOresult > 0 then
  begin; writeln('Write device error - space ?'); halt(6); end;
nob := 0;
end;

procedure readinput(var li:longint;
                    var pib,nib,nob,iw:word); { reads blok from input}
var maxr : word;
begin;
writeoutput(nob,pib,iw);
move(bufi^[pib],bufi^[0],nib-pib);
nib := nib-pib;  pib := 0;
maxr := BMAX - nib; iw := 0;
if maxr > li then maxr := li;
dec(li,maxr);
blockread(fi,bufi^[nib],maxr);
inc(nib,maxr);
end;

procedure scansubstfile(substfile:string;
          var nrec:integer;
          var sbr:rsbr);
const lno : integer = 0;     { line number of input file }
var nft : text;
    row : string;
    i   : longint;
  function findspace(var row:string):string;
  var i:integer;
  begin; i := 1;
  while (i <= length(row)) and not (row[i] in SPACES) do inc(i);
  findspace := copy(row,1,i-1); delete(row,1,i-1);
  while (length(row) > 0) and (row[1] in SPACES) do delete(row,1,1);
  end;
begin; nrec := 0;
assign(nft,substfile);  reset(nft);
while not eof(nft) do
  begin;  readln(nft,row); inc(lno);
  while (length(row) > 0) and (row[1] in SPACES) do delete(row,1,1);
  i := 1; while (i <= length(row)) and not (row[i] in COMMCHARS) do inc(i);
  if i <= length(row) then delete(row,i,255);
  if length(row) > 0 then
    begin; inc(nrec);
    sbr[nrec].ni := findspace(row);
    if length(row) = 0 then begin; writeln('Error in line: ',lno); halt(3); end;
    sbr[nrec].no := findspace(row);
    if length(row) = 0 then
                        with sbr[nrec] do begin; ch1 := 0; ch3 := 0; end
    else
      with sbr[nrec] do
        begin; auxs := {'00000000000'+}findspace(row);
                                val(auxs,ch1,i);
        if i <> 0 then begin; ch1 := 0; writeln('Error in line: ',lno,i:3); end;
      end;
    end;
  end;
close(nft);
end;

procedure inciwpo(amount: word);
begin;
inc(po,amount); inc(iw,amount);
end;

function bytestoint(iw:word; k:byte):longint;
var res : longint;
    i   : byte;
begin; res := 0;
for i := 1 to k do res := res * 256 + bufi^[iw+i];
bytestoint := res;
end;

procedure wrong(bytes:byte; code: byte; errst:string);
begin;
end;

procedure fontset(jump:byte; fontnum:longint);
begin;  { fontnum je cislo fontu, ktery se voli jako aktualni}
inciwpo(jump);
end;

procedure fontdef(jump:byte);
var nof : longint;
    name: string;
    j,ka: integer;
    found: boolean;
    lpath: byte;
begin;  { jump je delka v bytech, ktera udava cislo noveho fontu}
nof := bytestoint(iw,jump);
name[0]  := chr(bufi^[iw+jump+14]);
move(bufi^[iw+jump+15],name[1],ord(name[0]));
lpath := bufi^[iw+jump+13];
found := false;
j := 0;
while (j < nfon) and not found do
  begin; inc(j);
  if fnum[j] = nof then found := true;
  end;
if not found then
  begin; inc(nfon);
  fnum[nfon] := nof; fpoint[nfon] := 0; fchar[nfon] := 0;
  found := false; j := 1;
  while not found and (j <= nrec) do
    begin; if name = sbr[j].ni then found := true;
    inc(j);
    end;
  if found then
                begin; dec(j); fpoint[nfon] := j;
                end
        else j := 0;
        end
else j := fpoint[j];
if not check and (j <> 0) then
  begin; inciwpo(jump+1);
  move(sbr[j].chksum,bufi^[iw],4);
  inciwpo(13);
  writeoutput(nob,pib,iw); ka := length(sbr[j].no);
        pib := pib + bufi^[iw] - ka;
        iw := iw + bufi^[iw] - ka;
  bufi^[iw] := ka;
  inciwpo(1+lpath);
  move(sbr[j].no[1],bufi^[iw],ka);
  inciwpo(ka);
  end
else inciwpo(15+jump+bufi^[iw+jump+14]+bufi^[iw+jump+13]);
end;

procedure incchar(num:word);
begin;
if issubst then inc(fchar[curfont]);
inciwpo(num);
end;

procedure lookforfont(byt:byte; fon:longint);
var i: integer;
begin; i := 1; curfont := -1; issubst := false;
while i <= nfon do
  begin;
        if fon = fnum[i] then
    begin; curfont := i;
        if fpoint[i] <> 0 then issubst := true;
    i := 10000;
        end;
  inc(i);
  end;
if curfont < 0 then
        begin; writeln('  Corrupted dvi file!.'); {halt(4);} end;
inciwpo(byt);
end;

procedure writelog;
var fo : text;
    i  : integer;
    j  : integer;
begin;
if log then writeln(' Making log file ...') else writeln;
if log then
        begin; assign(fo,PROGNAME+'.dlg'); rewrite(fo);
        writeln(fo,'Input file:        '+nfi);
        writeln(fo,'Output file:       '+nfo);
        write  (fo,'Temporary file:    ');
        if fex then writeln(fo,FTEMP) else writeln(fo,nfo);
        writeln(fo,'Substitution file: '+nfs);
        writeln(fo);
        writeln(fo,'Font      ->  Substituted   Total characters above 127');
        end;
writeln('Input file:        '+nfi);
writeln('Output file:       '+nfo);
write  ('Temporary file:    ');
if fex then writeln(FTEMP) else writeln(nfo);
writeln('Substitution file: '+nfs);
writeln;
writeln('Font      ->  Substituted   Total characters above 127');
for i := 1 to nfon do
  begin;  j := fpoint[i];
        if j > 0 then
    with sbr[j] do
      begin;
                        write(copy(ni+'          ',1,10)+'->  '+
                                copy(no+'          ',1,10),fchar[i]:15);
                        if fchar[i] > 0 then writeln('  !!!') else writeln;
                        if log then write(fo,copy(ni+'          ',1,10)+'->  '+
                                copy(no+'          ',1,10),fchar[i]:15);
                        if log then if fchar[i] > 0 then writeln(fo,'  !!!') else writeln(fo);
      end;
        end;
if log then
        begin; writeln(fo); writeln(fo,'End of log file.'); close(fo); end;
writeln; writeln('End of translation.');
end;

begin;
writeln;writeln(PROGNAME+' '+PROGVER); writeln(OSVER);
if paramcount = 0 then typeinfo(1);
new(bufi);  new(bufo);
ftemp := ''; nrec := 0;
while ftemp = '' do
        begin;
        with dt do gettime(hour,min,sec,iw);
        with dt do getdate(year,month,day,nfon);
        with dt do
                begin; hour := hour + iw; min := min + iw; sec := sec + iw; end;
        packtime(dt,li);
        str(li,ftemp);
        if length(ftemp) > 11 then delete(ftemp,12,255);
        if length(ftemp) > 8 then ftemp := copy(ftemp,1,8)+'.'+copy(ftemp,9,3);
        findfirst(ftemp,anyfile-directory-hidden-sysfile,fr);
        if doserror = 0 then begin; ftemp := ''; inc(nrec); end;
        if nrec > 1000 then
                begin; writeln('Impossible to create the name of temporary file.');
                halt(6);
                end;
        end;
commandline(nfi,nfo,nfs,fex,sub,check);
defaultsub(nrec,sbr,csfonts);
for i := 1 to nrec do  begin; fchar[i] := 0; fnum[i] := 0; end;
if sub then
   scansubstfile(nfs,nrec,sbr);
convsbr(nrec,sbr);
if fex then assign(fo,FTEMP) else assign(fo,nfo);
assign(fi,nfi); reset(fi,1); rewrite(fo,1);
li := filesize(fi); pib := 0; nib := 0; iw := 0; nob := 0; pbop := -1; po := 0;
nfon := 0;
while (pib < nib) or (li > 0) do
        begin; if (nib - iw < 500) and (li > 0) then
                readinput(li,pib,nib,nob,iw);
  case bufi^[iw] of
    0..127,138,140,141,142,147,
    152,161,166             : begin; inc(iw); inc(po); end;
    128,133                 : incchar(2);
    129,134                 : incchar(3);
    130,135                 : incchar(4);
    131,136                 : incchar(5);
    132,137                 : inciwpo(9);
    139                     : begin; {bop}
                              move(pbop,bufi^[iw+41],4);
                                pb := bufi^[iw+41]; bufi^[iw+41] := bufi^[iw+44]; bufi^[iw+44] := pb;
                                pb := bufi^[iw+42]; bufi^[iw+42] := bufi^[iw+43]; bufi^[iw+43] := pb;
                              ii  := 40;
                              while((ii>0) and (bufi^[iw+ii]=0)) do ii:=ii-1;
                              if ii < 41 then io := 1 else io := 0;
                              if io > 0 then write('[');
                              ik := 1;
                              while (ik <= ii) do
                                 begin;
                                 iv := bufi^[iw+ik];
                                 iv := 256*iv + bufi^[iw+ik+1];
                                 iv := 256*iv + bufi^[iw+ik+2];
                                 iv := 256*iv + bufi^[iw+ik+3];
                                 write(iv);
                                 ik:=ik+4;
                                 if (ik<=ii) then write('.');
                                 end;
                              if io > 0 then write(']');
                              pbop := po;
                              inciwpo(45);
                              end;
    143,148,153,157,162,167 : inciwpo(2);
    144,149,154,158,163,168 : inciwpo(3);
    145,150,155,159,164,169 : inciwpo(4);
    146,151,156,160,165,170 : inciwpo(5);
                171..234                : lookforfont(1,bufi^[iw]-171);
                235                     : lookforfont(2,bufi^[iw+1]);
                236                     : lookforfont(3,bytestoint(iw,2));
    237                     : lookforfont(4,bytestoint(iw,3));
    238                     : lookforfont(5,bytestoint(iw,4));
    239                     : inciwpo(2+bufi^[iw+1]);
    240                     : inciwpo(3+bytestoint(iw,2));
    241                     : inciwpo(4+bytestoint(iw,3));
    242                     : inciwpo(5+bytestoint(iw,4));
    243                     : fontdef(1);
    244                     : fontdef(2);
    245                     : fontdef(3);
    246                     : fontdef(4);
    247                     : inciwpo(15+bufi^[iw+14]);
    248                     : begin; {postamble}
                              move(pbop,bufi^[iw+1],4);
                pb := bufi^[iw+1]; bufi^[iw+1] := bufi^[iw+4]; bufi^[iw+4] := pb;
                pb := bufi^[iw+2]; bufi^[iw+2] := bufi^[iw+3]; bufi^[iw+3] := pb;
                              pbop := po;
                              inciwpo(29);
                              end;
    249                     : begin; {postpostamble}
                              move(pbop,bufi^[iw+1],4);
                pb := bufi^[iw+1]; bufi^[iw+1] := bufi^[iw+4]; bufi^[iw+4] := pb;
                pb := bufi^[iw+2]; bufi^[iw+2] := bufi^[iw+3]; bufi^[iw+3] := pb;
                              inciwpo(6);
                              j := 8 - po mod 4;
                              for i := 0 to j-1 do bufi^[iw+i] := 223;
                              inciwpo(j);
                              end;
    else                      wrong(1,1,'Undefined dvi command.');
    end;
    if nib <= iw then writeoutput(nob,pib,iw);
  end;
close(fo);  close(fi);
if fex then
        begin; assign(fi,nfo); erase(fi); rename(fo,nfo); end;
haltcode := 0;
for i := 1 to nrec do
  begin;
  if (fchar[i] > 0) and (fpoint[i] > 0) then
    begin; haltcode := 8;
    writeln('In font '+sbr[fpoint[i]].no+' is ',fchar[i],
                                                                ' char(s) with code above 127.');
                end;
  end;
writelog;
halt(haltcode);
end.

