unit AppearanceDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, Dialogs,
  RichEdit, Messages;

type
  TAppearanceDialog = class(TForm)
    DemoEdit: TRichEdit;
    ColorDialog1: TColorDialog;
    StandardFontDialog: TFontDialog;
    TeXFontDialog: TFontDialog;
    ParenthesisFontDialog: TFontDialog;
    SquareBracketFontDialog: TFontDialog;
    CommentFontDialog: TFontDialog;
    RoundBracketFontDialog: TFontDialog;
    DollarFontDialog: TFontDialog;
    OKBtn: TButton;
    CancelBtn: TButton;
    Button4: TButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    procedure UpdateSyntaxColoring;
  public
    standardFont: TFont;
    texCommandFont: TFont;
    parenthesisFont: TFont;
    squareBracketFont: TFont;
    roundBracketFont: TFont;
    dollarFont: TFont;
    commentFont: TFont;
  end;

var
  AppearanceDialog: TAppearanceDialog;

implementation

{$R *.DFM}

procedure TAppearanceDialog.Button4Click(Sender: TObject);
begin
  if ColorDialog1.Execute then
  begin
    DemoEdit.Color := ColorDialog1.Color;
  end;
end;

procedure TAppearanceDialog.FormCreate(Sender: TObject);
begin
  standardFont := TFont.Create;
  parenthesisFont := TFont.Create;
  texCommandFont := TFont.Create;
  squareBracketFont := TFont.Create;
  roundBracketFont := TFont.Create;
  dollarFont := TFont.Create;
  commentFont := TFont.Create;
end;

procedure TAppearanceDialog.Button1Click(Sender: TObject);
begin
  StandardFontDialog.Font := standardFont;
  if StandardFontDialog.Execute then
  begin
    standardFont := StandardFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

procedure TAppearanceDialog.Button2Click(Sender: TObject);
begin
  TeXFontDialog.Font := texCommandFont;
  if TeXFontDialog.Execute then
  begin
    texCommandFont := TeXFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

procedure TAppearanceDialog.Button3Click(Sender: TObject);
begin
  CommentFontDialog.Font := commentFont;
  if CommentFontDialog.Execute then
  begin
    commentFont := CommentFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

procedure TAppearanceDialog.Button5Click(Sender: TObject);
begin
  ParenthesisFontDialog.Font := parenthesisFont;
  if ParenthesisFontDialog.Execute then
  begin
    parenthesisFont := ParenthesisFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

procedure TAppearanceDialog.Button6Click(Sender: TObject);
begin
  SquareBracketFontDialog.Font := squareBracketFont;
  if SquareBracketFontDialog.Execute then
  begin
    squareBracketFont := SquareBracketFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

procedure TAppearanceDialog.Button7Click(Sender: TObject);
begin
  RoundBracketFontDialog.Font := roundBracketFont;
  if RoundBracketFontDialog.Execute then
  begin
    roundBracketFont := RoundBracketFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

procedure TAppearanceDialog.Button8Click(Sender: TObject);
begin
  DollarFontDialog.Font := dollarFont;
  if DollarFontDialog.Execute then
  begin
    dollarFont := DollarFontDialog.Font;
    UpdateSyntaxColoring;
  end;
end;

const KeyChars = ['a'..'z', 'A'..'Z', '0'..'9', '@', #128..#255];
      SpecialChars = ['\', '{', '}', '[', ']', '(', ')', '%', '$'];

procedure TAppearanceDialog.UpdateSyntaxColoring;
var start, doSel: integer;
    position: integer;
    textLength: integer;

  procedure SetFont(theFont: TFont);
  begin
    with DemoEdit.SelAttributes do
    begin
      Color  := theFont.Color;
      Size   := theFont.Size;
      Name   := theFont.Name;
      Style  := theFont.Style;
      Charset := theFont.Charset;
    end;
  end;

begin
  start := 0;
  Textlength := DemoEdit.GetTextLen;
  DemoEdit.SelLength := 0;
  try
    DemoEdit.Lines.BeginUpdate;
    position := start + 1;
    SetFont(standardFont);

    { update selection }
    while position <= textLength do
    begin
      DemoEdit.SelLength := 0;
      DemoEdit.SelStart := position - 1;
      doSel := 0;
      while not (DemoEdit.Text[position + doSel] in SpecialChars) do INC(doSel);
      if doSel > 0 then
      begin
        DemoEdit.SelLength := doSel;
        SetFont(standardFont);
        position := position + doSel;
        DemoEdit.SelLength := 0;
        DemoEdit.SelStart := position - 1;
      end;
      case DemoEdit.Text[position] of
        '%': begin
               doSel := 0;
               while (DemoEdit.Text[position+doSel] <> #13)
                     and (position + doSel < textLength) do
                 INC(doSel);
               DemoEdit.SelLength := doSel;
               SetFont(commentFont);
               position := position + doSel;
             end;
        '\': begin
               doSel := 1; //at least the \ ...
               while (DemoEdit.Text[position+doSel] in KeyChars )
                     and (position + doSel < textLength) do
                 INC(doSel);
               DemoEdit.SelLength := doSel;
               SetFont(TeXCommandFont);
               position := position + doSel;
             end;
        '{', '}', '[', ']', '(', ')', '$': begin
               DemoEdit.SelLength := 1;
               case DemoEdit.Text[position] of
                 '{', '}': SetFont(ParenthesisFont);
                 '[', ']': SetFont(squareBracketFont);
                 '(', ')': SetFont(roundBracketFont);
                 '$'     : SetFont(dollarFont);
               end;
               INC(position);
             end;
      end; {case}
    end;
  finally
    DemoEdit.SelLength :=0;
    DemoEdit.SelStart := 0;
    DemoEdit.Lines.EndUpdate;
  end;
end;


procedure TAppearanceDialog.FormActivate(Sender: TObject);
begin
  UpdateSyntaxColoring;
end;

end.
